/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.injection.MarkdownCodeFenceUtils;
import org.intellij.plugins.markdown.injection.alias.LanguageGuesser;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceImpl;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00050\u0004H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/injection/CodeFenceInjector;", "Lcom/intellij/lang/injection/MultiHostInjector;", "()V", "elementsToInjectIn", "", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "findLangForInjection", "Lcom/intellij/lang/Language;", "element", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl;", "getLanguagesToInject", "", "registrar", "Lcom/intellij/lang/injection/MultiHostRegistrar;", "host", "injectAsOnePlace", "Companion", "intellij.markdown"})
public class CodeFenceInjector
implements MultiHostInjector {
    private static final List<Class<MarkdownCodeFenceImpl>> toInject;
    public static final Companion Companion;

    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        return toInject;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        block7: {
            block6: {
                boolean bl;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
                    Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                    if (!(host instanceof MarkdownCodeFenceImpl) || !((MarkdownCodeFenceImpl)host).isValidHost()) break block6;
                    PsiElement[] psiElementArray = ((MarkdownCodeFenceImpl)host).getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"host.children");
                    PsiElement[] $this$all$iv = psiElementArray;
                    boolean $i$f$all = false;
                    PsiElement[] psiElementArray2 = $this$all$iv;
                    int n = psiElementArray2.length;
                    for (int i = 0; i < n; ++i) {
                        PsiElement element$iv;
                        PsiElement it = element$iv = psiElementArray2[i];
                        boolean bl2 = false;
                        PsiElement psiElement = it;
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it");
                        IElementType iElementType = MarkdownTokenTypes.CODE_FENCE_CONTENT;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypes.CODE_FENCE_CONTENT");
                        if (!PsiUtilsKt.hasType(psiElement, iElementType)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
                if (!bl) break block7;
            }
            return;
        }
        Language language = this.findLangForInjection((MarkdownCodeFenceImpl)host);
        if (language == null) {
            return;
        }
        Language language2 = language;
        registrar.startInjecting(language2);
        this.injectAsOnePlace((MarkdownCodeFenceImpl)host, registrar);
        registrar.doneInjecting();
    }

    @Nullable
    protected Language findLangForInjection(@NotNull MarkdownCodeFenceImpl element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getFenceLanguage();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.fenceLanguage ?: return null");
        String name = string;
        Language language = LanguageGuesser.guessLanguageForInjection(name);
        boolean bl = false;
        boolean bl2 = false;
        Language it = language;
        boolean bl3 = false;
        MarkdownApplicationSettings markdownApplicationSettings = MarkdownApplicationSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)markdownApplicationSettings, (String)"MarkdownApplicationSettings.getInstance()");
        return !markdownApplicationSettings.isDisableInjections() ? language : null;
    }

    private final void injectAsOnePlace(MarkdownCodeFenceImpl host, MultiHostRegistrar registrar) {
        List<PsiElement> list = MarkdownCodeFenceUtils.getContent(host, true);
        if (list == null) {
            return;
        }
        List<PsiElement> elements = list;
        PsiElement first = (PsiElement)CollectionsKt.first(elements);
        PsiElement last = (PsiElement)CollectionsKt.last(elements);
        registrar.addPlace(null, null, (PsiLanguageInjectionHost)host, TextRange.create((int)first.getStartOffsetInParent(), (int)(last.getStartOffsetInParent() + last.getTextLength())));
    }

    static {
        Companion = new Companion(null);
        toInject = CollectionsKt.listOf(MarkdownCodeFenceImpl.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/injection/CodeFenceInjector$Companion;", "", "()V", "toInject", "", "Ljava/lang/Class;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl;", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

