/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.jcef.mermaid;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.extensions.MarkdownCodeFenceCacheableProvider;
import org.intellij.plugins.markdown.extensions.MarkdownExtensionWithExternalFiles;
import org.intellij.plugins.markdown.extensions.jcef.MarkdownJCEFPreviewExtension;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownCodeFencePluginCacheCollector;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0000\u0018\u0000 62\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u00016B\u0011\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\tH\u0016J \u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020$2\u0006\u0010(\u001a\u00020\tH\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010&\u001a\u00020\tH\u0016J\b\u0010/\u001a\u00020\u0015H\u0016J\u0016\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u000203J\u0010\u00104\u001a\u00020\u00152\u0006\u00105\u001a\u00020\tH\u0002R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR,\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00150\u00140\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u0014\u0010\u001a\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 \u00a8\u00067"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/mermaid/MermaidCodeGeneratingProviderExtension;", "Lorg/intellij/plugins/markdown/extensions/MarkdownCodeFenceCacheableProvider;", "Lorg/intellij/plugins/markdown/extensions/jcef/MarkdownJCEFPreviewExtension;", "Lorg/intellij/plugins/markdown/extensions/MarkdownExtensionWithExternalFiles;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "collector", "Lorg/intellij/plugins/markdown/ui/preview/html/MarkdownCodeFencePluginCacheCollector;", "(Lorg/intellij/plugins/markdown/ui/preview/html/MarkdownCodeFencePluginCacheCollector;)V", "description", "", "getDescription", "()Ljava/lang/String;", "displayName", "getDisplayName", "downloadFilename", "getDownloadFilename", "downloadLink", "getDownloadLink", "events", "", "Lkotlin/Function1;", "", "getEvents", "()Ljava/util/Map;", "id", "getId", "resourceProvider", "getResourceProvider", "()Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "scripts", "", "getScripts", "()Ljava/util/List;", "styles", "getStyles", "afterDownload", "", "canProvide", "resourceName", "generateHtml", "language", "raw", "node", "Lorg/intellij/markdown/ast/ASTNode;", "isApplicable", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "onLAFChanged", "store", "key", "content", "", "storeFileEvent", "data", "Companion", "intellij.markdown"})
public final class MermaidCodeGeneratingProviderExtension
extends MarkdownCodeFenceCacheableProvider
implements MarkdownJCEFPreviewExtension,
MarkdownExtensionWithExternalFiles,
ResourceProvider {
    @NotNull
    private final List<String> scripts;
    @NotNull
    private final List<String> styles;
    @NotNull
    private final Map<String, Function1<String, Unit>> events;
    @NotNull
    private final String displayName;
    @NotNull
    private final String id;
    @NotNull
    private final String description;
    @NotNull
    private final String downloadLink;
    @NotNull
    private final String downloadFilename;
    @NotNull
    private final ResourceProvider resourceProvider;
    private static final String MAIN_SCRIPT_FILENAME = "mermaid/mermaid.js";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<String> getScripts() {
        return this.scripts;
    }

    @Override
    @NotNull
    public List<String> getStyles() {
        return this.styles;
    }

    @Override
    @NotNull
    public Map<String, Function1<String, Unit>> getEvents() {
        return this.events;
    }

    @Override
    public boolean isApplicable(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return this.isEnabled() && this.isAvailable() && Intrinsics.areEqual((Object)language, (Object)"mermaid");
    }

    @Override
    @NotNull
    public String generateHtml(@NotNull String language, @NotNull String raw, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String hash = MarkdownUtil.INSTANCE.md5(raw, "");
        File key = this.getUniqueFile("mermaid", hash, "svg").toFile();
        if (key.exists()) {
            return "<img src=\"" + key.toURI() + "\"/>";
        }
        return "<div class=\"mermaid\" cache-id=\"" + hash + "\" id=\"" + hash + "\">" + raw + "</div>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void store(@NotNull String key, @NotNull byte[] content) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            File actualKey = this.getUniqueFile("mermaid", key, "svg").toFile();
            FileUtil.createParentDirs((File)actualKey);
            File file = actualKey;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"actualKey");
            Object object = file;
            int n = 0;
            object = new FileOutputStream((File)object);
            n = 8192;
            boolean bl = false;
            object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
            n = 0;
            bl = false;
            Throwable throwable = null;
            try {
                BufferedOutputStream it = (BufferedOutputStream)object;
                boolean bl2 = false;
                it.write(content);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            MarkdownCodeFencePluginCacheCollector markdownCodeFencePluginCacheCollector = this.getCollector();
            if (markdownCodeFencePluginCacheCollector == null) break block6;
            MarkdownCodeFencePluginCacheCollector.addAliveCachedFile$default(markdownCodeFencePluginCacheCollector, this, actualKey, 0L, 4, null);
        }
    }

    @Override
    public void onLAFChanged() {
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public String getDownloadLink() {
        return this.downloadLink;
    }

    @Override
    @NotNull
    public String getDownloadFilename() {
        return this.downloadFilename;
    }

    @Override
    public boolean afterDownload() {
        File targetFile = Paths.get(this.getDirectory().toString(), "mermaid", this.getDownloadFilename()).toFile();
        File sourceFile = new File(this.getDirectory(), this.getDownloadFilename());
        File file = targetFile;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"targetFile");
        FilesKt.copyTo$default((File)sourceFile, (File)file, (boolean)false, (int)0, (int)6, null);
        return sourceFile.delete();
    }

    @Override
    public boolean canProvide(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        return this.getScripts().contains(resourceName) || this.getStyles().contains(resourceName);
    }

    @Override
    @Nullable
    public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        if (Intrinsics.areEqual((Object)resourceName, (Object)MAIN_SCRIPT_FILENAME)) {
            return ResourceProvider.Companion.loadExternalResource$default(ResourceProvider.Companion, new File(this.getDirectory(), resourceName), null, 2, null);
        }
        return ResourceProvider.Companion.loadInternalResource$default(ResourceProvider.Companion, this.getClass(), resourceName, null, 4, null);
    }

    @Override
    @NotNull
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    private final void storeFileEvent(String data) {
        String content;
        CharSequence charSequence = data;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        String string = data;
        int n = 0;
        int n2 = StringsKt.indexOf$default((CharSequence)data, (char)';', (int)0, (boolean)false, (int)6, null);
        boolean bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String key = string3;
        String string4 = data;
        n2 = StringsKt.indexOf$default((CharSequence)data, (char)';', (int)0, (boolean)false, (int)6, null) + 1;
        bl2 = false;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n2);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        string4 = content = string6;
        Charset charset = Charsets.UTF_8;
        bl2 = false;
        String string7 = string4;
        if (string7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string7.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        this.store(key, byArray);
    }

    public MermaidCodeGeneratingProviderExtension(@Nullable MarkdownCodeFencePluginCacheCollector collector) {
        super(collector);
        this.scripts = CollectionsKt.listOf((Object[])new String[]{MAIN_SCRIPT_FILENAME, "mermaid/bootstrap.js"});
        this.styles = CollectionsKt.listOf((Object)"mermaid/mermaid.css");
        this.events = MapsKt.mapOf((Pair)TuplesKt.to((Object)"storeMermaidFile", (Object)new Function1<String, Unit>(this){

            public final void invoke(@NotNull String p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                MermaidCodeGeneratingProviderExtension.access$storeFileEvent((MermaidCodeGeneratingProviderExtension)this.receiver, p1);
            }
        }));
        String string = MarkdownBundle.message("markdown.extensions.mermaid.display.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026ns.mermaid.display.name\")");
        this.displayName = string;
        this.id = "MermaidLanguageExtension";
        String string2 = MarkdownBundle.message("markdown.extensions.mermaid.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MarkdownBundle.message(\"\u2026ons.mermaid.description\")");
        this.description = string2;
        String string3 = Registry.stringValue((String)"markdown.mermaid.download.link");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Registry.stringValue(\"ma\u2026n.mermaid.download.link\")");
        this.downloadLink = string3;
        this.downloadFilename = "mermaid.js";
        this.resourceProvider = this;
    }

    public /* synthetic */ MermaidCodeGeneratingProviderExtension(MarkdownCodeFencePluginCacheCollector markdownCodeFencePluginCacheCollector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            markdownCodeFencePluginCacheCollector = null;
        }
        this(markdownCodeFencePluginCacheCollector);
    }

    public MermaidCodeGeneratingProviderExtension() {
        this(null, 1, null);
    }

    @Override
    @NotNull
    public MarkdownBrowserPreviewExtension.Priority getPriority() {
        return MarkdownJCEFPreviewExtension.DefaultImpls.getPriority(this);
    }

    @Override
    public int compareTo(@NotNull MarkdownBrowserPreviewExtension other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return MarkdownJCEFPreviewExtension.DefaultImpls.compareTo(this, other);
    }

    @Override
    public boolean isAvailable() {
        return MarkdownExtensionWithExternalFiles.DefaultImpls.isAvailable(this);
    }

    @Override
    public boolean isEnabled() {
        return MarkdownExtensionWithExternalFiles.DefaultImpls.isEnabled(this);
    }

    @Override
    @NotNull
    public String getDirectoryName() {
        return MarkdownExtensionWithExternalFiles.DefaultImpls.getDirectoryName(this);
    }

    @Override
    @NotNull
    public File getDirectory() {
        return MarkdownExtensionWithExternalFiles.DefaultImpls.getDirectory(this);
    }

    @Override
    @NotNull
    public File getFullPath() {
        return MarkdownExtensionWithExternalFiles.DefaultImpls.getFullPath(this);
    }

    public static final /* synthetic */ void access$storeFileEvent(MermaidCodeGeneratingProviderExtension $this, String data) {
        $this.storeFileEvent(data);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/mermaid/MermaidCodeGeneratingProviderExtension$Companion;", "", "()V", "MAIN_SCRIPT_FILENAME", "", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

