/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.processor.field.WitherFieldProcessor;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WitherProcessor
extends AbstractClassProcessor {
    private static final String BUILDER_DEFAULT_ANNOTATION = "lombok.Builder.Default";

    public WitherProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.experimental.Wither", "lombok.With");
    }

    private WitherFieldProcessor getWitherFieldProcessor() {
        return (WitherFieldProcessor)ApplicationManager.getApplication().getService(WitherFieldProcessor.class);
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiAnnotation == null) {
            WitherProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            WitherProcessor.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            WitherProcessor.$$$reportNull$$$0(2);
        }
        return this.validateAnnotationOnRightType(psiClass, builder) && this.validateVisibility(psiAnnotation) && this.getWitherFieldProcessor().validConstructor(psiClass, builder);
    }

    private boolean validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiClass == null) {
            WitherProcessor.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            WitherProcessor.$$$reportNull$$$0(4);
        }
        boolean result = true;
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isEnum()) {
            builder.addError("@Wither is only supported on a class or a field.");
            result = false;
        }
        return result;
    }

    private boolean validateVisibility(@NotNull PsiAnnotation psiAnnotation) {
        String methodVisibility;
        if (psiAnnotation == null) {
            WitherProcessor.$$$reportNull$$$0(5);
        }
        return null != (methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation));
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        String methodVisibility;
        if (psiClass == null) {
            WitherProcessor.$$$reportNull$$$0(6);
        }
        if (psiAnnotation == null) {
            WitherProcessor.$$$reportNull$$$0(7);
        }
        if (target == null) {
            WitherProcessor.$$$reportNull$$$0(8);
        }
        if ((methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation)) != null) {
            AccessorsInfo accessorsInfo = AccessorsInfo.build(psiClass).withFluent(false);
            target.addAll(this.createFieldWithers(psiClass, methodVisibility, accessorsInfo));
        }
    }

    @NotNull
    private Collection<PsiMethod> createFieldWithers(@NotNull PsiClass psiClass, @NotNull String methodModifier, @NotNull AccessorsInfo accessors) {
        if (psiClass == null) {
            WitherProcessor.$$$reportNull$$$0(9);
        }
        if (methodModifier == null) {
            WitherProcessor.$$$reportNull$$$0(10);
        }
        if (accessors == null) {
            WitherProcessor.$$$reportNull$$$0(11);
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        Collection<PsiField> witherFields = this.getWitherFields(psiClass);
        for (PsiField witherField : witherFields) {
            PsiMethod method = this.getWitherFieldProcessor().createWitherMethod(witherField, methodModifier, accessors);
            if (method == null) continue;
            result.add(method);
        }
        ArrayList<PsiMethod> arrayList = result;
        if (arrayList == null) {
            WitherProcessor.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private Collection<PsiField> getWitherFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            WitherProcessor.$$$reportNull$$$0(13);
        }
        ArrayList<PsiField> witherFields = new ArrayList<PsiField>();
        for (PsiField psiField : psiClass.getFields()) {
            boolean createWither = true;
            PsiModifierList modifierList = psiField.getModifierList();
            if (null != modifierList) {
                createWither = !modifierList.hasModifierProperty("static");
                createWither &= !modifierList.hasModifierProperty("final") || !psiField.hasInitializer() || PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, BUILDER_DEFAULT_ANNOTATION) != null;
                createWither &= !psiField.getName().startsWith("$");
                createWither &= !PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiField, "lombok.experimental.Wither", "lombok.With");
            }
            if (!createWither) continue;
            witherFields.add(psiField);
        }
        ArrayList<PsiField> arrayList = witherFields;
        if (arrayList == null) {
            WitherProcessor.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        PsiClass containingClass;
        if (psiField == null) {
            WitherProcessor.$$$reportNull$$$0(15);
        }
        if (psiAnnotation == null) {
            WitherProcessor.$$$reportNull$$$0(16);
        }
        if (null != (containingClass = psiField.getContainingClass()) && PsiClassUtil.getNames(this.getWitherFields(containingClass)).contains(psiField.getName())) {
            return LombokPsiElementUsage.READ_WRITE;
        }
        return LombokPsiElementUsage.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessors";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/WitherProcessor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/WitherProcessor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldWithers";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getWitherFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateVisibility";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFieldWithers";
                break;
            }
            case 12: 
            case 14: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getWitherFields";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

