/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import de.plushnikov.intellij.plugin.problem.LombokProblem;
import de.plushnikov.intellij.plugin.problem.ProblemNewBuilder;
import de.plushnikov.intellij.plugin.processor.AbstractProcessor;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SynchronizedProcessor
extends AbstractProcessor {
    public SynchronizedProcessor() {
        super(PsiElement.class, "lombok.Synchronized");
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SynchronizedProcessor.$$$reportNull$$$0(0);
        }
        List<PsiAnnotation> list = Collections.emptyList();
        if (list == null) {
            SynchronizedProcessor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<LombokProblem> verifyAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            SynchronizedProcessor.$$$reportNull$$$0(2);
        }
        ProblemNewBuilder problemNewBuilder = new ProblemNewBuilder(2);
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiMethod.class);
        if (null != psiMethod) {
            PsiClass containingClass;
            String lockFieldName;
            if (psiMethod.hasModifierProperty("abstract")) {
                problemNewBuilder.addError("'@Synchronized' is legal only on concrete methods.", PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)psiMethod, "abstract", false, false));
            }
            if (StringUtil.isNotEmpty((String)(lockFieldName = PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, "value"))) && null != (containingClass = psiMethod.getContainingClass())) {
                PsiField lockField = containingClass.findFieldByName(lockFieldName, true);
                if (null != lockField) {
                    if (!lockField.hasModifierProperty("final")) {
                        problemNewBuilder.addWarning(String.format("Synchronization on a non-final field %s.", lockFieldName), PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)lockField, "final", true, false));
                    }
                } else {
                    PsiClassType javaLangObjectType = PsiType.getJavaLangObject((PsiManager)containingClass.getManager(), (GlobalSearchScope)containingClass.getResolveScope());
                    problemNewBuilder.addError(String.format("The field %s does not exist.", lockFieldName), PsiQuickFixFactory.createNewFieldFix(containingClass, lockFieldName, (PsiType)javaLangObjectType, "new Object()", "private", "final"));
                }
            }
        } else {
            problemNewBuilder.addError("'@Synchronized' is legal only on methods.");
        }
        Set<LombokProblem> set = problemNewBuilder.getProblems();
        if (set == null) {
            SynchronizedProcessor.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/SynchronizedProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/SynchronizedProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "verifyAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

