/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import de.plushnikov.intellij.plugin.problem.LombokProblem;
import de.plushnikov.intellij.plugin.problem.ProblemNewBuilder;
import de.plushnikov.intellij.plugin.processor.AbstractProcessor;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CleanupProcessor
extends AbstractProcessor {
    public CleanupProcessor() {
        super(PsiElement.class, "lombok.Cleanup");
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CleanupProcessor.$$$reportNull$$$0(0);
        }
        List<PsiAnnotation> list = Collections.emptyList();
        if (list == null) {
            CleanupProcessor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<LombokProblem> verifyAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            CleanupProcessor.$$$reportNull$$$0(2);
        }
        ProblemNewBuilder problemNewBuilder = new ProblemNewBuilder(2);
        PsiLocalVariable psiVariable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiLocalVariable.class);
        if (null != psiVariable) {
            String cleanupName = PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, "value");
            if (StringUtil.isEmptyOrSpaces((String)cleanupName)) {
                problemNewBuilder.addError("'@Cleanup': value cannot be the empty string");
            } else {
                this.validateCleanUpMethodExists(psiVariable, cleanupName, problemNewBuilder);
            }
            this.validateInitializerExist(problemNewBuilder, psiVariable);
        } else {
            problemNewBuilder.addError("'@Cleanup' is legal only on local variable declarations");
        }
        Set<LombokProblem> set = problemNewBuilder.getProblems();
        if (set == null) {
            CleanupProcessor.$$$reportNull$$$0(3);
        }
        return set;
    }

    private void validateCleanUpMethodExists(@NotNull PsiLocalVariable psiVariable, @NotNull String cleanupName, @NotNull ProblemNewBuilder problemNewBuilder) {
        PsiType psiType;
        if (psiVariable == null) {
            CleanupProcessor.$$$reportNull$$$0(4);
        }
        if (cleanupName == null) {
            CleanupProcessor.$$$reportNull$$$0(5);
        }
        if (problemNewBuilder == null) {
            CleanupProcessor.$$$reportNull$$$0(6);
        }
        if ((psiType = psiVariable.getType()) instanceof PsiClassType) {
            PsiClassType psiClassType = (PsiClassType)psiType;
            PsiClass psiClassOfField = psiClassType.resolve();
            if (psiClassOfField != null) {
                PsiMethod[] methods = psiClassOfField.findMethodsByName(cleanupName, true);
                boolean hasCleanupMethod = false;
                for (PsiMethod method : methods) {
                    if (0 != method.getParameterList().getParametersCount()) continue;
                    hasCleanupMethod = true;
                }
                if (!hasCleanupMethod) {
                    problemNewBuilder.addError("'@Cleanup': method '%s()' not found on target class", cleanupName);
                }
            }
        } else {
            problemNewBuilder.addError("'@Cleanup': is legal only on a local variable declaration inside a block");
        }
    }

    private void validateInitializerExist(@NotNull ProblemNewBuilder problemNewBuilder, @NotNull PsiLocalVariable psiVariable) {
        if (problemNewBuilder == null) {
            CleanupProcessor.$$$reportNull$$$0(7);
        }
        if (psiVariable == null) {
            CleanupProcessor.$$$reportNull$$$0(8);
        }
        if (!psiVariable.hasInitializer()) {
            problemNewBuilder.addError("'@Cleanup' variable declarations need to be initialized.");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/CleanupProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiVariable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanupName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemNewBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/CleanupProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "verifyAnnotation";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateCleanUpMethodExists";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateInitializerExist";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

