/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.language;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import de.plushnikov.intellij.plugin.language.LombokConfigLanguage;
import de.plushnikov.intellij.plugin.language.psi.LombokConfigProperty;
import de.plushnikov.intellij.plugin.language.psi.LombokConfigPsiUtil;
import de.plushnikov.intellij.plugin.language.psi.LombokConfigTypes;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class LombokConfigCompletionContributor
extends CompletionContributor {
    private static final String LOMBOK_EQUALS_AND_HASH_CODE_CALL_SUPER = ConfigKey.EQUALSANDHASHCODE_CALL_SUPER.getConfigKey();
    private static final String LOMBOK_TOSTRING_CALL_SUPER = ConfigKey.TOSTRING_CALL_SUPER.getConfigKey();

    public LombokConfigCompletionContributor() {
        final HashSet<String> booleanOptions = new HashSet<String>(Arrays.asList(ConfigKey.CONFIG_STOP_BUBBLING.getConfigKey(), ConfigKey.ACCESSORS_CHAIN.getConfigKey(), ConfigKey.ACCESSORS_FLUENT.getConfigKey(), ConfigKey.ANYCONSTRUCTOR_SUPPRESS_CONSTRUCTOR_PROPERTIES.getConfigKey(), ConfigKey.ANYCONSTRUCTOR_ADD_CONSTRUCTOR_PROPERTIES.getConfigKey(), ConfigKey.EQUALSANDHASHCODE_DO_NOT_USE_GETTERS.getConfigKey(), ConfigKey.GETTER_NO_IS_PREFIX.getConfigKey(), ConfigKey.LOG_FIELD_IS_STATIC.getConfigKey(), ConfigKey.TOSTRING_DO_NOT_USE_GETTERS.getConfigKey(), ConfigKey.TOSTRING_INCLUDE_FIELD_NAMES.getConfigKey(), ConfigKey.FIELDDEFAULTS_FINAL.getConfigKey(), ConfigKey.FIELDDEFAULTS_PRIVATE.getConfigKey(), ConfigKey.NO_ARGS_CONSTRUCTOR_EXTRA_PRIVATE.getConfigKey()));
        final HashSet<String> flagUsageOptions = new HashSet<String>(Arrays.asList("lombok.accessors.flagUsage", "lombok.allArgsConstructor.flagUsage", "lombok.anyConstructor.flagUsage", "lombok.builder.flagUsage", "lombok.cleanup.flagUsage", "lombok.data.flagUsage", "lombok.delegate.flagUsage", "lombok.equalsAndHashCode.flagUsage", "lombok.experimental.flagUsage", "lombok.extensionMethod.flagUsage", "lombok.fieldDefaults.flagUsage", "lombok.getter.flagUsage", "lombok.getter.lazy.flagUsage", "lombok.log.apacheCommons.flagUsage", "lombok.log.flagUsage", "lombok.log.javaUtilLogging.flagUsage", "lombok.log.log4j.flagUsage", "lombok.log.log4j2.flagUsage", "lombok.log.slf4j.flagUsage", "lombok.log.xslf4j.flagUsage", "lombok.log.jbosslog.flagUsage", "lombok.log.flogger.flagUsage", "lombok.noArgsConstructor.flagUsage", "lombok.nonNull.flagUsage", "lombok.requiredArgsConstructor.flagUsage", "lombok.setter.flagUsage", "lombok.sneakyThrows.flagUsage", "lombok.synchronized.flagUsage", "lombok.toString.flagUsage", "lombok.val.flagUsage", "lombok.value.flagUsage", "lombok.wither.flagUsage"));
        final HashSet<String> flagUsageAllowable = new HashSet<String>(Collections.singletonList("lombok.var.flagUsage"));
        HashSet<String> otherOptions = new HashSet<String>(Arrays.asList(ConfigKey.ACCESSORS_PREFIX.getConfigKey(), ConfigKey.COPYABLE_ANNOTATIONS.getConfigKey(), ConfigKey.LOG_FIELDNAME.getConfigKey(), ConfigKey.LOG_CUSTOM_DECLARATION.getConfigKey(), ConfigKey.NONNULL_EXCEPTIONTYPE.getConfigKey(), ConfigKey.EQUALSANDHASHCODE_CALL_SUPER.getConfigKey(), ConfigKey.FIELD_NAME_CONSTANTS_PREFIX.getConfigKey(), ConfigKey.FIELD_NAME_CONSTANTS_SUFFIX.getConfigKey(), ConfigKey.FIELD_NAME_CONSTANTS_TYPENAME.getConfigKey(), ConfigKey.FIELD_NAME_CONSTANTS_UPPERCASE.getConfigKey(), ConfigKey.TOSTRING_CALL_SUPER.getConfigKey(), ConfigKey.BUILDER_CLASS_NAME.getConfigKey()));
        final HashSet<String> allOptions = new HashSet<String>(booleanOptions);
        allOptions.addAll(flagUsageOptions);
        allOptions.addAll(flagUsageAllowable);
        allOptions.addAll(otherOptions);
        this.extend(CompletionType.BASIC, (ElementPattern)PsiJavaPatterns.psiElement((IElementType)LombokConfigTypes.VALUE).withLanguage((Language)LombokConfigLanguage.INSTANCE), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet resultSet) {
                PsiElement psiElement;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (resultSet == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((psiElement = parameters.getPosition().getParent()) instanceof LombokConfigProperty) {
                    String configPropertyKey = StringUtil.notNullize((String)LombokConfigPsiUtil.getKey((LombokConfigProperty)psiElement));
                    if (booleanOptions.contains(configPropertyKey)) {
                        resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"true"));
                        resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"false"));
                    } else if (flagUsageOptions.contains(configPropertyKey)) {
                        resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"WARNING"));
                        resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"ERROR"));
                    } else if (flagUsageAllowable.contains(configPropertyKey)) {
                        resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"ALLOW"));
                        resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"WARNING"));
                    } else if (LOMBOK_EQUALS_AND_HASH_CODE_CALL_SUPER.equals(configPropertyKey) || LOMBOK_TOSTRING_CALL_SUPER.equals(configPropertyKey)) {
                        resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"CALL"));
                        resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"SKIP"));
                        resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"WARN"));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "resultSet";
                        break;
                    }
                }
                objectArray[1] = "de/plushnikov/intellij/plugin/language/LombokConfigCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PsiJavaPatterns.psiElement((IElementType)LombokConfigTypes.KEY).withLanguage((Language)LombokConfigLanguage.INSTANCE), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet resultSet) {
                if (parameters == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (resultSet == null) {
                    2.$$$reportNull$$$0(2);
                }
                for (String contribution : allOptions) {
                    resultSet.addElement((LookupElement)LookupElementBuilder.create((String)contribution));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "resultSet";
                        break;
                    }
                }
                objectArray[1] = "de/plushnikov/intellij/plugin/language/LombokConfigCompletionContributor$2";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }
}

