/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.Assert;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Fail;
import org.fest.assertions.Formatting;
import org.fest.util.Lists;
import org.fest.util.Objects;
import org.fest.util.Preconditions;

public abstract class GenericAssert<S, A>
extends Assert {
    protected final A actual;
    protected final S myself;

    protected GenericAssert(@Nonnull Class<S> selfType, @Nullable A actual) {
        this.actual = actual;
        this.myself = selfType.cast(this);
    }

    public final void isNull() {
        Fail.failIfNotNull(this.customErrorMessage(), this.rawDescription(), this.actual);
    }

    @Nonnull
    public final S satisfies(@Nonnull Condition<A> condition) {
        if (this.matches(condition)) {
            return this.myself();
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(this.errorMessageIfConditionNotSatisfied(condition));
    }

    @Nonnull
    private String errorMessageIfConditionNotSatisfied(@Nonnull Condition<A> condition) {
        return condition.addDescriptionTo(Formatting.format("actual value:<%s> should satisfy condition", this.actual));
    }

    @Nonnull
    public final S doesNotSatisfy(@Nonnull Condition<A> condition) {
        if (!this.matches(condition)) {
            return this.myself();
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(this.errorMessageIfConditionSatisfied(condition));
    }

    @Nonnull
    private String errorMessageIfConditionSatisfied(@Nonnull Condition<A> condition) {
        return condition.addDescriptionTo(Formatting.format("actual value:<%s> should not satisfy condition", this.actual));
    }

    @Nonnull
    public final S is(@Nonnull Condition<A> condition) {
        if (this.matches(condition)) {
            return this.myself();
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(this.errorMessageIfIsNot(condition));
    }

    @Nonnull
    private String errorMessageIfIsNot(@Nonnull Condition<A> condition) {
        return condition.addDescriptionTo(Formatting.format("actual value:<%s> should be", this.actual));
    }

    @Nonnull
    public final S isNot(@Nonnull Condition<A> condition) {
        if (!this.matches(condition)) {
            return this.myself();
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(this.errorMessageIfIs(condition));
    }

    private boolean matches(@Nonnull Condition<A> condition) {
        Preconditions.checkNotNull(condition);
        return condition.matches(this.actual);
    }

    @Nonnull
    private String errorMessageIfIs(@Nonnull Condition<A> condition) {
        return condition.addDescriptionTo(Formatting.format("actual value:<%s> should not be", this.actual));
    }

    @Nonnull
    public S as(@Nullable String description) {
        this.description(description);
        return this.myself();
    }

    @Nonnull
    public S describedAs(@Nullable String description) {
        return this.as(description);
    }

    @Nonnull
    public S as(@Nullable Description description) {
        this.description(description);
        return this.myself();
    }

    @Nonnull
    public S describedAs(@Nullable Description description) {
        return this.as(description);
    }

    @Nonnull
    public S isEqualTo(@Nullable A expected) {
        Fail.failIfNotEqual(this.customErrorMessage(), this.rawDescription(), this.actual, expected);
        return this.myself();
    }

    @Nonnull
    public S isNotEqualTo(@Nullable A other) {
        Fail.failIfEqual(this.customErrorMessage(), this.rawDescription(), this.actual, other);
        return this.myself();
    }

    @Nonnull
    public final S isNotNull() {
        Fail.failIfActualIsNull(this.customErrorMessage(), this.rawDescription(), this.actual);
        return this.myself();
    }

    @Nonnull
    public final S isSameAs(@Nullable A expected) {
        Fail.failIfNotSame(this.customErrorMessage(), this.rawDescription(), this.actual, expected);
        return this.myself();
    }

    @Nonnull
    public final S isNotSameAs(@Nullable A other) {
        Fail.failIfSame(this.customErrorMessage(), this.rawDescription(), this.actual, other);
        return this.myself();
    }

    @Nonnull
    public final S isIn(Object ... values) {
        return this.isIn(Lists.newArrayList((Object[])values));
    }

    @Nonnull
    public final S isIn(@Nonnull Collection<?> values) {
        Preconditions.checkNotNull(values);
        if (this.isActualIn(values)) {
            return this.myself();
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotIn(this.actual, values));
    }

    @Nonnull
    public final S isNotIn(Object ... values) {
        return this.isNotIn(Lists.newArrayList((Object[])values));
    }

    @Nonnull
    public final S isNotIn(@Nonnull Collection<?> values) {
        Preconditions.checkNotNull(values);
        if (!this.isActualIn(values)) {
            return this.myself();
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedIn(this.actual, values));
    }

    private boolean isActualIn(@Nonnull Collection<?> values) {
        if (values.isEmpty()) {
            return false;
        }
        for (Object value : values) {
            if (!Objects.areEqual(this.actual, value)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public S overridingErrorMessage(@Nullable String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this.myself();
    }

    @Nonnull
    protected final S myself() {
        return (S)Preconditions.checkNotNull(this.myself);
    }
}

