/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.NumberAssert;

public class FloatAssert
extends GenericAssert<FloatAssert, Float>
implements NumberAssert {
    private static final float ZERO = 0.0f;

    protected FloatAssert(float actual) {
        super(FloatAssert.class, Float.valueOf(actual));
    }

    protected FloatAssert(@Nullable Float actual) {
        super(FloatAssert.class, actual);
    }

    @Deprecated
    @Nonnull
    public static Delta delta(float d) {
        return new Delta(d);
    }

    @Override
    @Nonnull
    public FloatAssert isEqualTo(float expected) {
        return (FloatAssert)this.isEqualTo(Float.valueOf(expected));
    }

    @Deprecated
    @Nonnull
    public FloatAssert isEqualTo(float expected, @Nonnull Delta delta) {
        return this.isEqualTo(expected, delta.value);
    }

    @Nonnull
    public FloatAssert isEqualTo(float expected, @Nonnull org.fest.assertions.Delta delta) {
        return this.isEqualTo(expected, delta.floatValue());
    }

    @Nonnull
    private FloatAssert isEqualTo(float expected, float deltaValue) {
        return this.isEqualTo(Float.valueOf(expected), deltaValue);
    }

    @Nonnull
    public FloatAssert isEqualTo(@Nullable Float expected, @Nonnull org.fest.assertions.Delta delta) {
        return this.isEqualTo(expected, delta.floatValue());
    }

    @Nonnull
    private FloatAssert isEqualTo(@Nullable Float expected, float deltaValue) {
        if (this.actual == null || expected == null) {
            return (FloatAssert)this.isEqualTo(expected);
        }
        if (((Float)this.actual).compareTo(expected) == 0) {
            return this;
        }
        if (Math.abs(expected.floatValue() - ((Float)this.actual).floatValue()) <= deltaValue) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected) + Formatting.format(" using delta:<%s>", Float.valueOf(deltaValue)));
    }

    @Override
    @Nonnull
    public FloatAssert isNotEqualTo(float other) {
        if (this.compareTo(other) != 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, Float.valueOf(other)));
    }

    @Nonnull
    public FloatAssert isGreaterThan(float other) {
        if (this.compareTo(other) > 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, Float.valueOf(other)));
    }

    @Nonnull
    public FloatAssert isLessThan(float other) {
        if (this.compareTo(other) < 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, Float.valueOf(other)));
    }

    @Nonnull
    public FloatAssert isGreaterThanOrEqualTo(float other) {
        if (this.compareTo(other) >= 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, Float.valueOf(other)));
    }

    @Nonnull
    public FloatAssert isLessThanOrEqualTo(float other) {
        if (this.compareTo(other) <= 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, Float.valueOf(other)));
    }

    private int compareTo(float other) {
        return Float.compare(((Float)this.actual).floatValue(), other);
    }

    @Nonnull
    public FloatAssert isNaN() {
        return this.isEqualTo(Float.NaN);
    }

    @Override
    @Nonnull
    public FloatAssert isZero() {
        return this.isEqualTo(0.0f);
    }

    @Override
    @Nonnull
    public FloatAssert isPositive() {
        return this.isGreaterThan(0.0f);
    }

    @Override
    @Nonnull
    public FloatAssert isNegative() {
        return this.isLessThan(0.0f);
    }

    @Deprecated
    public static class Delta {
        final float value;

        private Delta(float value) {
            this.value = value;
        }
    }
}

