/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.common;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.text.NameUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000b2\u0006\u0010\u0010\u001a\u00020\fJ!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\fJ\u0010\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/completion/ml/common/ContextSimilarityUtil;", "", "()V", "LINE_SIMILARITY_SCORER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/completion/ml/common/ContextSimilarityUtil$ContextSimilarityScoringFunction;", "getLINE_SIMILARITY_SCORER_KEY", "()Lcom/intellij/openapi/util/Key;", "PARENT_SIMILARITY_SCORER_KEY", "getPARENT_SIMILARITY_SCORER_KEY", "STOP_WORDS", "", "", "calculateSimilarity", "Lcom/intellij/completion/ml/common/ContextSimilarityUtil$Similarity;", "tokens", "lookupString", "clearWords", "words", "", "([Ljava/lang/String;)Ljava/util/List;", "createLineSimilarityScoringFunction", "line", "createParentSimilarityScoringFunction", "element", "Lcom/intellij/psi/PsiElement;", "ContextSimilarityScoringFunction", "Similarity", "intellij.completionMlRanking"})
public final class ContextSimilarityUtil {
    private static final List<String> STOP_WORDS;
    @NotNull
    private static final Key<ContextSimilarityScoringFunction> LINE_SIMILARITY_SCORER_KEY;
    @NotNull
    private static final Key<ContextSimilarityScoringFunction> PARENT_SIMILARITY_SCORER_KEY;
    public static final ContextSimilarityUtil INSTANCE;

    @NotNull
    public final Key<ContextSimilarityScoringFunction> getLINE_SIMILARITY_SCORER_KEY() {
        return LINE_SIMILARITY_SCORER_KEY;
    }

    @NotNull
    public final Key<ContextSimilarityScoringFunction> getPARENT_SIMILARITY_SCORER_KEY() {
        return PARENT_SIMILARITY_SCORER_KEY;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ContextSimilarityScoringFunction createLineSimilarityScoringFunction(@NotNull String line) {
        Collection<List<String>> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        List list = StringUtil.getWordsIn((String)line);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"StringUtil.getWordsIn(line)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = NameUtilCore.nameToWords((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"NameUtilCore.nameToWords(it)");
            List<String> list2 = INSTANCE.clearWords(stringArray);
            collection.add(list2);
        }
        collection = (List)destination$iv$iv;
        List list3 = collection;
        return new ContextSimilarityScoringFunction(list3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ContextSimilarityScoringFunction createParentSimilarityScoringFunction(@Nullable PsiElement element) {
        Collection<List<String>> collection;
        void $this$mapTo$iv$iv;
        boolean bl = false;
        List parents = new ArrayList();
        for (PsiElement curElement = element; curElement != null && !(curElement instanceof PsiFile); curElement = curElement.getParent()) {
            String name;
            if (!(curElement instanceof PsiNamedElement) || (name = ((PsiNamedElement)curElement).getName()) == null) continue;
            parents.add(name);
        }
        Iterable $this$map$iv = parents;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            String[] stringArray = NameUtilCore.nameToWords((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"NameUtilCore.nameToWords(it)");
            List<String> list = INSTANCE.clearWords(stringArray);
            collection.add(list);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        return new ContextSimilarityScoringFunction(list);
    }

    @NotNull
    public final Similarity calculateSimilarity(@NotNull List<? extends List<String>> tokens, @NotNull String lookupString) {
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)lookupString, (String)"lookupString");
        Similarity result = new Similarity();
        String[] stringArray = NameUtilCore.nameToWords((String)lookupString);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"NameUtilCore.nameToWords(lookupString)");
        List<String> lookupWords = this.clearWords(stringArray);
        if (lookupWords.isEmpty()) {
            return result;
        }
        for (List<String> list : tokens) {
            double tokenSimilarity = 0.0;
            double tokenFullSimilarity = 0.0;
            for (String word : lookupWords) {
                boolean bl;
                block13: {
                    Object v4;
                    double d;
                    block12: {
                        Iterable iterable = (Iterable)RangesKt.downTo((int)word.length(), (int)1);
                        d = tokenSimilarity;
                        boolean bl2 = false;
                        Iterable iterable2 = iterable;
                        boolean bl3 = false;
                        Iterator iterator = iterable2.iterator();
                        while (iterator.hasNext()) {
                            boolean bl4;
                            Object t;
                            block11: {
                                t = iterator.next();
                                int prefixLength = ((Number)t).intValue();
                                boolean bl5 = false;
                                Iterable $this$any$iv = list;
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl4 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        String it = (String)element$iv;
                                        boolean bl6 = false;
                                        String string = word;
                                        int n = 0;
                                        int n2 = prefixLength;
                                        boolean bl7 = false;
                                        String string2 = string;
                                        if (string2 == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                        }
                                        String string3 = string2.substring(n, n2);
                                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                        if (!StringsKt.startsWith((String)it, (String)string3, (boolean)true)) continue;
                                        bl4 = true;
                                        break block11;
                                    }
                                    bl4 = false;
                                }
                            }
                            if (!bl4) continue;
                            v4 = t;
                            break block12;
                        }
                        v4 = null;
                    }
                    Object var33_33 = v4;
                    Integer n = var33_33;
                    tokenSimilarity = d + (double)(n != null ? n : 0);
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl8 = false;
                            if (!StringsKt.equals((String)it, (String)word, (boolean)true)) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                double d = tokenFullSimilarity;
                tokenFullSimilarity = d + 1.0;
            }
            result.addSimilarityValue(tokenSimilarity / (double)lookupString.length());
            result.addFullSimilarityValue(tokenFullSimilarity / (double)lookupWords.size());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> clearWords(String[] words) {
        void $this$filterTo$iv$iv;
        String[] $this$filter$iv = words;
        boolean $i$f$filter = false;
        String[] stringArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var7_7 = $this$filterTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var7_7[i];
            boolean bl = false;
            if (!(it.length() > 2 && !STOP_WORDS.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private ContextSimilarityUtil() {
    }

    static {
        ContextSimilarityUtil contextSimilarityUtil;
        INSTANCE = contextSimilarityUtil = new ContextSimilarityUtil();
        STOP_WORDS = CollectionsKt.listOf((Object[])new String[]{"get", "set"});
        Key key = Key.create((String)"LINE_SIMILARITY_SCORER");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"LINE_SIMILARITY_SCORER\")");
        LINE_SIMILARITY_SCORER_KEY = key;
        Key key2 = Key.create((String)"PARENT_SIMILARITY_SCORER");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create(\"PARENT_SIMILARITY_SCORER\")");
        PARENT_SIMILARITY_SCORER_KEY = key2;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/completion/ml/common/ContextSimilarityUtil$ContextSimilarityScoringFunction;", "", "tokens", "", "", "(Ljava/util/List;)V", "score", "Lcom/intellij/completion/ml/common/ContextSimilarityUtil$Similarity;", "value", "intellij.completionMlRanking"})
    public static final class ContextSimilarityScoringFunction {
        private final List<List<String>> tokens;

        @NotNull
        public final Similarity score(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return INSTANCE.calculateSimilarity(this.tokens, value);
        }

        public ContextSimilarityScoringFunction(@NotNull List<? extends List<String>> tokens) {
            Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
            this.tokens = tokens;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/completion/ml/common/ContextSimilarityUtil$Similarity;", "", "()V", "count", "", "fullSimilarity", "", "maxSimilarity", "sumSimilarity", "addFullSimilarityValue", "", "value", "addSimilarityValue", "meanSimilarity", "intellij.completionMlRanking"})
    public static final class Similarity {
        private double sumSimilarity;
        private int count;
        private double maxSimilarity;
        private double fullSimilarity;

        public final void addSimilarityValue(double value) {
            this.sumSimilarity += value;
            double d = this.maxSimilarity;
            boolean bl = false;
            this.maxSimilarity = Math.max(d, value);
            int n = this.count;
            this.count = n + 1;
        }

        public final void addFullSimilarityValue(double value) {
            double d = this.fullSimilarity;
            boolean bl = false;
            this.fullSimilarity = Math.max(d, value);
        }

        public final double meanSimilarity() {
            return this.count == 0 ? 0.0 : this.sumSimilarity / (double)this.count;
        }

        public final double maxSimilarity() {
            return this.maxSimilarity;
        }

        public final double fullSimilarity() {
            return this.fullSimilarity;
        }
    }
}

