/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.awt.Color;
import javax.annotation.Nonnull;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public final class Colors {
    @Nonnull
    public static Color colorFromHexString(@Nonnull String hexString) {
        Preconditions.checkNotNullOrEmpty((String)hexString);
        try {
            return new Color(Integer.parseInt(hexString, 16));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(Strings.concat((Object[])new Object[]{"The hexadecimal code ", Strings.quote((String)hexString), " is not a valid color code"}));
        }
    }

    private Colors() {
    }
}

