/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.timing;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.fest.util.Preconditions;

public final class Timeout {
    private final long duration;

    @Nonnull
    public static Timeout timeout(long duration) {
        return new Timeout(duration);
    }

    @Nonnull
    public static Timeout timeout(long duration, @Nonnull TimeUnit timeUnit) {
        Preconditions.checkNotNull((Object)((Object)timeUnit));
        return new Timeout(timeUnit.toMillis(duration));
    }

    private Timeout(long duration) {
        this.duration = duration;
    }

    public long duration() {
        return this.duration;
    }

    public int hashCode() {
        return 31 + (int)(this.duration ^ this.duration >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Timeout other = (Timeout)obj;
        return this.duration == other.duration;
    }
}

