/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.edt;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.fest.reflect.core.Reflection;
import org.fest.swing.edt.CheckThreadViolationRepaintManager;
import org.fest.swing.exception.EdtViolationException;

public class FailOnThreadViolationRepaintManager
extends CheckThreadViolationRepaintManager {
    @Nonnull
    public static FailOnThreadViolationRepaintManager install() {
        Object m = FailOnThreadViolationRepaintManager.currentRepaintManager();
        if (m instanceof FailOnThreadViolationRepaintManager) {
            return (FailOnThreadViolationRepaintManager)m;
        }
        return FailOnThreadViolationRepaintManager.installNew();
    }

    @Nullable
    private static Object currentRepaintManager() {
        try {
            return Reflection.method((String)"appContextGet").withReturnType(Object.class).withParameterTypes(new Class[]{Object.class}).in(SwingUtilities.class).invoke(new Object[]{RepaintManager.class});
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Nonnull
    private static FailOnThreadViolationRepaintManager installNew() {
        FailOnThreadViolationRepaintManager m = new FailOnThreadViolationRepaintManager();
        FailOnThreadViolationRepaintManager.setCurrentManager(m);
        return m;
    }

    public FailOnThreadViolationRepaintManager() {
    }

    public FailOnThreadViolationRepaintManager(boolean completeCheck) {
        super(completeCheck);
    }

    @Override
    void violationFound(@Nonnull JComponent c, @Nonnull StackTraceElement[] stackTraceElements) {
        EdtViolationException e = new EdtViolationException("EDT violation detected");
        e.setStackTrace(stackTraceElements);
        throw e;
    }
}

