/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Container;
import java.text.ParseException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JSpinner;
import javax.swing.text.JTextComponent;
import org.fest.assertions.Assertions;
import org.fest.assertions.ObjectAssert;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.ComponentFinder;
import org.fest.swing.core.Robot;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JSpinnerSetValueTask;
import org.fest.swing.driver.JSpinnerValueQuery;
import org.fest.swing.driver.JTextComponentTextQuery;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.Formatting;
import org.fest.util.Lists;
import org.fest.util.Strings;

public class JSpinnerDriver
extends JComponentDriver {
    private static final TypeMatcher EDITOR_MATCHER = new TypeMatcher(JTextComponent.class, true);
    private static final String VALUE_PROPERTY = "value";

    public JSpinnerDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void increment(@Nonnull JSpinner spinner, int times) {
        this.checkIsPositive(times, "increment the value");
        JSpinnerDriver.validateAndIncrementValue(spinner, times);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void validateAndIncrementValue(final @Nonnull JSpinner spinner, final int times) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(spinner);
                JSpinnerDriver.incrementValue(spinner, times);
            }
        });
    }

    @RunsInCurrentThread
    private static void incrementValue(@Nonnull JSpinner spinner, int times) {
        for (int i = 0; i < times; ++i) {
            Object newValue = spinner.getNextValue();
            if (newValue == null) {
                return;
            }
            spinner.setValue(newValue);
        }
    }

    @RunsInEDT
    public void increment(@Nonnull JSpinner spinner) {
        JSpinnerDriver.validateAndIncrementValue(spinner);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void validateAndIncrementValue(final @Nonnull JSpinner spinner) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(spinner);
                Object newValue = spinner.getNextValue();
                if (newValue != null) {
                    spinner.setValue(newValue);
                }
            }
        });
    }

    @RunsInEDT
    public void decrement(@Nonnull JSpinner spinner, int times) {
        this.checkIsPositive(times, "decrement the value");
        JSpinnerDriver.validateAndDecrementValue(spinner, times);
        this.robot.waitForIdle();
    }

    private void checkIsPositive(int times, @Nonnull String action) {
        if (times > 0) {
            return;
        }
        String msg = String.format("The number of times to %s should be greater than zero, but was <%d>", action, times);
        throw new IllegalArgumentException(msg);
    }

    @RunsInEDT
    private static void validateAndDecrementValue(final @Nonnull JSpinner spinner, final int times) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(spinner);
                JSpinnerDriver.decrementValue(spinner, times);
            }
        });
    }

    @RunsInCurrentThread
    private static void decrementValue(@Nonnull JSpinner spinner, int times) {
        for (int i = 0; i < times; ++i) {
            Object newValue = spinner.getPreviousValue();
            if (newValue == null) {
                return;
            }
            spinner.setValue(newValue);
        }
    }

    @RunsInEDT
    public void decrement(@Nonnull JSpinner spinner) {
        JSpinnerDriver.validateAndDecrementValue(spinner);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void validateAndDecrementValue(final @Nonnull JSpinner spinner) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(spinner);
                Object newValue = spinner.getPreviousValue();
                if (newValue != null) {
                    spinner.setValue(newValue);
                }
            }
        });
    }

    @Nullable
    @RunsInEDT
    public String textOf(@Nonnull JSpinner spinner) {
        JTextComponent editor = this.findEditor(spinner);
        if (editor != null) {
            return JTextComponentTextQuery.textOf(editor);
        }
        Object value = JSpinnerValueQuery.valueOf(spinner);
        return value != null ? value.toString() : null;
    }

    @RunsInEDT
    public void enterTextAndCommit(@Nonnull JSpinner spinner, String text) {
        this.enterText(spinner, text);
        JSpinnerDriver.commit(spinner);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void commit(final @Nonnull JSpinner spinner) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws ParseException {
                spinner.commitEdit();
            }
        });
    }

    @RunsInEDT
    public void enterText(@Nonnull JSpinner spinner, @Nonnull String text) {
        JSpinnerDriver.checkInEdtEnabledAndShowing(spinner);
        JTextComponent editor = this.findEditor(spinner);
        this.robot.waitForIdle();
        JSpinnerDriver.checkEditorNotNull(spinner, editor);
        if (editor == null) {
            return;
        }
        this.robot.focusAndWaitForFocusGain(editor);
        this.invokeAction(editor, "select-all");
        this.robot.enterText(text);
    }

    @Nullable
    @RunsInEDT
    private JTextComponent findEditor(@Nonnull JSpinner spinner) {
        ComponentFinder finder = this.robot.finder();
        ArrayList found = Lists.newArrayList(finder.findAll((Container)spinner, EDITOR_MATCHER));
        if (found.size() != 1) {
            return null;
        }
        Component c = (Component)found.get(0);
        if (c instanceof JTextComponent) {
            return (JTextComponent)c;
        }
        return null;
    }

    @RunsInEDT
    private static void checkEditorNotNull(final @Nonnull JSpinner spinner, final @Nullable JTextComponent editor) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                if (editor == null) {
                    throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to find editor for ", Formatting.format(spinner)}));
                }
            }
        });
    }

    @RunsInEDT
    public void selectValue(@Nonnull JSpinner spinner, @Nonnull Object value) {
        try {
            JSpinnerSetValueTask.setValue(spinner, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Strings.concat((Object[])new Object[]{"Value ", Strings.quote((Object)value), " is not valid"}));
        }
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public JTextComponent editor(@Nonnull JSpinner spinner) {
        return (JTextComponent)this.robot.finder().find((Container)spinner, EDITOR_MATCHER);
    }

    @RunsInEDT
    public void requireValue(@Nonnull JSpinner spinner, Object value) {
        ((ObjectAssert)Assertions.assertThat((Object)JSpinnerValueQuery.valueOf(spinner)).as(JSpinnerDriver.propertyName(spinner, VALUE_PROPERTY))).isEqualTo(value);
    }
}

