/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JProgressBar;
import org.fest.assertions.Description;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JProgressBarValueQuery;
import org.fest.swing.edt.GuiLazyLoadingDescription;
import org.fest.swing.format.Formatting;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.swing.timing.Timeout;

final class JProgressBarWaitUntilValueIsEqualToExpectedTask {
    @RunsInEDT
    static void waitUntilValueIsEqualToExpected(final @Nonnull JProgressBar progressBar, final int expected, @Nonnull Timeout timeout) {
        Pause.pause(new Condition(JProgressBarWaitUntilValueIsEqualToExpectedTask.untilValueIsEqualTo(progressBar, expected)){

            @Override
            public boolean test() {
                return JProgressBarValueQuery.valueOf(progressBar) == expected;
            }
        }, timeout);
    }

    private static Description untilValueIsEqualTo(final @Nonnull JProgressBar progressBar, final int expected) {
        return new GuiLazyLoadingDescription(){

            @Override
            @Nonnull
            protected String loadDescription() {
                return String.format("value of %s to be equal to %d", Formatting.format(progressBar), expected);
            }
        };
    }

    private JProgressBarWaitUntilValueIsEqualToExpectedTask() {
    }
}

