/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.data;

import javax.annotation.Nonnull;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.data.TableCell;
import org.fest.swing.data.TableCellFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Arrays;
import org.fest.util.Objects;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public class TableCellInRowByValue
implements TableCellFinder {
    private final String[] values;
    private final int column;

    @Nonnull
    public static TableCellBuilder rowWithValue(String ... values) {
        return new TableCellBuilder(values);
    }

    protected TableCellInRowByValue(@Nonnull String[] values, int column) {
        this.values = values;
        this.column = column;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public TableCell findCell(@Nonnull JTable table, @Nonnull JTableCellReader cellReader) {
        int row = TableCellInRowByValue.findRowIndex(table, cellReader, this.values);
        if (row == -1) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to find a row with values:<", Arrays.format((Object)this.values), ">"}));
        }
        return new TableCell(row, this.column);
    }

    @RunsInEDT
    private static int findRowIndex(final @Nonnull JTable table, final @Nonnull JTableCellReader cellReader, final @Nonnull String[] values) {
        Integer result = GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() {
                TableCellInRowByValue.validateEqualSize(table, values);
                int rowCount = table.getRowCount();
                for (int row = 0; row < rowCount; ++row) {
                    if (!TableCellInRowByValue.matchingRow(table, cellReader, values, row)) continue;
                    return row;
                }
                return -1;
            }
        });
        return (Integer)Preconditions.checkNotNull((Object)result);
    }

    @RunsInCurrentThread
    private static void validateEqualSize(@Nonnull JTable table, @Nonnull String[] values) {
        int columnCount = table.getColumnCount();
        if (values.length != columnCount) {
            throw new IllegalStateException(Strings.concat((Object[])new Object[]{"The array of values should have size:<", columnCount, ">"}));
        }
    }

    @RunsInCurrentThread
    private static boolean matchingRow(@Nonnull JTable table, @Nonnull JTableCellReader cellReader, @Nonnull String[] values, int row) {
        int columnCount = table.getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            if (Objects.areEqual((Object)cellReader.valueAt(table, row, col), (Object)values[col])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("%s[values=%s, column=%d]", this.getClass().getName(), Arrays.format((Object)this.values), this.column);
    }

    public static class TableCellBuilder {
        private final String[] values;

        TableCellBuilder(@Nonnull String[] values) {
            this.values = (String[])Preconditions.checkNotNull((Object)values);
        }

        @Nonnull
        public TableCellInRowByValue column(int column) {
            return new TableCellInRowByValue(this.values, column);
        }
    }
}

