/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JLabel;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.AbstractComponentMatcher;
import org.fest.util.Objects;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public class LabelMatcher
extends AbstractComponentMatcher {
    private final String label;
    private final Class<? extends Component> type;

    public LabelMatcher(@Nullable String label) {
        this(label, false);
    }

    public LabelMatcher(@Nullable String label, boolean requireShowing) {
        this(label, Component.class, requireShowing);
    }

    public LabelMatcher(@Nullable String label, @Nonnull Class<? extends Component> type) {
        this(label, type, false);
    }

    public LabelMatcher(@Nullable String label, @Nonnull Class<? extends Component> type, boolean requireShowing) {
        super(requireShowing);
        this.label = Preconditions.checkNotNullOrEmpty((String)label);
        this.type = (Class)Preconditions.checkNotNull(type);
    }

    @Override
    @RunsInCurrentThread
    public boolean matches(@Nullable Component c) {
        if (!(c instanceof JLabel)) {
            return false;
        }
        JLabel labelForComponent = (JLabel)c;
        if (!Objects.areEqual((Object)labelForComponent.getText(), (Object)this.label)) {
            return false;
        }
        Component labeled = labelForComponent.getLabelFor();
        return this.type.isInstance(labeled) && this.requireShowingMatches((Component)Preconditions.checkNotNull((Object)labeled));
    }

    public String toString() {
        String format = "%s[label=%s, type=%s, requireShowing=%b]";
        return String.format(format, this.getClass().getName(), Strings.quote((String)this.label), this.type.getName(), this.requireShowing());
    }
}

