/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.uiDesigner.core.AbstractLayout;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.BooleanEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.BooleanRenderer;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.awt.LayoutManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractGridLayoutProperty
extends Property<RadContainer, Boolean> {
    protected final BooleanRenderer myRenderer;
    protected final BooleanEditor myEditor;

    public AbstractGridLayoutProperty(Property parent, @NotNull @NonNls String name) {
        if (name == null) {
            AbstractGridLayoutProperty.$$$reportNull$$$0(0);
        }
        super(parent, name);
        this.myRenderer = new BooleanRenderer();
        this.myEditor = new BooleanEditor();
    }

    @Override
    public Boolean getValue(RadContainer component) {
        LayoutManager layoutManager = component.getLayout();
        if (!(layoutManager instanceof GridLayoutManager)) {
            return null;
        }
        GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
        return this.getGridLayoutPropertyValue(gridLayoutManager);
    }

    @Override
    protected void setValueImpl(RadContainer component, Boolean value) throws Exception {
        AbstractLayout layoutManager = (AbstractLayout)component.getLayout();
        if (!(layoutManager instanceof GridLayoutManager)) {
            throw new IllegalArgumentException("grid layout expected: " + layoutManager);
        }
        GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
        this.setGridLayoutPropertyValue(gridLayoutManager, value);
    }

    protected abstract boolean getGridLayoutPropertyValue(GridLayoutManager var1);

    protected abstract void setGridLayoutPropertyValue(GridLayoutManager var1, boolean var2);

    @Override
    @NotNull
    public PropertyRenderer<Boolean> getRenderer() {
        BooleanRenderer booleanRenderer = this.myRenderer;
        if (booleanRenderer == null) {
            AbstractGridLayoutProperty.$$$reportNull$$$0(1);
        }
        return booleanRenderer;
    }

    @Override
    public PropertyEditor<Boolean> getEditor() {
        return this.myEditor;
    }

    @Override
    public boolean isModified(RadContainer component) {
        Boolean value = this.getValue(component);
        return value != null && value != false;
    }

    @Override
    public void resetValue(RadContainer component) throws Exception {
        this.setValueImpl(component, Boolean.FALSE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/propertyInspector/properties/AbstractGridLayoutProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/propertyInspector/properties/AbstractGridLayoutProperty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

