/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.make;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.make.FormSourceCodeGenerator;
import com.intellij.uiDesigner.make.LayoutSourceGenerator;
import gnu.trove.TIntObjectHashMap;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NonNls;

public class GridLayoutSourceGenerator
extends LayoutSourceGenerator {
    private static final TIntObjectHashMap<String> myAnchors = GridLayoutSourceGenerator.fillMap(GridConstraints.class, "ANCHOR_");
    private static final TIntObjectHashMap<String> myFills = GridLayoutSourceGenerator.fillMap(GridConstraints.class, "FILL_");
    public static final GridLayoutSourceGenerator INSTANCE = new GridLayoutSourceGenerator();

    @Override
    public void generateContainerLayout(LwContainer container, FormSourceCodeGenerator generator, String variable) {
        if (container.isXY()) {
            if (container.getComponentCount() != 0) {
                throw new IllegalStateException("only empty xys are accepted");
            }
        } else if (container.isGrid()) {
            GridLayoutManager layout = (GridLayoutManager)container.getLayout();
            generator.startMethodCall(variable, "setLayout");
            generator.startConstructor(GridLayoutManager.class.getName());
            generator.push(layout.getRowCount());
            generator.push(layout.getColumnCount());
            generator.newInsets(layout.getMargin());
            generator.push(layout.getHGap());
            generator.push(layout.getVGap());
            if (layout.isSameSizeHorizontally() || layout.isSameSizeVertically()) {
                generator.push(layout.isSameSizeHorizontally());
                generator.push(layout.isSameSizeVertically());
            }
            generator.endConstructor();
            generator.endMethod();
        } else {
            throw new IllegalArgumentException("unknown layout: " + container.getLayout());
        }
    }

    @Override
    public void generateComponentLayout(LwComponent component, FormSourceCodeGenerator generator, String variable, String parentVariable) {
        generator.startMethodCall(parentVariable, "add");
        generator.pushVar(variable);
        GridLayoutSourceGenerator.addNewGridConstraints(generator, component);
        generator.endMethod();
    }

    private static void addNewGridConstraints(FormSourceCodeGenerator generator, LwComponent component) {
        GridConstraints constraints = component.getConstraints();
        generator.startConstructor(GridConstraints.class.getName());
        generator.push(constraints.getRow());
        generator.push(constraints.getColumn());
        generator.push(constraints.getRowSpan());
        generator.push(constraints.getColSpan());
        generator.push(constraints.getAnchor(), myAnchors);
        generator.push(constraints.getFill(), myFills);
        GridLayoutSourceGenerator.pushSizePolicy(generator, constraints.getHSizePolicy());
        GridLayoutSourceGenerator.pushSizePolicy(generator, constraints.getVSizePolicy());
        generator.newDimensionOrNull(constraints.myMinimumSize);
        generator.newDimensionOrNull(constraints.myPreferredSize);
        generator.newDimensionOrNull(constraints.myMaximumSize);
        generator.push(constraints.getIndent());
        generator.push(constraints.isUseParentLayout());
        generator.endConstructor();
    }

    private static void pushSizePolicy(FormSourceCodeGenerator generator, int value) {
        String presentation;
        String className = GridConstraints.class.getName();
        if (0 == value) {
            presentation = className + ".SIZEPOLICY_FIXED";
        } else {
            presentation = (value & 1) != 0 ? className + ".SIZEPOLICY_CAN_SHRINK" : null;
            if ((value & 4) != 0) {
                presentation = presentation == null ? className + ".SIZEPOLICY_WANT_GROW" : presentation + "|" + className + ".SIZEPOLICY_WANT_GROW";
            } else if ((value & 2) != 0) {
                presentation = presentation == null ? className + ".SIZEPOLICY_CAN_GROW" : presentation + "|" + className + ".SIZEPOLICY_CAN_GROW";
            } else {
                generator.push(value);
                return;
            }
        }
        generator.pushVar(presentation);
    }

    private static TIntObjectHashMap<String> fillMap(Class<GridConstraints> aClass, @NonNls String prefix) {
        Field[] fields;
        TIntObjectHashMap map = new TIntObjectHashMap();
        for (Field field : fields = aClass.getFields()) {
            if ((field.getModifiers() & 8) == 0 || !field.getName().startsWith(prefix)) continue;
            field.setAccessible(true);
            try {
                int value = field.getInt(aClass);
                map.put(value, (Object)(aClass.getName() + "." + field.getName()));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return map;
    }
}

