/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Ref;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.actions.MoveSelectionToRightAction;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.radComponents.RadAtomicComponent;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

abstract class AbstractMoveSelectionAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(MoveSelectionToRightAction.class);
    private final GuiEditor myEditor;
    private final boolean myExtend;
    private final boolean myMoveToLast;

    AbstractMoveSelectionAction(@NotNull GuiEditor editor, boolean extend, boolean moveToLast) {
        if (editor == null) {
            AbstractMoveSelectionAction.$$$reportNull$$$0(0);
        }
        this.myEditor = editor;
        this.myExtend = extend;
        this.myMoveToLast = moveToLast;
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractMoveSelectionAction.$$$reportNull$$$0(1);
        }
        ArrayList<RadComponent> selectedComponents = FormEditingUtil.getSelectedComponents(this.myEditor);
        final JComponent rootContainerDelegee = this.myEditor.getRootContainer().getDelegee();
        if (selectedComponents.size() == 0) {
            this.moveToFirstComponent(rootContainerDelegee);
            return;
        }
        RadComponent selectedComponent = this.myEditor.getSelectionLead();
        if (selectedComponent == null || !selectedComponents.contains(selectedComponent)) {
            selectedComponent = selectedComponents.get(0);
        }
        if (this.moveSelectionByGrid(selectedComponent) || this.myMoveToLast) {
            return;
        }
        final ArrayList components = new ArrayList();
        final ArrayList points = new ArrayList();
        final RadComponent selectedComponent1 = selectedComponent;
        FormEditingUtil.iterate(this.myEditor.getRootContainer(), new FormEditingUtil.ComponentVisitor<RadComponent>(){

            @Override
            public boolean visit(RadComponent component) {
                if (component instanceof RadAtomicComponent) {
                    if (selectedComponent1.equals(component)) {
                        return true;
                    }
                    if (!FormEditingUtil.isComponentSwitchedInView(component)) {
                        return true;
                    }
                    components.add(component);
                    JComponent _delegee = component.getDelegee();
                    Point p = SwingUtilities.convertPoint(_delegee, new Point(0, 0), rootContainerDelegee);
                    p.x += _delegee.getWidth() / 2;
                    p.y += _delegee.getHeight() / 2;
                    points.add(p);
                }
                return true;
            }
        });
        if (components.size() == 0) {
            return;
        }
        Point source = SwingUtilities.convertPoint(selectedComponent.getDelegee(), new Point(0, 0), rootContainerDelegee);
        source.x += selectedComponent.getDelegee().getWidth() / 2;
        source.y += selectedComponent.getDelegee().getHeight() / 2;
        int min = Integer.MAX_VALUE;
        int nextSelectedIndex = -1;
        for (int i = points.size() - 1; i >= 0; --i) {
            int distance = this.calcDistance(source, (Point)points.get(i));
            if (distance >= min) continue;
            min = distance;
            nextSelectedIndex = i;
        }
        if (min == Integer.MAX_VALUE) {
            return;
        }
        RadComponent component = (RadComponent)components.get(nextSelectedIndex);
        this.selectOrExtend(component);
    }

    private void selectOrExtend(RadComponent component) {
        if (this.myExtend) {
            FormEditingUtil.selectComponent(this.myEditor, component);
        } else {
            FormEditingUtil.selectSingleComponent(this.myEditor, component);
        }
    }

    private void moveToFirstComponent(final JComponent rootContainerDelegee) {
        final int[] minX = new int[]{Integer.MAX_VALUE};
        final int[] minY = new int[]{Integer.MAX_VALUE};
        final Ref componentToBeSelected = new Ref();
        FormEditingUtil.iterate(this.myEditor.getRootContainer(), new FormEditingUtil.ComponentVisitor<RadComponent>(){

            @Override
            public boolean visit(RadComponent component) {
                if (component instanceof RadAtomicComponent) {
                    JComponent _delegee = component.getDelegee();
                    Point p = SwingUtilities.convertPoint(_delegee, new Point(0, 0), rootContainerDelegee);
                    if (minX[0] > p.x || minY[0] > p.y) {
                        minX[0] = p.x;
                        minY[0] = p.y;
                        componentToBeSelected.set((Object)component);
                    }
                }
                return true;
            }
        });
        if (!componentToBeSelected.isNull()) {
            FormEditingUtil.selectComponent(this.myEditor, (RadComponent)componentToBeSelected.get());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractMoveSelectionAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabled(!this.myEditor.getMainProcessor().isProcessorActive());
    }

    private boolean moveSelectionByGrid(RadComponent selectedComponent) {
        RadComponent lastComponent;
        block6: {
            RadComponent component;
            RadContainer parent = selectedComponent.getParent();
            if (parent == null || !parent.getLayoutManager().isGrid()) {
                return false;
            }
            int row = selectedComponent.getConstraints().getRow();
            int column = selectedComponent.getConstraints().getColumn();
            lastComponent = null;
            while (true) {
                if ((row += this.getRowMoveDelta()) < 0 || row >= parent.getGridRowCount() || (column += this.getColumnMoveDelta()) < 0 || column >= parent.getGridColumnCount()) {
                    if (!this.myMoveToLast) {
                        return false;
                    }
                    break block6;
                }
                component = parent.getComponentAtGrid(row, column);
                if (component == null || component == selectedComponent) continue;
                if (!this.myMoveToLast) break;
                if (this.myExtend) {
                    FormEditingUtil.selectComponent(this.myEditor, component);
                }
                lastComponent = component;
            }
            this.selectOrExtend(component);
            return true;
        }
        if (lastComponent != null) {
            this.selectOrExtend(lastComponent);
            return true;
        }
        return false;
    }

    protected abstract int calcDistance(Point var1, Point var2);

    protected int getColumnMoveDelta() {
        return 0;
    }

    protected int getRowMoveDelta() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uiDesigner/actions/AbstractMoveSelectionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

