/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.util;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.util.Maps;
import org.fest.util.Preconditions;

public final class Types {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPE = Maps.newHashMap();

    private Types() {
    }

    public static <T> T castSafely(@Nullable Object o, @Nonnull Class<T> type) {
        Preconditions.checkNotNull(type);
        if (type.isPrimitive()) {
            return Types.getWrapperType(type).cast(o);
        }
        return type.cast(o);
    }

    @Nonnull
    private static <T> Class<T> getWrapperType(@Nonnull Class<T> primitiveClass) {
        Preconditions.checkNotNull(primitiveClass);
        if (!primitiveClass.isPrimitive()) {
            String msg = String.format("The class %s is not a primitive type", primitiveClass.getName());
            throw new IllegalArgumentException(msg);
        }
        return (Class)Preconditions.checkNotNull(PRIMITIVE_TO_WRAPPER_TYPE.get(primitiveClass));
    }

    static {
        Boolean.TYPE.isPrimitive();
        PRIMITIVE_TO_WRAPPER_TYPE.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_WRAPPER_TYPE.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPER_TYPE.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_WRAPPER_TYPE.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_WRAPPER_TYPE.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_WRAPPER_TYPE.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_WRAPPER_TYPE.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_WRAPPER_TYPE.put(Character.TYPE, Character.class);
    }
}

