/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.CharsetUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001c\u0010\r\u001a\u00020\u0001*\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0007\u00a8\u0006\u0010"}, d2={"decodeString", "", "decoder", "Ljava/nio/charset/CharsetDecoder;", "src", "Ljava/nio/ByteBuffer;", "dst", "Ljava/nio/CharBuffer;", "writeIntAsAscii", "value", "", "buffer", "Lio/netty/buffer/ByteBuf;", "readIntoCharBuffer", "byteCount", "charBuffer", "intellij.platform.ide.util.io"})
public final class BufferToCharsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void readIntoCharBuffer(@NotNull ByteBuf $this$readIntoCharBuffer, int byteCount, @NotNull CharBuffer charBuffer) {
        Intrinsics.checkNotNullParameter((Object)$this$readIntoCharBuffer, (String)"$this$readIntoCharBuffer");
        Intrinsics.checkNotNullParameter((Object)charBuffer, (String)"charBuffer");
        CharsetDecoder decoder = CharsetUtil.decoder((Charset)Charsets.UTF_8);
        if ($this$readIntoCharBuffer.nioBufferCount() == 1) {
            CharsetDecoder charsetDecoder = decoder;
            Intrinsics.checkNotNullExpressionValue((Object)charsetDecoder, (String)"decoder");
            ByteBuffer byteBuffer = $this$readIntoCharBuffer.internalNioBuffer($this$readIntoCharBuffer.readerIndex(), byteCount);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"internalNioBuffer(readerIndex(), byteCount)");
            BufferToCharsKt.decodeString(charsetDecoder, byteBuffer, charBuffer);
        } else {
            ByteBuf buffer = $this$readIntoCharBuffer.alloc().heapBuffer(byteCount);
            try {
                buffer.writeBytes($this$readIntoCharBuffer, $this$readIntoCharBuffer.readerIndex(), byteCount);
                CharsetDecoder charsetDecoder = decoder;
                Intrinsics.checkNotNullExpressionValue((Object)charsetDecoder, (String)"decoder");
                ByteBuffer byteBuffer = buffer.internalNioBuffer(0, byteCount);
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer.internalNioBuffer(0, byteCount)");
                BufferToCharsKt.decodeString(charsetDecoder, byteBuffer, charBuffer);
            }
            finally {
                buffer.release();
            }
        }
    }

    public static /* synthetic */ void readIntoCharBuffer$default(ByteBuf byteBuf, int n, CharBuffer charBuffer, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = byteBuf.readableBytes();
        }
        BufferToCharsKt.readIntoCharBuffer(byteBuf, n, charBuffer);
    }

    private static final void decodeString(CharsetDecoder decoder, ByteBuffer src, CharBuffer dst) {
        try {
            CoderResult cr;
            CoderResult coderResult = cr = decoder.decode(src, dst, true);
            Intrinsics.checkNotNullExpressionValue((Object)coderResult, (String)"cr");
            if (!coderResult.isUnderflow()) {
                cr.throwException();
            }
            CoderResult coderResult2 = cr = decoder.flush(dst);
            Intrinsics.checkNotNullExpressionValue((Object)coderResult2, (String)"cr");
            if (!coderResult2.isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw (Throwable)new IllegalStateException(x);
        }
    }

    public static final void writeIntAsAscii(int value, @NotNull ByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ByteBufUtil.writeAscii((ByteBuf)buffer, (CharSequence)new StringBuilder().append(value));
    }
}

