/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.CommandSender;
import com.jetbrains.jdi.InvokableTypeImpl;
import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.MethodImpl;
import com.jetbrains.jdi.ObjectReferenceImpl;
import com.jetbrains.jdi.PacketStream;
import com.jetbrains.jdi.ThreadReferenceImpl;
import com.jetbrains.jdi.ValueImpl;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public final class InterfaceTypeImpl
extends InvokableTypeImpl
implements InterfaceType {
    private volatile SoftReference<List<InterfaceType>> superinterfacesRef = null;

    protected InterfaceTypeImpl(VirtualMachine aVm, long aRef) {
        super(aVm, aRef);
    }

    @Override
    public List<InterfaceType> superinterfaces() {
        List<InterfaceType> superinterfaces;
        List<InterfaceType> list = superinterfaces = this.superinterfacesRef == null ? null : this.superinterfacesRef.get();
        if (superinterfaces == null) {
            superinterfaces = this.getInterfaces();
            superinterfaces = Collections.unmodifiableList(superinterfaces);
            this.superinterfacesRef = new SoftReference<List<InterfaceType>>(superinterfaces);
        }
        return superinterfaces;
    }

    public CompletableFuture<List<InterfaceType>> superinterfacesAsync() {
        List<InterfaceType> superinterfaces;
        List<InterfaceType> list = superinterfaces = this.superinterfacesRef == null ? null : this.superinterfacesRef.get();
        if (superinterfaces != null) {
            return CompletableFuture.completedFuture(superinterfaces);
        }
        return this.getInterfacesAsync().thenApply(r -> {
            this.superinterfacesRef = new SoftReference(Collections.unmodifiableList(r));
            return r;
        });
    }

    @Override
    public List<InterfaceType> subinterfaces() {
        ArrayList<InterfaceType> subs = new ArrayList<InterfaceType>();
        this.vm.forEachClass(refType -> {
            InterfaceType interfaze;
            if (refType instanceof InterfaceType && (interfaze = (InterfaceType)refType).isPrepared() && interfaze.superinterfaces().contains(this)) {
                subs.add(interfaze);
            }
        });
        return subs;
    }

    @Override
    public List<ClassType> implementors() {
        ArrayList<ClassType> implementors = new ArrayList<ClassType>();
        this.vm.forEachClass(refType -> {
            ClassType clazz;
            if (refType instanceof ClassType && (clazz = (ClassType)refType).isPrepared() && clazz.interfaces().contains(this)) {
                implementors.add(clazz);
            }
        });
        return implementors;
    }

    @Override
    public boolean isInitialized() {
        return this.isPrepared();
    }

    @Override
    public String toString() {
        return "interface " + this.name() + " (" + this.loaderString() + ")";
    }

    @Override
    InvokableTypeImpl.InvocationResult waitForReply(PacketStream stream) throws JDWPException {
        return new IResult(JDWP.InterfaceType.InvokeMethod.waitForReply(this.vm, stream));
    }

    @Override
    CommandSender getInvokeMethodSender(ThreadReferenceImpl thread, MethodImpl method, ValueImpl[] args, int options) {
        return () -> JDWP.InterfaceType.InvokeMethod.enqueueCommand(this.vm, this, thread, method.ref(), args, options);
    }

    @Override
    ClassType superclass() {
        return null;
    }

    @Override
    CompletableFuture<ClassType> superclassAsync() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    boolean isAssignableTo(ReferenceType type) {
        if (type.name().equals("java.lang.Object")) {
            return true;
        }
        return super.isAssignableTo(type);
    }

    @Override
    List<InterfaceType> interfaces() {
        return this.superinterfaces();
    }

    @Override
    CompletableFuture<List<InterfaceType>> interfacesAsync() {
        return this.superinterfacesAsync();
    }

    @Override
    boolean canInvoke(Method method) {
        return this.equals(method.declaringType());
    }

    private static class IResult
    implements InvokableTypeImpl.InvocationResult {
        private final JDWP.InterfaceType.InvokeMethod rslt;

        public IResult(JDWP.InterfaceType.InvokeMethod rslt) {
            this.rslt = rslt;
        }

        @Override
        public ObjectReferenceImpl getException() {
            return this.rslt.exception;
        }

        @Override
        public ValueImpl getResult() {
            return this.rslt.returnValue;
        }
    }
}

