/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrMetadataSourceOwner;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "extendThrowableFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getExtendThrowableFunction", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "newThrowableFunction", "nothingNType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getNothingNType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "throwableConstructors", "", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "nullValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "extractThrowableArguments", "Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering$ThrowableArguments;", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "ThrowableArguments", "Transformer", "backend.js"})
public final class ThrowableLowering
implements BodyLoweringPass {
    private final List<IrConstructorSymbol> throwableConstructors;
    private final IrSimpleFunctionSymbol newThrowableFunction;
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final IrSimpleFunctionSymbol extendThrowableFunction;

    private final IrType getNothingNType() {
        return this.context.getIrBuiltIns().getNothingNType();
    }

    @NotNull
    public final IrExpression nullValue() {
        return IrConstImpl.Companion.constNull(-1, -1, this.getNothingNType());
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        IrClass irClass2 = IrUtilsKt.getParentClassOrNull(container);
        boolean bl = false;
        boolean bl2 = false;
        IrClass enclosingClass = irClass2;
        boolean bl3 = false;
        IrElementTransformer irElementTransformer = new Transformer();
        IrMetadataSourceOwner irMetadataSourceOwner = enclosingClass;
        if (irMetadataSourceOwner == null) {
            irMetadataSourceOwner = IrUtilsKt.getFile(container);
        }
        irBody.transformChildren(irElementTransformer, irMetadataSourceOwner);
    }

    private final ThrowableArguments extractThrowableArguments(IrFunctionAccessExpression $this$extractThrowableArguments) {
        ThrowableArguments throwableArguments;
        switch ($this$extractThrowableArguments.getValueArgumentsCount()) {
            case 0: {
                throwableArguments = new ThrowableArguments(this.nullValue(), this.nullValue());
                break;
            }
            case 2: {
                IrExpression irExpression = $this$extractThrowableArguments.getValueArgument(0);
                Intrinsics.checkNotNull(irExpression);
                IrExpression irExpression2 = $this$extractThrowableArguments.getValueArgument(1);
                Intrinsics.checkNotNull(irExpression2);
                throwableArguments = new ThrowableArguments(irExpression, irExpression2);
                break;
            }
            default: {
                IrExpression irExpression = $this$extractThrowableArguments.getValueArgument(0);
                Intrinsics.checkNotNull(irExpression);
                IrExpression arg = irExpression;
                IrValueParameter parameter = $this$extractThrowableArguments.getSymbol().getOwner().getValueParameters().get(0);
                if (IrTypePredicatesKt.isNullableString(parameter.getType())) {
                    throwableArguments = new ThrowableArguments(arg, this.nullValue());
                    break;
                }
                boolean bl = IrTypeUtilsKt.isThrowable(IrTypesKt.makeNotNull(parameter.getType()));
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                throwableArguments = new ThrowableArguments(this.nullValue(), arg);
            }
        }
        return throwableArguments;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrSimpleFunctionSymbol getExtendThrowableFunction() {
        return this.extendThrowableFunction;
    }

    public ThrowableLowering(@NotNull JsIrBackendContext context2, @NotNull IrSimpleFunctionSymbol extendThrowableFunction) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(extendThrowableFunction, "extendThrowableFunction");
        this.context = context2;
        this.extendThrowableFunction = extendThrowableFunction;
        this.throwableConstructors = this.context.getThrowableConstructors();
        this.newThrowableFunction = this.context.getNewThrowableSymbol();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering$ThrowableArguments;", "", "message", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "cause", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "getCause", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getMessage", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "backend.js"})
    public static final class ThrowableArguments {
        @NotNull
        private final IrExpression message;
        @NotNull
        private final IrExpression cause;

        @NotNull
        public final IrExpression getMessage() {
            return this.message;
        }

        @NotNull
        public final IrExpression getCause() {
            return this.cause;
        }

        public ThrowableArguments(@NotNull IrExpression message2, @NotNull IrExpression cause) {
            Intrinsics.checkNotNullParameter(message2, "message");
            Intrinsics.checkNotNullParameter(cause, "cause");
            this.message = message2;
            this.cause = cause;
        }

        @NotNull
        public final IrExpression component1() {
            return this.message;
        }

        @NotNull
        public final IrExpression component2() {
            return this.cause;
        }

        @NotNull
        public final ThrowableArguments copy(@NotNull IrExpression message2, @NotNull IrExpression cause) {
            Intrinsics.checkNotNullParameter(message2, "message");
            Intrinsics.checkNotNullParameter(cause, "cause");
            return new ThrowableArguments(message2, cause);
        }

        public static /* synthetic */ ThrowableArguments copy$default(ThrowableArguments throwableArguments, IrExpression irExpression, IrExpression irExpression2, int n, Object object) {
            if ((n & 1) != 0) {
                irExpression = throwableArguments.message;
            }
            if ((n & 2) != 0) {
                irExpression2 = throwableArguments.cause;
            }
            return throwableArguments.copy(irExpression, irExpression2);
        }

        @NotNull
        public String toString() {
            return "ThrowableArguments(message=" + this.message + ", cause=" + this.cause + ")";
        }

        public int hashCode() {
            IrExpression irExpression = this.message;
            IrExpression irExpression2 = this.cause;
            return (irExpression != null ? irExpression.hashCode() : 0) * 31 + (irExpression2 != null ? irExpression2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ThrowableArguments)) break block3;
                    ThrowableArguments throwableArguments = (ThrowableArguments)object;
                    if (!Intrinsics.areEqual(this.message, throwableArguments.message) || !Intrinsics.areEqual(this.cause, throwableArguments.cause)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering;)V", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "data", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "backend.js"})
    public final class Transformer
    implements IrElementTransformer<IrDeclarationParent> {
        @Override
        @NotNull
        public IrStatement visitClass(@NotNull IrClass declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitClass(this, declaration2, declaration2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull IrDeclarationParent data) {
            void messageArg;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            expression2.transformChildren(this, data);
            if (!ThrowableLowering.this.throwableConstructors.contains(expression2.getSymbol())) {
                return expression2;
            }
            Object object = ThrowableLowering.this.extractThrowableArguments(expression2);
            IrExpression irExpression = ((ThrowableArguments)object).component1();
            IrExpression causeArg = ((ThrowableArguments)object).component2();
            object = expression2;
            boolean bl = false;
            boolean bl2 = false;
            Object $this$run = object;
            boolean bl3 = false;
            IrCallImpl irCallImpl = new IrCallImpl($this$run.getStartOffset(), $this$run.getEndOffset(), $this$run.getType(), (IrFunctionSymbol)ThrowableLowering.this.newThrowableFunction, null, null, 48, null);
            boolean bl4 = false;
            boolean bl5 = false;
            IrCallImpl it = irCallImpl;
            boolean bl6 = false;
            it.putValueArgument(0, (IrExpression)messageArg);
            it.putValueArgument(1, causeArg);
            return irCallImpl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull IrDeclarationParent data) {
            void messageArg;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            expression2.transformChildren(this, data);
            if (!ThrowableLowering.this.throwableConstructors.contains(expression2.getSymbol())) {
                return expression2;
            }
            ThrowableArguments throwableArguments = ThrowableLowering.this.extractThrowableArguments(expression2);
            IrExpression irExpression = throwableArguments.component1();
            IrExpression causeArg = throwableArguments.component2();
            IrClass klass = (IrClass)data;
            int n = expression2.getStartOffset();
            int n2 = expression2.getEndOffset();
            IrValueParameter irValueParameter = klass.getThisReceiver();
            Intrinsics.checkNotNull(irValueParameter);
            IrGetValueImpl thisReceiver2 = new IrGetValueImpl(n, n2, (IrValueSymbol)irValueParameter.getSymbol(), null, 8, null);
            IrDelegatingConstructorCall irDelegatingConstructorCall = expression2;
            boolean bl = false;
            boolean bl2 = false;
            IrDelegatingConstructorCall $this$run = irDelegatingConstructorCall;
            boolean bl3 = false;
            IrCallImpl irCallImpl = new IrCallImpl($this$run.getStartOffset(), $this$run.getEndOffset(), $this$run.getType(), (IrFunctionSymbol)ThrowableLowering.this.getExtendThrowableFunction(), null, null, 48, null);
            boolean bl4 = false;
            boolean bl5 = false;
            IrCallImpl it = irCallImpl;
            boolean bl6 = false;
            it.putValueArgument(0, thisReceiver2);
            it.putValueArgument(1, (IrExpression)messageArg);
            it.putValueArgument(2, causeArg);
            return irCallImpl;
        }

        @Override
        @NotNull
        public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitBlock(@NotNull IrBlock expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        @NotNull
        public IrBody visitBlockBody(@NotNull IrBlockBody body2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(body2, "body");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitBlockBody(this, body2, data);
        }

        @Override
        @NotNull
        public IrBody visitBody(@NotNull IrBody body2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(body2, "body");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitBody(this, body2, data);
        }

        @Override
        @NotNull
        public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(branch, "branch");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        @NotNull
        public IrExpression visitBreak(@NotNull IrBreak jump, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(jump, "jump");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        @NotNull
        public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(jump, "jump");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        @NotNull
        public IrElement visitCall(@NotNull IrCall expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitCallableReference(@NotNull IrCallableReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(aCatch, "aCatch");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        @NotNull
        public IrExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitComposite(@NotNull IrComposite expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        @NotNull
        public <T> IrExpression visitConst(@NotNull IrConst<T> expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitConstructor(@NotNull IrConstructor declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitContainerExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitContinue(@NotNull IrContinue jump, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(jump, "jump");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        @NotNull
        public IrStatement visitDeclaration(@NotNull IrDeclaration declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(loop2, "loop");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitElement(@NotNull IrElement element, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitElement(this, element, data);
        }

        @Override
        @NotNull
        public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(branch, "branch");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data);
        }

        @Override
        @NotNull
        public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitExpression(@NotNull IrExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(body2, "body");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body2, data);
        }

        @Override
        @NotNull
        public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrStatement visitField(@NotNull IrField declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitField(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrFile visitFile(@NotNull IrFile declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitFile(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrStatement visitFunction(@NotNull IrFunction declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitFunction(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitFunctionExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitGetValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitLoop(@NotNull IrLoop loop2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(loop2, "loop");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitLoop(this, loop2, data);
        }

        @Override
        @NotNull
        public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrStatement visitProperty(@NotNull IrProperty declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitProperty(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitReturn(@NotNull IrReturn expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitScript(@NotNull IrScript declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitScript(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSetField(@NotNull IrSetField expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSetVariable(@NotNull IrSetVariable expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitSetVariable(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(spread, "spread");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        @NotNull
        public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @Override
        @NotNull
        public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(body2, "body");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body2, data);
        }

        @Override
        @NotNull
        public IrExpression visitThrow(@NotNull IrThrow expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitTry(@NotNull IrTry aTry, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(aTry, "aTry");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        @NotNull
        public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitValueParameter(@NotNull IrValueParameter declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitVararg(@NotNull IrVararg expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitVariable(@NotNull IrVariable declaration2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitVariable(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitWhen(@NotNull IrWhen expression2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitWhen(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(loop2, "loop");
            Intrinsics.checkNotNullParameter(data, "data");
            return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop2, data);
        }
    }
}

