/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.backend.Fir2IrCallableCache;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u0004\u0018\u00010\t2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\bJ\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019J\u0006\u0010\u001a\u001a\u00020\u000bJ\u001a\u0010\u001b\u001a\u00020\u000b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001d\u001a\u00020\tJ\u001a\u0010\u001e\u001a\u00020\u000b2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010 \u001a\u00020\u000fJ\u0016\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0013J\u001a\u0010$\u001a\u00020\u000b2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010&\u001a\u00020\u0017R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrLocalStorage;", "", "()V", "cacheStack", "", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrCallableCache;", "localClassCache", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "enterCallable", "", "getLocalClass", "localClass", "getLocalFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "localFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "getParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "leaveCallable", "putLocalClass", "firClass", "irClass", "putLocalFunction", "firFunction", "irFunction", "putParameter", "firParameter", "irParameter", "putVariable", "firVariable", "irVariable", "fir2ir"})
public final class Fir2IrLocalStorage {
    private final List<Fir2IrCallableCache> cacheStack;
    private final Map<FirClass<?>, IrClass> localClassCache;

    public final void enterCallable() {
        Collection collection = this.cacheStack;
        Fir2IrCallableCache fir2IrCallableCache = new Fir2IrCallableCache();
        boolean bl = false;
        collection.add(fir2IrCallableCache);
    }

    public final void leaveCallable() {
        CollectionsKt.last(this.cacheStack).clear();
        this.cacheStack.remove(this.cacheStack.size() - 1);
    }

    @Nullable
    public final IrValueParameter getParameter(@NotNull FirValueParameter parameter) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        for (Fir2IrCallableCache cache2 : CollectionsKt.asReversedMutable(this.cacheStack)) {
            IrValueParameter local2 = cache2.getParameter(parameter);
            if (local2 == null) continue;
            return local2;
        }
        return null;
    }

    @Nullable
    public final IrVariable getVariable(@NotNull FirVariable<?> variable2) {
        Intrinsics.checkNotNullParameter(variable2, "variable");
        for (Fir2IrCallableCache cache2 : CollectionsKt.asReversedMutable(this.cacheStack)) {
            IrVariable local2 = cache2.getVariable(variable2);
            if (local2 == null) continue;
            return local2;
        }
        return null;
    }

    @Nullable
    public final IrClass getLocalClass(@NotNull FirClass<?> localClass) {
        Intrinsics.checkNotNullParameter(localClass, "localClass");
        return this.localClassCache.get(localClass);
    }

    @Nullable
    public final IrSimpleFunction getLocalFunction(@NotNull FirFunction<?> localFunction) {
        Intrinsics.checkNotNullParameter(localFunction, "localFunction");
        for (Fir2IrCallableCache cache2 : CollectionsKt.asReversedMutable(this.cacheStack)) {
            IrSimpleFunction local2 = cache2.getLocalFunction(localFunction);
            if (local2 == null) continue;
            return local2;
        }
        return null;
    }

    public final void putParameter(@NotNull FirValueParameter firParameter, @NotNull IrValueParameter irParameter2) {
        Intrinsics.checkNotNullParameter(firParameter, "firParameter");
        Intrinsics.checkNotNullParameter(irParameter2, "irParameter");
        CollectionsKt.last(this.cacheStack).putParameter(firParameter, irParameter2);
    }

    public final void putVariable(@NotNull FirVariable<?> firVariable, @NotNull IrVariable irVariable2) {
        Intrinsics.checkNotNullParameter(firVariable, "firVariable");
        Intrinsics.checkNotNullParameter(irVariable2, "irVariable");
        CollectionsKt.last(this.cacheStack).putVariable(firVariable, irVariable2);
    }

    public final void putLocalClass(@NotNull FirClass<?> firClass, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(firClass, "firClass");
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        this.localClassCache.put(firClass, irClass2);
    }

    public final void putLocalFunction(@NotNull FirFunction<?> firFunction, @NotNull IrSimpleFunction irFunction) {
        Intrinsics.checkNotNullParameter(firFunction, "firFunction");
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        CollectionsKt.last(this.cacheStack).putLocalFunction(firFunction, irFunction);
    }

    public Fir2IrLocalStorage() {
        boolean bl = false;
        this.cacheStack = new ArrayList();
        bl = false;
        this.localClassCache = new LinkedHashMap();
    }
}

