/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FlatMapResolver
implements ValuesOrderResolver {
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        if (info == null) {
            FlatMapResolver.$$$reportNull$$$0(0);
        }
        Map<Integer, TraceElement> before = info.getValuesOrderBefore();
        Map<Integer, TraceElement> after = info.getValuesOrderAfter();
        HashMap<TraceElement, List<TraceElement>> forward = new HashMap<TraceElement, List<TraceElement>>();
        HashMap<TraceElement, List<TraceElement>> backward = new HashMap<TraceElement, List<TraceElement>>();
        int[] beforeTimes = before.keySet().stream().mapToInt(Integer::intValue).toArray();
        int[] afterTimes = after.keySet().stream().mapToInt(Integer::intValue).toArray();
        int beforeIndex = 0;
        for (int i = 0; i < beforeTimes.length; ++i) {
            int nextBeforeTime;
            TraceElement afterElement = before.get(beforeTimes[i]);
            ArrayList<TraceElement> afterElements = new ArrayList<TraceElement>();
            int n = nextBeforeTime = i + 1 < beforeTimes.length ? beforeTimes[i + 1] : Integer.MAX_VALUE;
            while (beforeIndex < afterTimes.length && afterTimes[beforeIndex] < nextBeforeTime) {
                TraceElement beforeElement = after.get(afterTimes[beforeIndex]);
                afterElements.add(beforeElement);
                backward.put(beforeElement, Collections.singletonList(afterElement));
                ++beforeIndex;
            }
            forward.put(afterElement, afterElements);
        }
        ValuesOrderResolver.Result result = ValuesOrderResolver.Result.of(forward, backward);
        if (result == null) {
            FlatMapResolver.$$$reportNull$$$0(1);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/resolve/FlatMapResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/resolve/FlatMapResolver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

