/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detector.chain;

import com.intellij.grazie.detector.ChainLanguageDetector;
import com.intellij.grazie.detector.LanguageDetector;
import com.intellij.grazie.detector.LanguageFilter;
import com.intellij.grazie.detector.chain.ChainDetectorImpl;
import com.intellij.grazie.detector.heuristics.list.ListDetector;
import com.intellij.grazie.detector.heuristics.rule.RuleDetector;
import com.intellij.grazie.detector.heuristics.rule.RuleFilter;
import com.intellij.grazie.detector.model.DetectedLanguage;
import com.intellij.grazie.detector.model.Language;
import com.intellij.grazie.detector.ngram.NgramDetector;
import com.intellij.grazie.detector.utils.StatisticsKt;
import com.intellij.grazie.detector.utils.filter.TextFilter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/grazie/detector/chain/ChainDetectorImpl;", "Lcom/intellij/grazie/detector/ChainLanguageDetector;", "", "ngram", "Lcom/intellij/grazie/detector/ngram/NgramDetector;", "rule", "Lcom/intellij/grazie/detector/heuristics/rule/RuleDetector;", "list", "Lcom/intellij/grazie/detector/heuristics/list/ListDetector;", "filter", "Lcom/intellij/grazie/detector/heuristics/rule/RuleFilter;", "(Lcom/intellij/grazie/detector/ngram/NgramDetector;Lcom/intellij/grazie/detector/heuristics/rule/RuleDetector;Lcom/intellij/grazie/detector/heuristics/list/ListDetector;Lcom/intellij/grazie/detector/heuristics/rule/RuleFilter;)V", "detectWithDetails", "Lcom/intellij/grazie/detector/ChainLanguageDetector$ChainDetectionResult;", "input", "language-detector"})
public final class ChainDetectorImpl
implements ChainLanguageDetector<CharSequence> {
    private final NgramDetector ngram;
    private final RuleDetector rule;
    private final ListDetector list;
    private final RuleFilter filter;

    @Override
    @NotNull
    public ChainLanguageDetector.ChainDetectionResult detectWithDetails(@NotNull CharSequence input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        CharSequence text = TextFilter.Companion.getDefault().filter(input);
        List words2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)text, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null)), (Function1)detectWithDetails.words.1.INSTANCE), (Function1)detectWithDetails.words.2.INSTANCE));
        LinkedHashSet<LanguageDetector.DetectionResult> all2 = new LinkedHashSet<LanguageDetector.DetectionResult>();
        LanguageDetector.DetectionResult rulesDetection = this.rule.detect(words2);
        Collection collection = all2;
        boolean bl = false;
        collection.add(rulesDetection);
        if (rulesDetection.getPreferred() != Language.UNKNOWN) {
            return new ChainLanguageDetector.ChainDetectionResult(rulesDetection, all2, new ChainLanguageDetector.ChainDetectionResult.Information(words2.size()));
        }
        LanguageDetector.DetectionResult freqDetection = this.list.detect(words2);
        Collection collection2 = all2;
        boolean bl2 = false;
        collection2.add(freqDetection);
        if (freqDetection.getPreferred() != Language.UNKNOWN) {
            return new ChainLanguageDetector.ChainDetectionResult(freqDetection, all2, new ChainLanguageDetector.ChainDetectionResult.Information(words2.size()));
        }
        LanguageFilter.FilterResult ruleFiltering = this.filter.filter(words2);
        Map<Language, Double> weights = StatisticsKt.toMap((Iterable<DetectedLanguage>)StatisticsKt.unite(rulesDetection.getDetected(), freqDetection.getDetected(), ruleFiltering.getDetected()));
        LanguageDetector.DetectionResult ngramDetection = this.ngram.detect(text, weights);
        Collection collection3 = all2;
        boolean bl3 = false;
        collection3.add(ngramDetection);
        return new ChainLanguageDetector.ChainDetectionResult(ngramDetection, all2, new ChainLanguageDetector.ChainDetectionResult.Information(words2.size()));
    }

    public ChainDetectorImpl(@NotNull NgramDetector ngram, @NotNull RuleDetector rule, @NotNull ListDetector list, @NotNull RuleFilter filter2) {
        Intrinsics.checkParameterIsNotNull((Object)ngram, (String)"ngram");
        Intrinsics.checkParameterIsNotNull((Object)rule, (String)"rule");
        Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
        Intrinsics.checkParameterIsNotNull((Object)filter2, (String)"filter");
        this.ngram = ngram;
        this.rule = rule;
        this.list = list;
        this.filter = filter2;
    }

    @Override
    @NotNull
    public LanguageDetector.DetectionResult detect(@NotNull CharSequence input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return ChainLanguageDetector.DefaultImpls.detect(this, input);
    }
}

