/*
 * Decompiled with CFR 0.152.
 */
package training.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Desktop;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.interfaces.Lesson;
import training.learn.lesson.LessonManager;
import training.learn.lesson.LessonStateManager;
import training.ui.LearnToolWindow;
import training.ui.LearnToolWindowFactory;
import training.ui.LearningUiManager;
import training.util.UtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000l\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\u001a\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002\u001a\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0002\u001a\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 \u001a\u0018\u0010!\u001a\u0004\u0018\u00010\u00022\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\n\u001a\b\u0010$\u001a\u0004\u0018\u00010%\u001a\b\u0010&\u001a\u0004\u0018\u00010%\u001a\u000e\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)\u001a\u0016\u0010*\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u001e\u001a\u0012\u0010+\u001a\u0004\u0018\u00010%2\b\u0010\u001f\u001a\u0004\u0018\u00010 \u001a\u000e\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u0002\u001a\u000e\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u001e\u001a\u0010\u00100\u001a\u000201*\b\u0012\u0004\u0012\u00020302\" \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0004\u001a\u00020\u00028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\"\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u000e\u0010\r\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"excludedLanguages", "", "", "", "featureTrainerVersion", "getFeatureTrainerVersion", "()Ljava/lang/String;", "featureTrainerVersion$delegate", "Lkotlin/Lazy;", "switchOnExperimentalLessons", "", "getSwitchOnExperimentalLessons", "()Z", "trainerPluginConfigName", "clearTrainingProgress", "", "courseCanBeUsed", "languageId", "createBalloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "text", "delay", "", "createNamedSingleThreadExecutor", "Ljava/util/concurrent/ExecutorService;", "name", "findLanguageByID", "Lcom/intellij/lang/Language;", "id", "findLanguageSupport", "Ltraining/lang/LangSupport;", "project", "Lcom/intellij/openapi/project/Project;", "getFeedbackLink", "langSupport", "ownRegistry", "getNextLessonForCurrent", "Ltraining/learn/interfaces/Lesson;", "getPreviousLessonForCurrent", "invokeActionForFocusContext", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "isLearningProject", "lessonOpenedInProject", "openLinkInBrowser", "link", "resetPrimaryLanguage", "activeLangSupport", "wrapWithUrlPanel", "Ljavax/swing/JPanel;", "Lcom/intellij/ui/components/labels/LinkLabel;", "", "intellij.featuresTrainer"})
public final class UtilsKt {
    private static final Map<String, String[]> excludedLanguages = MapsKt.mapOf((Pair)TuplesKt.to((Object)"AppCode", (Object)new String[]{"JavaScript"}));
    @NotNull
    public static final String trainerPluginConfigName = "ide-features-trainer.xml";
    @NotNull
    private static final Lazy featureTrainerVersion$delegate = LazyKt.lazy((Function0)featureTrainerVersion.2.INSTANCE);

    @NotNull
    public static final ExecutorService createNamedSingleThreadExecutor(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(name).build());
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"Executors.newSingleThrea\u2026NameFormat(name).build())");
        return executorService;
    }

    public static final boolean courseCanBeUsed(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        Object[] excludedCourses = excludedLanguages.get(applicationNamesInfo.getProductName());
        return excludedCourses == null || !ArraysKt.contains((Object[])excludedCourses, (Object)languageId);
    }

    @Nullable
    public static final Language findLanguageByID(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String string = id;
        boolean bl = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String effectiveId = Intrinsics.areEqual((Object)string2, (Object)"cpp") ? "ObjectiveC" : id;
        return Language.findLanguageByID((String)effectiveId);
    }

    @NotNull
    public static final Balloon createBalloon(@Nls @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return UtilsKt.createBalloon(text2, 3000L);
    }

    @NotNull
    public static final Balloon createBalloon(@Nls @NotNull String text2, long delay) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(text2, null, UIUtil.getToolTipBackground(), null).setHideOnClickOutside(true).setCloseButtonEnabled(true).setHideOnKeyOutside(true).setAnimationCycle(0).setFadeoutTime(delay).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"JBPopupFactory.getInstan\u2026lay)\n    .createBalloon()");
        return balloon;
    }

    @NotNull
    public static final String getFeatureTrainerVersion() {
        Lazy lazy = featureTrainerVersion$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    public static final void clearTrainingProgress() {
        LessonManager.Companion.getInstance().stopLesson$intellij_featuresTrainer();
        LessonStateManager.INSTANCE.resetPassedStatus();
        for (LearnToolWindow toolWindow : LearnToolWindowFactory.Companion.getLearnWindowPerProject().values()) {
            toolWindow.reinitViews();
            toolWindow.setModulesPanel();
        }
        LearningUiManager.INSTANCE.setActiveToolWindow(null);
    }

    public static final boolean resetPrimaryLanguage(@NotNull LangSupport activeLangSupport) {
        Intrinsics.checkNotNullParameter((Object)activeLangSupport, (String)"activeLangSupport");
        LangSupport old = LangManager.Companion.getInstance().getLangSupport();
        if (Intrinsics.areEqual((Object)activeLangSupport, (Object)old) ^ true) {
            LessonManager.Companion.getInstance().stopLesson$intellij_featuresTrainer();
            LangManager.Companion.getInstance().updateLangSupport(activeLangSupport);
            LearnToolWindow learnToolWindow = LearningUiManager.INSTANCE.getActiveToolWindow();
            if (learnToolWindow != null) {
                learnToolWindow.setModulesPanel();
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static final LangSupport findLanguageSupport(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport2 == null) {
            return null;
        }
        LangSupport langSupport3 = langSupport2;
        if (UtilsKt.isLearningProject(project, langSupport3)) {
            return langSupport3;
        }
        return null;
    }

    public static final boolean isLearningProject(@NotNull Project project, @NotNull LangSupport langSupport2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)langSupport2, (String)"langSupport");
        return FileUtil.pathsEqual((String)project.getBasePath(), (String)LangManager.Companion.getInstance().getLearningProjectPath(langSupport2));
    }

    @Nullable
    public static final String getFeedbackLink(@NotNull LangSupport langSupport2, boolean ownRegistry) {
        Intrinsics.checkNotNullParameter((Object)langSupport2, (String)"langSupport");
        String string = langSupport2.getPrimaryLanguage();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String suffix = string3;
        boolean needToShow = Registry.is((String)("ift.show.feedback.link" + (ownRegistry ? '.' + suffix : "")), (boolean)false);
        return needToShow ? "https://surveys.jetbrains.com/s3/features-trainer-feedback-" + suffix : null;
    }

    public static final boolean getSwitchOnExperimentalLessons() {
        return Registry.is((String)"ift.experimental.lessons", (boolean)false);
    }

    public static final void invokeActionForFocusContext(@NotNull AnAction action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        DataManager dataManager = DataManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dataManager, (String)"DataManager.getInstance()");
        dataManager.getDataContextFromFocusAsync().onSuccess((Consumer)new Consumer<DataContext>(action2){
            final /* synthetic */ AnAction $action;

            public final void accept(DataContext dataContext) {
                ModalityState modalityState$iv = null;
                boolean $i$f$invokeLater = false;
                Application application = ApplicationManager.getApplication();
                Runnable runnable2 = new Runnable(this, dataContext){
                    final /* synthetic */ invokeActionForFocusContext.1 this$0;
                    final /* synthetic */ DataContext $dataContext$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$dataContext$inlined = dataContext;
                    }

                    public final void run() {
                        boolean bl = false;
                        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)this.this$0.$action, null, (String)"LearnToolwindow", (DataContext)this.$dataContext$inlined);
                        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"AnActionEvent.createFrom\u2026_TOOLWINDOW, dataContext)");
                        AnActionEvent event = anActionEvent;
                        ActionUtil.performActionDumbAwareWithCallbacks((AnAction)this.this$0.$action, (AnActionEvent)event, (DataContext)this.$dataContext$inlined);
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application.invokeLater(runnable2, modalityState);
            }
            {
                this.$action = anAction;
            }
        });
    }

    public static final void openLinkInBrowser(@NotNull String link) {
        Desktop desktop;
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            desktop.browse(new URI(link));
        }
    }

    @NotNull
    public static final JPanel wrapWithUrlPanel(@NotNull LinkLabel<Object> $this$wrapWithUrlPanel) {
        Intrinsics.checkNotNullParameter($this$wrapWithUrlPanel, (String)"$this$wrapWithUrlPanel");
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add((Component)$this$wrapWithUrlPanel, "Center");
        jPanel.add((Component)new JLabel(AllIcons.Ide.External_link_arrow), "East");
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        jPanel.setAlignmentX(0.0f);
        return jPanel;
    }

    @Nullable
    public static final Lesson lessonOpenedInProject(@Nullable Project project) {
        Map<Project, LearnToolWindow> map = LearnToolWindowFactory.Companion.getLearnWindowPerProject();
        boolean bl = false;
        return map.get(project) != null ? LessonManager.Companion.getInstance().getCurrentLesson() : null;
    }

    @Nullable
    public static final Lesson getNextLessonForCurrent() {
        Lesson lesson = LessonManager.Companion.getInstance().getCurrentLesson();
        if (lesson == null) {
            return null;
        }
        Lesson lesson2 = lesson;
        List<Lesson> lessonsForModules = CourseManager.Companion.getInstance().getLessonsForModules();
        int index = lessonsForModules.indexOf(lesson2);
        if (index < 0 || index >= lessonsForModules.size() - 1) {
            return null;
        }
        return lessonsForModules.get(index + 1);
    }

    @Nullable
    public static final Lesson getPreviousLessonForCurrent() {
        Lesson lesson = LessonManager.Companion.getInstance().getCurrentLesson();
        if (lesson == null) {
            return null;
        }
        Lesson lesson2 = lesson;
        List<Lesson> lessonsForModules = CourseManager.Companion.getInstance().getLessonsForModules();
        int index = lessonsForModules.indexOf(lesson2);
        if (index <= 0) {
            return null;
        }
        return lessonsForModules.get(index - 1);
    }
}

