/*
 * Decompiled with CFR 0.152.
 */
package training.util;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import training.commands.kotlin.TaskTestContext;
import training.learn.CourseManager;
import training.learn.interfaces.Lesson;
import training.learn.lesson.LessonListener;
import training.learn.lesson.kimpl.KLesson;
import training.util.LearningLessonsAutoExecutorKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Ltraining/util/LearningLessonsAutoExecutor;", "", "project", "Lcom/intellij/openapi/project/Project;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "executeLesson", "", "lesson", "Ltraining/learn/interfaces/Lesson;", "runAllLessons", "runSingleLesson", "Companion", "intellij.featuresTrainer"})
public final class LearningLessonsAutoExecutor {
    @NotNull
    private final Project project;
    private final ProgressIndicator progress;
    public static final Companion Companion = new Companion(null);

    private final void runSingleLesson(Lesson lesson) {
        ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(this, lesson){
            final /* synthetic */ LearningLessonsAutoExecutor this$0;
            final /* synthetic */ Lesson $lesson;

            public final void invoke() {
                CourseManager.Companion.getInstance().openLesson(this.this$0.getProject(), this.$lesson);
            }
            {
                this.this$0 = learningLessonsAutoExecutor;
                this.$lesson = lesson;
                super(0);
            }
        }), (int)1, null);
        try {
            this.executeLesson(lesson);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        if (!lesson.getPassed()) {
            LearningLessonsAutoExecutorKt.access$getLOG$p().error("Can't pass lesson " + lesson.getName());
        }
    }

    private final void runAllLessons() {
        TaskTestContext.Companion.setInTestMode(true);
        List<Lesson> lessons = CourseManager.Companion.getInstance().getLessonsForModules();
        for (Lesson lesson : lessons) {
            if (!(lesson instanceof KLesson)) continue;
            this.progress.checkCanceled();
            this.runSingleLesson(lesson);
        }
        TaskTestContext.Companion.setInTestMode(false);
    }

    private final void executeLesson(Lesson lesson) {
        AsyncPromise lessonPromise = new AsyncPromise();
        lesson.addLessonListener(new LessonListener(lessonPromise){
            final /* synthetic */ AsyncPromise $lessonPromise;

            public void lessonPassed(@NotNull Lesson lesson) {
                Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
                this.$lessonPromise.setResult((Object)true);
            }
            {
                this.$lessonPromise = $captured_local_variable$0;
            }

            public void lessonStarted(@NotNull Lesson lesson) {
                Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
                LessonListener.DefaultImpls.lessonStarted(this, lesson);
            }

            public void lessonStopped(@NotNull Lesson lesson) {
                Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
                LessonListener.DefaultImpls.lessonStopped(this, lesson);
            }
        });
        this.progress.checkCanceled();
        Boolean passedStatus = (Boolean)lessonPromise.blockingGet(lesson.getTestScriptProperties().getDuration(), TimeUnit.SECONDS);
        if (passedStatus == null || !passedStatus.booleanValue()) {
            LearningLessonsAutoExecutorKt.access$getLOG$p().error("Can't pass lesson " + lesson.getName());
        } else {
            System.err.println("Passed " + lesson.getName());
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public LearningLessonsAutoExecutor(@NotNull Project project, @NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        this.project = project;
        this.progress = progress;
    }

    public static final /* synthetic */ void access$runAllLessons(LearningLessonsAutoExecutor $this) {
        $this.runAllLessons();
    }

    public static final /* synthetic */ void access$runSingleLesson(LearningLessonsAutoExecutor $this, Lesson lesson) {
        $this.runSingleLesson(lesson);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Ltraining/util/LearningLessonsAutoExecutor$Companion;", "", "()V", "runAllLessons", "", "project", "Lcom/intellij/openapi/project/Project;", "runSingleLesson", "lesson", "Ltraining/learn/interfaces/Lesson;", "intellij.featuresTrainer"})
    public static final class Companion {
        public final void runAllLessons(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String title$iv = "Running All Lessons";
            boolean cancellable$iv = true;
            boolean $i$f$runBackgroundableTask = false;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title$iv, cancellable$iv, project, title$iv, cancellable$iv, project){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $title;
                final /* synthetic */ boolean $cancellable;
                final /* synthetic */ Project $project$inlined;
                {
                    this.$project = $captured_local_variable$1;
                    this.$title = $captured_local_variable$2;
                    this.$cancellable = $captured_local_variable$3;
                    this.$project$inlined = project;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    try {
                        LearningLessonsAutoExecutor learningLessonsAutoExecutor = new LearningLessonsAutoExecutor(this.$project$inlined, it);
                        LearningLessonsAutoExecutor.access$runAllLessons(learningLessonsAutoExecutor);
                    }
                    finally {
                        TaskTestContext.Companion.setInTestMode(false);
                    }
                }
            });
        }

        public final void runSingleLesson(@NotNull Project project, @NotNull Lesson lesson) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
            String title$iv = "Running lesson " + lesson.getName();
            boolean cancellable$iv = true;
            boolean $i$f$runBackgroundableTask = false;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title$iv, cancellable$iv, project, title$iv, cancellable$iv, project, lesson){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $title;
                final /* synthetic */ boolean $cancellable;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ Lesson $lesson$inlined;
                {
                    this.$project = $captured_local_variable$1;
                    this.$title = $captured_local_variable$2;
                    this.$cancellable = $captured_local_variable$3;
                    this.$project$inlined = project;
                    this.$lesson$inlined = lesson;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    TaskTestContext.Companion.setInTestMode(true);
                    try {
                        LearningLessonsAutoExecutor learningLessonsAutoExecutor = new LearningLessonsAutoExecutor(this.$project$inlined, it);
                        LearningLessonsAutoExecutor.access$runSingleLesson(learningLessonsAutoExecutor, this.$lesson$inlined);
                    }
                    finally {
                        TaskTestContext.Companion.setInTestMode(false);
                    }
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

