/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.FeaturesTrainerIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.ui.ActionKeyPopupKt;
import training.ui.LearningUiManager;
import training.ui.LessonMessagePane;
import training.ui.LessonMessagePane$WhenMappings;
import training.ui.MessagePart;
import training.ui.UISettings;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 T2\u00020\u0001:\u0004TUVWB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\r2\u0006\u0010!\u001a\u00020\u0013H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\r2\u0006\u0010!\u001a\u00020\u0013H\u0002J\u0006\u0010#\u001a\u00020\u0017J\u0006\u0010$\u001a\u00020\u0017J,\u0010%\u001a\u00020\u00172\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002JC\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2!\u0010.\u001a\u001d\u0012\u0013\u0012\u001100\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(3\u0012\u0004\u0012\u00020\u00170/H\u0002J\b\u00104\u001a\u000205H\u0016J\u0012\u00106\u001a\u0004\u0018\u00010\r2\u0006\u00107\u001a\u000208H\u0002J\b\u00109\u001a\u00020\u0017H\u0002J\u0018\u0010:\u001a\u00020\u00172\u0006\u0010;\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020<H\u0002J\u0006\u0010=\u001a\u00020\nJ\u0010\u0010>\u001a\u00020\u00172\u0006\u0010?\u001a\u00020@H\u0014J\u0010\u0010A\u001a\u00020\u00172\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010B\u001a\u00020\u00172\u0006\u0010?\u001a\u00020@H\u0002J\u0006\u0010C\u001a\u00020\u0017J\u0006\u0010D\u001a\u00020\u0017J\u000e\u0010E\u001a\u00020\u00172\u0006\u0010F\u001a\u00020\nJ&\u0010G\u001a\u00020\u00172\u0006\u0010H\u001a\u00020\n2\u0006\u0010I\u001a\u00020\n2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u000e\u0010K\u001a\u00020\u00172\u0006\u0010F\u001a\u00020\nJ\u0010\u0010L\u001a\u00020\u00172\u0006\u0010M\u001a\u00020\u0005H\u0002J*\u0010N\u001a\u00020\u00172\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020\n2\b\u0010R\u001a\u0004\u0018\u00010\u00072\u0006\u0010S\u001a\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Ltraining/ui/LessonMessagePane;", "Ljavax/swing/JTextPane;", "()V", "activeMessages", "", "Ltraining/ui/LessonMessagePane$LessonMessage;", "fontFamily", "", "inactiveMessages", "insertOffset", "", "ranges", "", "Ltraining/ui/LessonMessagePane$RangeData;", "restoreMessages", "addMessage", "Ljava/awt/Rectangle;", "messageParts", "", "Ltraining/ui/MessagePart;", "state", "Ltraining/ui/LessonMessagePane$MessageState;", "addPlaceholderForIcon", "", "icon", "Ljavax/swing/Icon;", "allLessonMessages", "appendClickableRange", "Lkotlin/ranges/IntRange;", "clickable", "attributeSet", "Ljavax/swing/text/SimpleAttributeSet;", "appendLink", "messagePart", "appendShortcut", "clear", "clearRestoreMessages", "drawRectangleAroundMessage", "lastPassedMessage", "lastActiveMessage", "g2d", "Ljava/awt/Graphics2D;", "needColor", "Ljava/awt/Color;", "drawRectangleAroundText", "myMessage", "draw", "Lkotlin/Function1;", "Ljava/awt/geom/RoundRectangle2D;", "Lkotlin/ParameterName;", "name", "r2d", "getMaximumSize", "Ljava/awt/Dimension;", "getRangeDataForMouse", "me", "Ljava/awt/event/MouseEvent;", "initStyleConstants", "insertText", "text", "Ljavax/swing/text/AttributeSet;", "messagesNumber", "paintComponent", "g", "Ljava/awt/Graphics;", "paintLessonCheckmarks", "paintMessages", "passPreviousMessages", "redrawMessages", "removeInactiveMessages", "number", "removeMessagesRange", "startIdx", "endIdx", "list", "resetMessagesNumber", "setInactiveStyle", "lessonMessage", "showShortcutBalloon", "point", "Ljava/awt/Point;", "height", "actionName", "shortcut", "Companion", "LessonMessage", "MessageState", "RangeData", "intellij.featuresTrainer"})
public final class LessonMessagePane
extends JTextPane {
    private final List<LessonMessage> activeMessages;
    private final List<LessonMessage> restoreMessages;
    private final List<LessonMessage> inactiveMessages;
    private final String fontFamily;
    private final Set<RangeData> ranges;
    private int insertOffset;
    private static final Logger LOG;
    private static final SimpleAttributeSet INACTIVE;
    private static final SimpleAttributeSet REGULAR;
    private static final SimpleAttributeSet BOLD;
    private static final SimpleAttributeSet SHORTCUT;
    private static final SimpleAttributeSet ROBOTO;
    private static final SimpleAttributeSet CODE;
    private static final SimpleAttributeSet LINK;
    private static final SimpleAttributeSet TASK_PARAGRAPH_STYLE;
    private static final Lazy arc$delegate;
    private static final Lazy indent$delegate;
    private static final Lazy activeTaskInset$delegate;
    public static final Companion Companion;

    private final List<LessonMessage> allLessonMessages() {
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.activeMessages, (Iterable)this.restoreMessages), (Iterable)this.inactiveMessages);
    }

    /*
     * WARNING - void declaration
     */
    private final RangeData getRangeDataForMouse(MouseEvent me) {
        RangeData result2;
        int n;
        block10: {
            block9: {
                Object v0;
                int offset;
                block8: {
                    Point point = new Point(me.getX(), me.getY());
                    offset = this.viewToModel(point);
                    Iterable iterable = this.ranges;
                    n = 0;
                    Iterable iterable2 = iterable;
                    boolean bl = false;
                    for (Object t : iterable2) {
                        RangeData it = (RangeData)t;
                        boolean bl2 = false;
                        if (!it.getRange().contains(offset)) continue;
                        v0 = t;
                        break block8;
                    }
                    v0 = null;
                }
                RangeData rangeData = v0;
                if (rangeData == null) {
                    return null;
                }
                result2 = rangeData;
                if (offset < 0) break block9;
                Document document = this.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
                if (offset < document.getLength()) break block10;
            }
            return null;
        }
        IntRange intRange = result2.getRange();
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                void i2;
                Rectangle rectangle2 = this.modelToView((int)i2);
                if (me.getX() >= rectangle2.x && me.getY() >= rectangle2.y && me.getY() <= rectangle2.y + rectangle2.height) {
                    return result2;
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        return null;
    }

    private final void initStyleConstants() {
        int fontSize = (int)UISettings.Companion.getInstance().getFontSize();
        StyleConstants.setForeground(INACTIVE, (Color)UISettings.Companion.getInstance().getPassedColor());
        StyleConstants.setFontFamily(REGULAR, this.fontFamily);
        StyleConstants.setFontSize(REGULAR, fontSize);
        StyleConstants.setForeground(REGULAR, (Color)JBColor.BLACK);
        StyleConstants.setFontFamily(BOLD, this.fontFamily);
        StyleConstants.setFontSize(BOLD, fontSize);
        StyleConstants.setBold(BOLD, true);
        StyleConstants.setForeground(BOLD, (Color)JBColor.BLACK);
        StyleConstants.setFontFamily(SHORTCUT, this.fontFamily);
        StyleConstants.setFontSize(SHORTCUT, fontSize);
        StyleConstants.setBold(SHORTCUT, true);
        StyleConstants.setForeground(SHORTCUT, (Color)JBColor.BLACK);
        StyleConstants.setForeground(CODE, (Color)UISettings.Companion.getInstance().getCodeForegroundColor());
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        editorColorsScheme.getEditorFontName();
        MutableAttributeSet mutableAttributeSet = CODE;
        EditorColorsManager editorColorsManager2 = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager2, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme2 = editorColorsManager2.getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme2, (String)"EditorColorsManager.getInstance().globalScheme");
        StyleConstants.setFontFamily(mutableAttributeSet, editorColorsScheme2.getEditorFontName());
        StyleConstants.setFontSize(CODE, fontSize);
        StyleConstants.setForeground(LINK, (Color)JBColor.BLUE);
        StyleConstants.setFontFamily(LINK, this.fontFamily);
        StyleConstants.setUnderline(LINK, true);
        StyleConstants.setFontSize(LINK, fontSize);
        StyleConstants.setLeftIndent(TASK_PARAGRAPH_STYLE, UISettings.Companion.getInstance().getCheckIndent());
        StyleConstants.setRightIndent(TASK_PARAGRAPH_STYLE, 0.0f);
        StyleConstants.setSpaceAbove(TASK_PARAGRAPH_STYLE, 20.0f);
        StyleConstants.setSpaceBelow(TASK_PARAGRAPH_STYLE, 0.0f);
        StyleConstants.setLineSpacing(TASK_PARAGRAPH_STYLE, 0.2f);
        StyleConstants.setForeground(REGULAR, (Color)UISettings.Companion.getInstance().getDefaultTextColor());
        StyleConstants.setForeground(BOLD, (Color)UISettings.Companion.getInstance().getDefaultTextColor());
        StyleConstants.setForeground(SHORTCUT, (Color)UISettings.Companion.getInstance().getShortcutTextColor());
        StyleConstants.setForeground(LINK, (Color)UISettings.Companion.getInstance().getLessonLinkColor());
        StyleConstants.setForeground(CODE, (Color)UISettings.Companion.getInstance().getCodeForegroundColor());
    }

    public final int messagesNumber() {
        return this.activeMessages.size();
    }

    private final void removeMessagesRange(int startIdx, int endIdx, List<LessonMessage> list2) {
        if (startIdx == endIdx) {
            return;
        }
        list2.subList(startIdx, endIdx).clear();
    }

    public final void clearRestoreMessages() {
        this.removeMessagesRange(0, this.restoreMessages.size(), this.restoreMessages);
        this.redrawMessages();
    }

    public final void removeInactiveMessages(int number) {
        this.removeMessagesRange(0, number, this.inactiveMessages);
        this.redrawMessages();
    }

    public final void resetMessagesNumber(int number) {
        List<LessonMessage> move = this.activeMessages.subList(number, this.activeMessages.size());
        Iterable $this$forEach$iv = move;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LessonMessage it = (LessonMessage)element$iv;
            boolean bl = false;
            it.setState(MessageState.INACTIVE);
        }
        this.inactiveMessages.addAll(0, (Collection<LessonMessage>)move);
        move.clear();
        this.clearRestoreMessages();
    }

    private final void insertText(String text2, AttributeSet attributeSet) {
        this.getDocument().insertString(this.insertOffset, text2, attributeSet);
        this.getStyledDocument().setParagraphAttributes(this.insertOffset, this.insertOffset + text2.length() - 1, TASK_PARAGRAPH_STYLE, true);
        this.insertOffset += text2.length();
    }

    @Nullable
    public final Rectangle addMessage(@NotNull List<MessagePart> messageParts, @NotNull MessageState state) {
        List<LessonMessage> list2;
        Intrinsics.checkNotNullParameter(messageParts, (String)"messageParts");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        LessonMessage lessonMessage = new LessonMessage(messageParts, state, 0, 0, 12, null);
        switch (LessonMessagePane$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                list2 = this.inactiveMessages;
                break;
            }
            case 2: {
                list2 = this.restoreMessages;
                break;
            }
            default: {
                list2 = this.activeMessages;
            }
        }
        list2.add(lessonMessage);
        this.redrawMessages();
        Rectangle rectangle2 = this.modelToView(lessonMessage.getStart());
        if (rectangle2 == null) {
            return null;
        }
        Rectangle startRect = rectangle2;
        Rectangle rectangle3 = this.modelToView(lessonMessage.getEnd() - 1);
        if (rectangle3 == null) {
            return null;
        }
        Rectangle endRect = rectangle3;
        return new Rectangle(startRect.x, startRect.y, endRect.x + endRect.width - startRect.x, endRect.y + endRect.height - startRect.y);
    }

    public static /* synthetic */ Rectangle addMessage$default(LessonMessagePane lessonMessagePane, List list2, MessageState messageState, int n, Object object) {
        if ((n & 2) != 0) {
            messageState = MessageState.NORMAL;
        }
        return lessonMessagePane.addMessage(list2, messageState);
    }

    public final void redrawMessages() {
        this.ranges.clear();
        this.setText("");
        this.insertOffset = 0;
        for (LessonMessage lessonMessage : this.allLessonMessages()) {
            List<MessagePart> messageParts = lessonMessage.getMessageParts();
            lessonMessage.setStart(this.insertOffset);
            if (this.insertOffset != 0) {
                this.insertText("\n", REGULAR);
            }
            for (MessagePart part : messageParts) {
                int startOffset = this.insertOffset;
                part.setStartOffset(startOffset);
                switch (LessonMessagePane$WhenMappings.$EnumSwitchMapping$1[part.getType().ordinal()]) {
                    case 1: {
                        this.insertText(part.getText(), REGULAR);
                        break;
                    }
                    case 2: {
                        this.insertText(part.getText(), BOLD);
                        break;
                    }
                    case 3: {
                        Object it;
                        Object object;
                        boolean bl;
                        boolean bl2;
                        if (this.appendShortcut(part) != null) {
                            bl2 = false;
                            bl = false;
                            it = object;
                            boolean bl3 = false;
                            this.ranges.add((RangeData)it);
                        }
                        break;
                    }
                    case 4: {
                        this.insertText(' ' + part.getText() + ' ', CODE);
                        break;
                    }
                    case 5: {
                        this.insertText(part.getText(), ROBOTO);
                        break;
                    }
                    case 6: {
                        Object it;
                        Object object;
                        boolean bl;
                        boolean bl2;
                        if (this.appendLink(part) != null) {
                            bl2 = false;
                            bl = false;
                            it = object;
                            boolean bl4 = false;
                            this.ranges.add((RangeData)it);
                        }
                        break;
                    }
                    case 7: {
                        Object it;
                        Object object;
                        boolean bl;
                        boolean bl2;
                        if ((Icon)LearningUiManager.INSTANCE.getIconMap().get((Object)part.getText()) != null) {
                            bl2 = false;
                            bl = false;
                            it = object;
                            boolean bl5 = false;
                            Object object2 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it");
                            this.addPlaceholderForIcon((Icon)object2);
                        }
                        break;
                    }
                    case 8: {
                        this.insertText(part.getText(), BOLD);
                        break;
                    }
                }
                part.setEndOffset(this.insertOffset);
            }
            lessonMessage.setEnd(this.insertOffset);
            if (lessonMessage.getState() != MessageState.INACTIVE) continue;
            this.setInactiveStyle(lessonMessage);
        }
    }

    private final void addPlaceholderForIcon(Icon icon) {
        String placeholder = " ";
        while (this.getFontMetrics(this.getFont()).stringWidth(placeholder) <= icon.getIconWidth()) {
            placeholder = placeholder + " ";
        }
        placeholder = placeholder + " ";
        this.insertText(placeholder, REGULAR);
    }

    public final void passPreviousMessages() {
        for (LessonMessage message : this.activeMessages) {
            message.setState(MessageState.PASSED);
        }
        this.redrawMessages();
    }

    private final void setInactiveStyle(LessonMessage lessonMessage) {
        this.getStyledDocument().setCharacterAttributes(lessonMessage.getStart(), lessonMessage.getEnd(), INACTIVE, false);
    }

    public final void clear() {
        this.setText("");
        this.activeMessages.clear();
        this.restoreMessages.clear();
        this.inactiveMessages.clear();
        this.ranges.clear();
    }

    private final RangeData appendLink(MessagePart messagePart) throws BadLocationException {
        IntRange clickRange = this.appendClickableRange(messagePart.getText(), LINK);
        Runnable runnable2 = messagePart.getRunnable();
        if (runnable2 == null) {
            return null;
        }
        Runnable runnable3 = runnable2;
        return new RangeData(clickRange, (Function2<? super Point, ? super Integer, Unit>)((Function2)new Function2<Point, Integer, Unit>(runnable3){
            final /* synthetic */ Runnable $runnable;

            public final void invoke(@NotNull Point $noName_0, int $noName_1) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                this.$runnable.run();
            }
            {
                this.$runnable = runnable2;
                super(2);
            }
        }));
    }

    private final RangeData appendShortcut(MessagePart messagePart) {
        IntRange range = this.appendClickableRange(' ' + messagePart.getText() + ' ', SHORTCUT);
        String string = messagePart.getLink();
        if (string == null) {
            return null;
        }
        String actionId = string;
        IntRange clickRange = new IntRange(range.getFirst() + 1, range.getLast() - 1);
        return new RangeData(clickRange, (Function2<? super Point, ? super Integer, Unit>)((Function2)new Function2<Point, Integer, Unit>(this, actionId, messagePart){
            final /* synthetic */ LessonMessagePane this$0;
            final /* synthetic */ String $actionId;
            final /* synthetic */ MessagePart $messagePart;

            public final void invoke(@NotNull Point p, int h) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                LessonMessagePane.access$showShortcutBalloon(this.this$0, p, h, this.$actionId, StringsKt.replace$default((String)this.$messagePart.getText(), (String)"\u00a0", (String)" ", (boolean)false, (int)4, null));
            }
            {
                this.this$0 = lessonMessagePane;
                this.$actionId = string;
                this.$messagePart = messagePart;
                super(2);
            }
        }));
    }

    private final void showShortcutBalloon(Point point, int height, String actionName, String shortcut) {
        if (actionName == null) {
            return;
        }
        ActionKeyPopupKt.showActionKeyPopup(this, point, height, actionName, shortcut);
    }

    private final IntRange appendClickableRange(String clickable, SimpleAttributeSet attributeSet) {
        int startLink = this.insertOffset;
        this.insertText(clickable, attributeSet);
        int endLink = this.insertOffset;
        int n = startLink;
        return new IntRange(n, endLink);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        try {
            this.paintMessages(g);
        }
        catch (BadLocationException e) {
            LOG.warn((Throwable)e);
        }
        super.paintComponent(g);
        this.paintLessonCheckmarks(g);
    }

    private final void paintLessonCheckmarks(Graphics g) {
        for (LessonMessage lessonMessage : this.allLessonMessages()) {
            if (lessonMessage.getState() != MessageState.PASSED) continue;
            int startOffset = lessonMessage.getStart();
            if (startOffset != 0) {
                ++startOffset;
            }
            try {
                Icon checkmark;
                Rectangle rectangle2 = this.modelToView(startOffset);
                Intrinsics.checkNotNullExpressionValue((Object)FeaturesTrainerIcons.Img.GreenCheckmark, (String)"FeaturesTrainerIcons.Img.GreenCheckmark");
                if (SystemInfo.isMac) {
                    checkmark.paintIcon(this, g, rectangle2.x - UISettings.Companion.getInstance().getCheckIndent(), rectangle2.y + JBUI.scale((int)1));
                    continue;
                }
                checkmark.paintIcon(this, g, rectangle2.x - UISettings.Companion.getInstance().getCheckIndent(), rectangle2.y + JBUI.scale((int)1));
            }
            catch (BadLocationException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    private final void paintMessages(Graphics g) throws BadLocationException {
        LessonMessage lastPassedMessage;
        LessonMessage lessonMessage;
        int n;
        LessonMessage lastActiveMessage;
        Graphics2D g2d;
        block9: {
            Graphics graphics = g;
            if (graphics == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
            }
            g2d = (Graphics2D)graphics;
            for (LessonMessage lessonMessage2 : this.allLessonMessages()) {
                List<MessagePart> myMessages = lessonMessage2.getMessageParts();
                for (MessagePart myMessage : myMessages) {
                    Icon icon;
                    if (myMessage.getType() == MessagePart.MessageType.SHORTCUT) {
                        JBColor bg = UISettings.Companion.getInstance().getShortcutBackgroundColor();
                        Color needColor = lessonMessage2.getState() == MessageState.INACTIVE ? new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 76) : (Color)bg;
                        this.drawRectangleAroundText(myMessage, g2d, needColor, (Function1<? super RoundRectangle2D, Unit>)((Function1)new Function1<RoundRectangle2D, Unit>(g2d){
                            final /* synthetic */ Graphics2D $g2d;

                            public final void invoke(@NotNull RoundRectangle2D r2d) {
                                Intrinsics.checkNotNullParameter((Object)r2d, (String)"r2d");
                                this.$g2d.fill(r2d);
                            }
                            {
                                this.$g2d = graphics2D;
                                super(1);
                            }
                        }));
                        continue;
                    }
                    if (myMessage.getType() == MessagePart.MessageType.CODE) {
                        this.drawRectangleAroundText(myMessage, g2d, (Color)UISettings.Companion.getInstance().getCodeBorderColor(), (Function1<? super RoundRectangle2D, Unit>)((Function1)new Function1<RoundRectangle2D, Unit>(g2d){
                            final /* synthetic */ Graphics2D $g2d;

                            public final void invoke(@NotNull RoundRectangle2D r2d) {
                                Intrinsics.checkNotNullParameter((Object)r2d, (String)"r2d");
                                this.$g2d.draw(r2d);
                            }
                            {
                                this.$g2d = graphics2D;
                                super(1);
                            }
                        }));
                        continue;
                    }
                    if (myMessage.getType() != MessagePart.MessageType.ICON_IDX) continue;
                    Rectangle2D rect = this.modelToView2D(myMessage.getStartOffset() + 1);
                    Icon icon2 = icon = (Icon)LearningUiManager.INSTANCE.getIconMap().get((Object)myMessage.getText());
                    if (icon2 == null) continue;
                    Component component2 = this;
                    Graphics graphics2 = g2d;
                    Rectangle2D rectangle2D = rect;
                    Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"rect");
                    icon2.paintIcon(component2, graphics2, (int)rectangle2D.getX(), (int)rect.getY());
                }
            }
            lastActiveMessage = (LessonMessage)CollectionsKt.lastOrNull(this.activeMessages);
            List<LessonMessage> $this$indexOfLast$iv = this.activeMessages;
            boolean $i$f$indexOfLast = false;
            ListIterator<LessonMessage> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                LessonMessage it = iterator$iv.previous();
                boolean bl = false;
                if (!(it.getState() == MessageState.PASSED)) continue;
                n = iterator$iv.nextIndex();
                break block9;
            }
            n = -1;
        }
        Integer n2 = n;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n2).intValue();
        boolean bl3 = false;
        Integer n3 = it != -1 && it < this.activeMessages.size() - 1 ? n2 : null;
        if (n3 != null) {
            n2 = n3;
            bl = false;
            bl2 = false;
            it = ((Number)n2).intValue();
            boolean bl4 = false;
            lessonMessage = this.activeMessages.get(it + 1);
        } else {
            lessonMessage = lastPassedMessage = null;
        }
        if (lastActiveMessage != null && lastActiveMessage.getState() == MessageState.NORMAL) {
            this.drawRectangleAroundMessage(lastPassedMessage, lastActiveMessage, g2d, (Color)UISettings.Companion.getInstance().getActiveTaskBorder());
        }
    }

    private final void drawRectangleAroundText(MessagePart myMessage, Graphics2D g2d, Color needColor, Function1<? super RoundRectangle2D, Unit> draw) {
        int startOffset = myMessage.getStartOffset();
        int endOffset = myMessage.getEndOffset();
        Rectangle2D rectangleStart = this.modelToView2D(startOffset + 1);
        Rectangle2D rectangleEnd = this.modelToView2D(endOffset - 1);
        Color color = g2d.getColor();
        float fontSize = UISettings.Companion.getInstance().getFontSize();
        g2d.setColor(needColor);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RoundRectangle2D r2d = !SystemInfo.isMac ? (RoundRectangle2D)new RoundRectangle2D.Double(rectangleStart.getX() - (double)(2 * LessonMessagePane.Companion.getIndent()), rectangleStart.getY() - (double)LessonMessagePane.Companion.getIndent() + (double)JBUIScale.scale((float)2.0f), rectangleEnd.getX() - rectangleStart.getX() + (double)(4 * LessonMessagePane.Companion.getIndent()), fontSize + (float)(2 * LessonMessagePane.Companion.getIndent()), LessonMessagePane.Companion.getArc(), LessonMessagePane.Companion.getArc()) : (RoundRectangle2D)new RoundRectangle2D.Double(rectangleStart.getX() - (double)(2 * LessonMessagePane.Companion.getIndent()), rectangleStart.getY() - (double)LessonMessagePane.Companion.getIndent() + (double)JBUIScale.scale((float)1.0f), rectangleEnd.getX() - rectangleStart.getX() + (double)(4 * LessonMessagePane.Companion.getIndent()), fontSize + (float)(2 * LessonMessagePane.Companion.getIndent()), LessonMessagePane.Companion.getArc(), LessonMessagePane.Companion.getArc());
        draw.invoke((Object)r2d);
        g2d.setColor(color);
    }

    private final void drawRectangleAroundMessage(LessonMessage lastPassedMessage, LessonMessage lastActiveMessage, Graphics2D g2d, Color needColor) {
        int n;
        LessonMessage lessonMessage = lastPassedMessage;
        if (lessonMessage != null) {
            LessonMessage lessonMessage2 = lessonMessage;
            boolean bl = false;
            boolean bl2 = false;
            LessonMessage it = lessonMessage2;
            boolean bl3 = false;
            n = it.getStart() + 1;
        } else {
            n = 0;
        }
        int startOffset = n;
        int endOffset = lastActiveMessage.getEnd();
        Rectangle2D rectangle2D = this.modelToView2D(startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"modelToView2D(startOffset)");
        double topLineX = rectangle2D.getX();
        Rectangle2D rectangle2D2 = this.modelToView2D(startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D2, (String)"modelToView2D(startOffset)");
        double topLineY = rectangle2D2.getY();
        Rectangle2D rectangle2D3 = this.modelToView2D(endOffset - 1);
        boolean bl = false;
        boolean bl4 = false;
        Rectangle2D it = rectangle2D3;
        boolean bl5 = false;
        Rectangle2D rectangle2D4 = it;
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D4, (String)"it");
        double bottomLineY = rectangle2D4.getY() + it.getHeight();
        double textHeight = bottomLineY - topLineY;
        Color color = g2d.getColor();
        g2d.setColor(needColor);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RoundRectangle2D r2d = !SystemInfo.isMac ? (RoundRectangle2D)new RoundRectangle2D.Double(topLineX - (double)LessonMessagePane.Companion.getActiveTaskInset(), topLineY - (double)LessonMessagePane.Companion.getActiveTaskInset() - (double)JBUIScale.scale((int)1), (double)this.getBounds().width - (double)UISettings.Companion.getInstance().getCheckIndent() - (double)((float)this.getInsets().right * 1.0f) + (double)(2 * LessonMessagePane.Companion.getActiveTaskInset()), textHeight + (double)(2 * LessonMessagePane.Companion.getActiveTaskInset()) - (double)JBUIScale.scale((int)2), LessonMessagePane.Companion.getArc(), LessonMessagePane.Companion.getArc()) : (RoundRectangle2D)new RoundRectangle2D.Double(topLineX - (double)LessonMessagePane.Companion.getActiveTaskInset(), topLineY - (double)LessonMessagePane.Companion.getActiveTaskInset() - (double)JBUIScale.scale((int)1), (double)this.getBounds().width - (double)UISettings.Companion.getInstance().getCheckIndent() - (double)((float)this.getInsets().right * 1.0f) + (double)(2 * LessonMessagePane.Companion.getActiveTaskInset()), textHeight + (double)(2 * LessonMessagePane.Companion.getActiveTaskInset()) - (double)JBUIScale.scale((int)2), LessonMessagePane.Companion.getArc(), LessonMessagePane.Companion.getArc());
        g2d.draw(r2d);
        g2d.setColor(color);
    }

    static /* synthetic */ void drawRectangleAroundMessage$default(LessonMessagePane lessonMessagePane, LessonMessage lessonMessage, LessonMessage lessonMessage2, Graphics2D graphics2D, Color color, int n, Object object) {
        if ((n & 1) != 0) {
            lessonMessage = null;
        }
        lessonMessagePane.drawRectangleAroundMessage(lessonMessage, lessonMessage2, graphics2D, color);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"preferredSize");
        return dimension;
    }

    public LessonMessagePane() {
        boolean bl = false;
        this.activeMessages = new ArrayList();
        bl = false;
        this.restoreMessages = new ArrayList();
        bl = false;
        this.inactiveMessages = new ArrayList();
        Font font = UIUtil.getLabelFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"UIUtil.getLabelFont()");
        String string = font.getFontName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UIUtil.getLabelFont().fontName");
        this.fontFamily = string;
        bl = false;
        this.ranges = new LinkedHashSet();
        UIUtil.doNotScrollToCaret((JTextComponent)this);
        this.initStyleConstants();
        this.setEditable(false);
        MouseAdapter listener2 = new MouseAdapter(this){
            final /* synthetic */ LessonMessagePane this$0;

            public void mouseClicked(@NotNull MouseEvent me) {
                Intrinsics.checkNotNullParameter((Object)me, (String)"me");
                RangeData rangeData = LessonMessagePane.access$getRangeDataForMouse(this.this$0, me);
                if (rangeData == null) {
                    return;
                }
                RangeData rangeData2 = rangeData;
                int middle = (rangeData2.getRange().getFirst() + rangeData2.getRange().getLast()) / 2;
                Rectangle rectangle2 = this.this$0.modelToView(middle);
                rangeData2.getAction().invoke((Object)new Point(rectangle2.x, rectangle2.y + rectangle2.height / 2), (Object)rectangle2.height);
            }

            public void mouseMoved(@NotNull MouseEvent me) {
                Intrinsics.checkNotNullParameter((Object)me, (String)"me");
                RangeData rangeData = LessonMessagePane.access$getRangeDataForMouse(this.this$0, me);
                this.this$0.setCursor(rangeData == null ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(12));
            }
            {
                this.this$0 = this$0;
            }
        };
        this.addMouseListener(listener2);
        this.addMouseMotionListener(listener2);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(LessonMessagePane.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(LessonMessagePane::class.java)");
        LOG = logger;
        INACTIVE = new SimpleAttributeSet();
        REGULAR = new SimpleAttributeSet();
        BOLD = new SimpleAttributeSet();
        SHORTCUT = new SimpleAttributeSet();
        ROBOTO = new SimpleAttributeSet();
        CODE = new SimpleAttributeSet();
        LINK = new SimpleAttributeSet();
        TASK_PARAGRAPH_STYLE = new SimpleAttributeSet();
        arc$delegate = LazyKt.lazy((Function0)Companion.arc.2.INSTANCE);
        indent$delegate = LazyKt.lazy((Function0)Companion.indent.2.INSTANCE);
        activeTaskInset$delegate = LazyKt.lazy((Function0)Companion.activeTaskInset.2.INSTANCE);
    }

    public static final /* synthetic */ void access$showShortcutBalloon(LessonMessagePane $this, Point point, int height, String actionName, String shortcut) {
        $this.showShortcutBalloon(point, height, actionName, shortcut);
    }

    public static final /* synthetic */ RangeData access$getRangeDataForMouse(LessonMessagePane $this, MouseEvent me) {
        return $this.getRangeDataForMouse(me);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ltraining/ui/LessonMessagePane$MessageState;", "", "(Ljava/lang/String;I)V", "NORMAL", "PASSED", "INACTIVE", "RESTORE", "INFORMER", "intellij.featuresTrainer"})
    public static final class MessageState
    extends Enum<MessageState> {
        public static final /* enum */ MessageState NORMAL;
        public static final /* enum */ MessageState PASSED;
        public static final /* enum */ MessageState INACTIVE;
        public static final /* enum */ MessageState RESTORE;
        public static final /* enum */ MessageState INFORMER;
        private static final /* synthetic */ MessageState[] $VALUES;

        static {
            MessageState[] messageStateArray = new MessageState[5];
            MessageState[] messageStateArray2 = messageStateArray;
            messageStateArray[0] = NORMAL = new MessageState();
            messageStateArray[1] = PASSED = new MessageState();
            messageStateArray[2] = INACTIVE = new MessageState();
            messageStateArray[3] = RESTORE = new MessageState();
            messageStateArray[4] = INFORMER = new MessageState();
            $VALUES = messageStateArray;
        }

        public static MessageState[] values() {
            return (MessageState[])$VALUES.clone();
        }

        public static MessageState valueOf(String string) {
            return Enum.valueOf(MessageState.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J7\u0010\u001b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Ltraining/ui/LessonMessagePane$LessonMessage;", "", "messageParts", "", "Ltraining/ui/MessagePart;", "state", "Ltraining/ui/LessonMessagePane$MessageState;", "start", "", "end", "(Ljava/util/List;Ltraining/ui/LessonMessagePane$MessageState;II)V", "getEnd", "()I", "setEnd", "(I)V", "getMessageParts", "()Ljava/util/List;", "getStart", "setStart", "getState", "()Ltraining/ui/LessonMessagePane$MessageState;", "setState", "(Ltraining/ui/LessonMessagePane$MessageState;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.featuresTrainer"})
    private static final class LessonMessage {
        @NotNull
        private final List<MessagePart> messageParts;
        @NotNull
        private MessageState state;
        private int start;
        private int end;

        @NotNull
        public final List<MessagePart> getMessageParts() {
            return this.messageParts;
        }

        @NotNull
        public final MessageState getState() {
            return this.state;
        }

        public final void setState(@NotNull MessageState messageState) {
            Intrinsics.checkNotNullParameter((Object)((Object)messageState), (String)"<set-?>");
            this.state = messageState;
        }

        public final int getStart() {
            return this.start;
        }

        public final void setStart(int n) {
            this.start = n;
        }

        public final int getEnd() {
            return this.end;
        }

        public final void setEnd(int n) {
            this.end = n;
        }

        public LessonMessage(@NotNull List<MessagePart> messageParts, @NotNull MessageState state, int start, int end) {
            Intrinsics.checkNotNullParameter(messageParts, (String)"messageParts");
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            this.messageParts = messageParts;
            this.state = state;
            this.start = start;
            this.end = end;
        }

        public /* synthetic */ LessonMessage(List list2, MessageState messageState, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            this(list2, messageState, n, n2);
        }

        @NotNull
        public final List<MessagePart> component1() {
            return this.messageParts;
        }

        @NotNull
        public final MessageState component2() {
            return this.state;
        }

        public final int component3() {
            return this.start;
        }

        public final int component4() {
            return this.end;
        }

        @NotNull
        public final LessonMessage copy(@NotNull List<MessagePart> messageParts, @NotNull MessageState state, int start, int end) {
            Intrinsics.checkNotNullParameter(messageParts, (String)"messageParts");
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            return new LessonMessage(messageParts, state, start, end);
        }

        public static /* synthetic */ LessonMessage copy$default(LessonMessage lessonMessage, List list2, MessageState messageState, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                list2 = lessonMessage.messageParts;
            }
            if ((n3 & 2) != 0) {
                messageState = lessonMessage.state;
            }
            if ((n3 & 4) != 0) {
                n = lessonMessage.start;
            }
            if ((n3 & 8) != 0) {
                n2 = lessonMessage.end;
            }
            return lessonMessage.copy(list2, messageState, n, n2);
        }

        @NotNull
        public String toString() {
            return "LessonMessage(messageParts=" + this.messageParts + ", state=" + (Object)((Object)this.state) + ", start=" + this.start + ", end=" + this.end + ")";
        }

        public int hashCode() {
            List<MessagePart> list2 = this.messageParts;
            MessageState messageState = this.state;
            return (((list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (messageState != null ? ((Object)((Object)messageState)).hashCode() : 0)) * 31 + Integer.hashCode(this.start)) * 31 + Integer.hashCode(this.end);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LessonMessage)) break block3;
                    LessonMessage lessonMessage = (LessonMessage)object;
                    if (!Intrinsics.areEqual(this.messageParts, lessonMessage.messageParts) || !Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)lessonMessage.state)) || this.start != lessonMessage.start || this.end != lessonMessage.end) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J/\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Ltraining/ui/LessonMessagePane$RangeData;", "", "range", "Lkotlin/ranges/IntRange;", "action", "Lkotlin/Function2;", "Ljava/awt/Point;", "", "", "(Lkotlin/ranges/IntRange;Lkotlin/jvm/functions/Function2;)V", "getAction", "()Lkotlin/jvm/functions/Function2;", "getRange", "()Lkotlin/ranges/IntRange;", "setRange", "(Lkotlin/ranges/IntRange;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.featuresTrainer"})
    private static final class RangeData {
        @NotNull
        private IntRange range;
        @NotNull
        private final Function2<Point, Integer, Unit> action;

        @NotNull
        public final IntRange getRange() {
            return this.range;
        }

        public final void setRange(@NotNull IntRange intRange) {
            Intrinsics.checkNotNullParameter((Object)intRange, (String)"<set-?>");
            this.range = intRange;
        }

        @NotNull
        public final Function2<Point, Integer, Unit> getAction() {
            return this.action;
        }

        public RangeData(@NotNull IntRange range, @NotNull Function2<? super Point, ? super Integer, Unit> action2) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            this.range = range;
            this.action = action2;
        }

        @NotNull
        public final IntRange component1() {
            return this.range;
        }

        @NotNull
        public final Function2<Point, Integer, Unit> component2() {
            return this.action;
        }

        @NotNull
        public final RangeData copy(@NotNull IntRange range, @NotNull Function2<? super Point, ? super Integer, Unit> action2) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            return new RangeData(range, action2);
        }

        public static /* synthetic */ RangeData copy$default(RangeData rangeData, IntRange intRange, Function2 function2, int n, Object object) {
            if ((n & 1) != 0) {
                intRange = rangeData.range;
            }
            if ((n & 2) != 0) {
                function2 = rangeData.action;
            }
            return rangeData.copy(intRange, function2);
        }

        @NotNull
        public String toString() {
            return "RangeData(range=" + this.range + ", action=" + this.action + ")";
        }

        public int hashCode() {
            IntRange intRange = this.range;
            Function2<Point, Integer, Unit> function2 = this.action;
            return (intRange != null ? intRange.hashCode() : 0) * 31 + (function2 != null ? function2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RangeData)) break block3;
                    RangeData rangeData = (RangeData)object;
                    if (!Intrinsics.areEqual((Object)this.range, (Object)rangeData.range) || !Intrinsics.areEqual(this.action, rangeData.action)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0015\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0016\u0010\u0012R\u001b\u0010\u0018\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0014\u001a\u0004\b\u0019\u0010\u0012\u00a8\u0006\u001b"}, d2={"Ltraining/ui/LessonMessagePane$Companion;", "", "()V", "BOLD", "Ljavax/swing/text/SimpleAttributeSet;", "CODE", "INACTIVE", "LINK", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "REGULAR", "ROBOTO", "SHORTCUT", "TASK_PARAGRAPH_STYLE", "activeTaskInset", "", "getActiveTaskInset", "()I", "activeTaskInset$delegate", "Lkotlin/Lazy;", "arc", "getArc", "arc$delegate", "indent", "getIndent", "indent$delegate", "intellij.featuresTrainer"})
    public static final class Companion {
        private final int getArc() {
            Lazy lazy = arc$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return ((Number)lazy.getValue()).intValue();
        }

        private final int getIndent() {
            Lazy lazy = indent$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return ((Number)lazy.getValue()).intValue();
        }

        private final int getActiveTaskInset() {
            Lazy lazy = activeTaskInset$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return ((Number)lazy.getValue()).intValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

