/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.RectanglePainter;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.util.Date;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.ui.GlassHighlightComponent;
import training.ui.LearningUiHighlightingManager;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ltraining/ui/GlassHighlightComponent;", "Ljavax/swing/JComponent;", "startDate", "Ljava/util/Date;", "options", "Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;", "(Ljava/util/Date;Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;)V", "previous", "", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.featuresTrainer"})
public final class GlassHighlightComponent
extends JComponent {
    private long previous;
    private final Date startDate;
    private final LearningUiHighlightingManager.HighlightingOptions options;

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D g2d = (Graphics2D)g;
        Rectangle rectangle2 = this.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2, (String)"bounds");
        Rectangle r = rectangle2;
        Color oldColor = g2d.getColor();
        long time = new Date().getTime();
        long delta = time - this.startDate.getTime();
        this.previous = time;
        paintComponent.1 $fun$cyclicNumber$1 = paintComponent.1.INSTANCE;
        double alphaCycle = (double)$fun$cyclicNumber$1.invoke(1000, delta) / (double)1000;
        Color color = ColorUtil.withAlpha((Color)Color.magenta, (double)0.8);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"ColorUtil.withAlpha(Color.magenta, 0.8)");
        Color magenta = color;
        Color color2 = ColorUtil.withAlpha((Color)Color.orange, (double)0.8);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"ColorUtil.withAlpha(Color.orange, 0.8)");
        Color orange = color2;
        Color color3 = ColorUtil.withAlpha((Color)((Color)new JBColor(Color.black, Color.white)), (double)(0.3 * alphaCycle));
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"ColorUtil.withAlpha(JBCo\u2026white), 0.3 * alphaCycle)");
        Color background = color3;
        float gradientShift = delta / (long)20;
        GradientPaint gp = new GradientPaint(gradientShift + 0.0f, gradientShift + 0.0f, magenta, gradientShift + (float)r.height, gradientShift + (float)r.height, orange, true);
        RectanglePainter.paint((Graphics2D)g2d, (int)0, (int)0, (int)r.width, (int)r.height, (int)2, (Paint)(this.options.getHighlightInside() ? background : null), (Paint)(this.options.getHighlightBorder() ? gp : null));
        g2d.setColor(oldColor);
    }

    public GlassHighlightComponent(@NotNull Date startDate, @NotNull LearningUiHighlightingManager.HighlightingOptions options) {
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.startDate = startDate;
        this.options = options;
    }
}

