/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.textBuilder;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.ResolverForDecompiler;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0004J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0016R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DeserializerForDecompilerBase;", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/ResolverForDecompiler;", "directoryPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/name/FqName;)V", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "deserializationComponents", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "getDeserializationComponents", "()Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "getDirectoryPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "packageFragmentProvider", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "getPackageFragmentProvider", "()Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "getStorageManager", "()Lorg/jetbrains/kotlin/storage/StorageManager;", "createDummyModule", "name", "", "createDummyPackageFragment", "Lorg/jetbrains/kotlin/descriptors/impl/MutablePackageFragmentDescriptor;", "fqName", "resolveTopLevelClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "kotlin.core"})
public abstract class DeserializerForDecompilerBase
implements ResolverForDecompiler {
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final ModuleDescriptorImpl moduleDescriptor;
    @NotNull
    private final PackageFragmentProvider packageFragmentProvider;
    @NotNull
    private final FqName directoryPackageFqName;

    @NotNull
    protected abstract DeserializationComponents getDeserializationComponents();

    @NotNull
    protected abstract KotlinBuiltIns getBuiltIns();

    @NotNull
    protected final StorageManager getStorageManager() {
        return this.storageManager;
    }

    @NotNull
    protected final ModuleDescriptorImpl getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @NotNull
    protected final PackageFragmentProvider getPackageFragmentProvider() {
        return this.packageFragmentProvider;
    }

    @Override
    @Nullable
    public ClassDescriptor resolveTopLevelClass(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return this.getDeserializationComponents().deserializeClass(classId);
    }

    @NotNull
    protected final MutablePackageFragmentDescriptor createDummyPackageFragment(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return new MutablePackageFragmentDescriptor((ModuleDescriptor)this.moduleDescriptor, fqName);
    }

    private final ModuleDescriptorImpl createDummyModule(String name) {
        Name name2 = Name.special((String)('<' + name + '>'));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.special(\"<$name>\")");
        return new ModuleDescriptorImpl(name2, this.storageManager, this.getBuiltIns(), null, null, null, 56, null);
    }

    @NotNull
    public final FqName getDirectoryPackageFqName() {
        return this.directoryPackageFqName;
    }

    public DeserializerForDecompilerBase(@NotNull FqName directoryPackageFqName) {
        Intrinsics.checkNotNullParameter((Object)directoryPackageFqName, (String)"directoryPackageFqName");
        this.directoryPackageFqName = directoryPackageFqName;
        StorageManager storageManager = LockBasedStorageManager.NO_LOCKS;
        Intrinsics.checkNotNullExpressionValue((Object)storageManager, (String)"LockBasedStorageManager.NO_LOCKS");
        this.storageManager = storageManager;
        this.moduleDescriptor = this.createDummyModule("module for building decompiled sources");
        this.packageFragmentProvider = new PackageFragmentProvider(this){
            final /* synthetic */ DeserializerForDecompilerBase this$0;

            @NotNull
            public List<PackageFragmentDescriptor> getPackageFragments(@NotNull FqName fqName) {
                Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
                return CollectionsKt.listOf((Object)this.this$0.createDummyPackageFragment(fqName));
            }

            @NotNull
            public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName, @NotNull Function1<? super Name, Boolean> nameFilter) {
                Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
                Intrinsics.checkNotNullParameter(nameFilter, (String)"nameFilter");
                throw (Throwable)new UnsupportedOperationException("This method is not supposed to be called.");
            }
            {
                this.this$0 = this$0;
            }
        };
        this.moduleDescriptor.initialize(this.packageFragmentProvider);
        ModuleDescriptorImpl[] moduleDescriptorImplArray = new ModuleDescriptorImpl[2];
        moduleDescriptorImplArray[0] = this.moduleDescriptor;
        ModuleDescriptorImpl moduleDescriptorImpl = this.moduleDescriptor.getBuiltIns().getBuiltInsModule();
        Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptorImpl, (String)"moduleDescriptor.builtIns.builtInsModule");
        moduleDescriptorImplArray[1] = moduleDescriptorImpl;
        this.moduleDescriptor.setDependencies(moduleDescriptorImplArray);
    }
}

