/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.surroundWith;

import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.surroundWith.KotlinSurrounderUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

public abstract class KotlinExpressionSurrounder
implements Surrounder {
    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            KotlinExpressionSurrounder.$$$reportNull$$$0(0);
        }
        if (elements.length != 1 || !(elements[0] instanceof KtExpression)) {
            return false;
        }
        KtExpression expression = (KtExpression)elements[0];
        if (expression instanceof KtCallExpression && expression.getParent() instanceof KtQualifiedExpression) {
            return false;
        }
        return this.isApplicable(expression);
    }

    protected boolean isApplicable(@NotNull KtExpression expression) {
        BindingContext context;
        KotlinType type;
        if (expression == null) {
            KotlinExpressionSurrounder.$$$reportNull$$$0(1);
        }
        if ((type = (context = ResolutionUtils.analyze((KtElement)expression, (BodyResolveMode)BodyResolveMode.PARTIAL)).getType(expression)) == null || KotlinBuiltIns.isUnit((KotlinType)type) && this.isApplicableToStatements()) {
            return false;
        }
        return this.isApplicableToStatements() || !KotlinSurrounderUtils.isUsedAsStatement(expression);
    }

    protected boolean isApplicableToStatements() {
        return true;
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) {
        if (project == null) {
            KotlinExpressionSurrounder.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            KotlinExpressionSurrounder.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            KotlinExpressionSurrounder.$$$reportNull$$$0(4);
        }
        assert (elements.length == 1) : "KotlinExpressionSurrounder should be applicable only for 1 expression: " + elements.length;
        return this.surroundExpression(project, editor, (KtExpression)elements[0]);
    }

    @Nullable
    protected abstract TextRange surroundExpression(@NotNull Project var1, @NotNull Editor var2, @NotNull KtExpression var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/core/surroundWith/KotlinExpressionSurrounder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

