/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.cache;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.SLRUMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationCache;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshot;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationState;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\r0\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0013\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0007H\u0096\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationMemoryCache;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationCache;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "memoryCache", "Lcom/intellij/util/containers/SLRUMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationState;", "getProject", "()Lcom/intellij/openapi/project/Project;", "allApplied", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "clear", "", "get", "file", "getAnyLoadedScript", "remove", "", "setApplied", "configurationSnapshot", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationSnapshot;", "setLoaded", "Companion", "kotlin.core"})
public class ScriptConfigurationMemoryCache
implements ScriptConfigurationCache {
    private final SLRUMap<VirtualFile, ScriptConfigurationState> memoryCache;
    @NotNull
    private final Project project;
    public static final int MAX_SCRIPTS_CACHED = 50;
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public synchronized ScriptConfigurationState get(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (ScriptConfigurationState)this.memoryCache.get((Object)file);
    }

    @Override
    @Nullable
    public ScriptCompilationConfigurationWrapper getAnyLoadedScript() {
        Set set = this.memoryCache.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"memoryCache.entrySet()");
        Object object = (Map.Entry)CollectionsKt.firstOrNull((Iterable)set);
        return object != null && (object = (ScriptConfigurationState)object.getValue()) != null && (object = ((ScriptConfigurationState)object).getLoaded()) != null ? ((ScriptConfigurationSnapshot)object).getConfiguration() : null;
    }

    @Override
    public synchronized void setApplied(@NotNull VirtualFile file, @NotNull ScriptConfigurationSnapshot configurationSnapshot) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configurationSnapshot, (String)"configurationSnapshot");
        ScriptConfigurationState scriptConfigurationState = (ScriptConfigurationState)this.memoryCache.get((Object)file);
        if (scriptConfigurationState == null) {
            scriptConfigurationState = new ScriptConfigurationState(null, null, 3, null);
        }
        Intrinsics.checkNotNullExpressionValue((Object)scriptConfigurationState, (String)"memoryCache[file] ?: ScriptConfigurationState()");
        ScriptConfigurationState old = scriptConfigurationState;
        this.memoryCache.put((Object)file, (Object)ScriptConfigurationState.copy$default(old, configurationSnapshot, null, 2, null));
    }

    @Override
    public boolean remove(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.memoryCache.remove((Object)file);
    }

    @Override
    public synchronized void setLoaded(@NotNull VirtualFile file, @NotNull ScriptConfigurationSnapshot configurationSnapshot) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configurationSnapshot, (String)"configurationSnapshot");
        ScriptConfigurationState scriptConfigurationState = (ScriptConfigurationState)this.memoryCache.get((Object)file);
        if (scriptConfigurationState == null) {
            scriptConfigurationState = new ScriptConfigurationState(null, null, 3, null);
        }
        Intrinsics.checkNotNullExpressionValue((Object)scriptConfigurationState, (String)"memoryCache[file] ?: ScriptConfigurationState()");
        ScriptConfigurationState old = scriptConfigurationState;
        this.memoryCache.put((Object)file, (Object)ScriptConfigurationState.copy$default(old, null, configurationSnapshot, 1, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public synchronized List<Pair<VirtualFile, ScriptCompilationConfigurationWrapper>> allApplied() {
        boolean bl = false;
        List result = new ArrayList();
        Iterator iterator = this.memoryCache.entrySet().iterator();
        while (iterator.hasNext()) {
            void file;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator.next();
            boolean bl2 = false;
            VirtualFile virtualFile = (VirtualFile)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            ScriptConfigurationState configuration2 = (ScriptConfigurationState)entry2.getValue();
            ScriptConfigurationSnapshot scriptConfigurationSnapshot = configuration2.getApplied();
            if ((scriptConfigurationSnapshot != null ? scriptConfigurationSnapshot.getConfiguration() : null) == null) continue;
            result.add(new Pair((Object)file, (Object)configuration2.getApplied().getConfiguration()));
        }
        return result;
    }

    @Override
    public synchronized void clear() {
        this.memoryCache.clear();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ScriptConfigurationMemoryCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.memoryCache = new SLRUMap(50, 50);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationMemoryCache$Companion;", "", "()V", "MAX_SCRIPTS_CACHED", "", "kotlin.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

