/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.tasks.diagnostics.internal.ProjectReportGenerator;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.logging.text.StyledTextOutputFactory;

public class ReportGenerator {
    private final ReportRenderer renderer;
    private final BuildClientMetaData buildClientMetaData;
    private final File outputFile;
    private final StyledTextOutputFactory textOutputFactory;
    private final ProjectReportGenerator projectReportGenerator;

    public ReportGenerator(ReportRenderer renderer, BuildClientMetaData buildClientMetaData, @Nullable File outputFile, StyledTextOutputFactory textOutputFactory, ProjectReportGenerator projectReportGenerator) {
        this.renderer = renderer;
        this.buildClientMetaData = buildClientMetaData;
        this.outputFile = outputFile;
        this.textOutputFactory = textOutputFactory;
        this.projectReportGenerator = projectReportGenerator;
    }

    public void generateReport(Set<Project> projects) {
        try {
            ReportRenderer renderer = this.getRenderer();
            renderer.setClientMetaData(this.getClientMetaData());
            File outputFile = this.getOutputFile();
            if (outputFile != null) {
                renderer.setOutputFile(outputFile);
            } else {
                renderer.setOutput(this.getTextOutputFactory().create(this.getClass()));
            }
            for (Project project : projects) {
                renderer.startProject(project);
                this.projectReportGenerator.generateReport(project);
                renderer.completeProject(project);
            }
            renderer.complete();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    protected ReportRenderer getRenderer() {
        return this.renderer;
    }

    protected BuildClientMetaData getClientMetaData() {
        return this.buildClientMetaData;
    }

    @Nullable
    protected File getOutputFile() {
        return this.outputFile;
    }

    protected StyledTextOutputFactory getTextOutputFactory() {
        return this.textOutputFactory;
    }
}

