/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.Record;
import ghidra.program.database.DatabaseObject;
import ghidra.program.model.address.KeyRange;
import ghidra.util.datastruct.LongObjectHashtable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class DBObjectCache<T extends DatabaseObject> {
    private LongObjectHashtable<KeyedSoftReference> hashTable;
    private ReferenceQueue<T> refQueue;
    private LinkedList<T> hardCache;
    private int hardCacheSize;
    private volatile int invalidateCount;

    public DBObjectCache(int hardCacheSize) {
        this.hardCacheSize = hardCacheSize;
        this.hashTable = new LongObjectHashtable();
        this.refQueue = new ReferenceQueue();
        this.hardCache = new LinkedList();
    }

    public synchronized T get(long key) {
        KeyedSoftReference ref = (KeyedSoftReference)this.hashTable.get(key);
        if (ref != null) {
            DatabaseObject obj = (DatabaseObject)ref.get();
            if (obj == null) {
                this.hashTable.remove(key);
            } else {
                if (obj.checkIsValid()) {
                    this.addToHardCache(obj);
                    return (T)obj;
                }
                this.hashTable.remove(key);
            }
        }
        return null;
    }

    public synchronized T get(Record objectRecord) {
        long key = objectRecord.getKey();
        KeyedSoftReference ref = (KeyedSoftReference)this.hashTable.get(key);
        if (ref != null) {
            DatabaseObject obj = (DatabaseObject)ref.get();
            if (obj == null) {
                this.hashTable.remove(key);
            } else {
                if (obj.checkIsValid(objectRecord)) {
                    this.addToHardCache(obj);
                    return (T)obj;
                }
                this.hashTable.remove(key);
            }
        }
        return null;
    }

    public int size() {
        return this.hashTable.size();
    }

    public synchronized void setHardCacheSize(int size) {
        while (this.hardCache.size() > size) {
            this.hardCache.removeLast();
        }
        this.hardCacheSize = size;
    }

    void put(T data) {
        this.processQueue();
        long key = ((DatabaseObject)data).getKey();
        this.addToHardCache(data);
        KeyedSoftReference ref = new KeyedSoftReference(this, key, data, this.refQueue);
        this.hashTable.put(key, (Object)ref);
    }

    public synchronized ArrayList<T> getCachedObjects() {
        ArrayList<DatabaseObject> list = new ArrayList<DatabaseObject>();
        this.processQueue();
        long[] keys = this.hashTable.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            KeyedSoftReference ref = (KeyedSoftReference)this.hashTable.get(keys[i]);
            DatabaseObject obj = (DatabaseObject)ref.get();
            if (obj == null) continue;
            list.add(obj);
        }
        return list;
    }

    public synchronized void delete(List<KeyRange> keyRanges) {
        this.hardCache.clear();
        this.processQueue();
        long rangesSize = this.getKeyRangesSize(keyRanges);
        if (rangesSize < 0L || rangesSize > (long)this.hashTable.size()) {
            this.deleteLargeKeyRanges(keyRanges);
        } else {
            this.deleteSmallKeyRanges(keyRanges);
        }
    }

    private void deleteSmallKeyRanges(List<KeyRange> keyRanges) {
        for (KeyRange range : keyRanges) {
            for (long key = range.minKey; key <= range.maxKey; ++key) {
                DatabaseObject obj;
                KeyedSoftReference ref = (KeyedSoftReference)this.hashTable.remove(key);
                if (ref == null || (obj = (DatabaseObject)ref.get()) == null) continue;
                obj.setDeleted();
                ref.clear();
            }
        }
    }

    private void deleteLargeKeyRanges(List<KeyRange> keyRanges) {
        long[] keys = this.hashTable.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            KeyedSoftReference ref;
            DatabaseObject obj;
            if (!this.keyRangesContain(keyRanges, keys[i]) || (obj = (DatabaseObject)(ref = (KeyedSoftReference)this.hashTable.remove(keys[i])).get()) == null) continue;
            obj.setDeleted();
            ref.clear();
        }
    }

    private long getKeyRangesSize(List<KeyRange> keyRanges) {
        long size = 0L;
        for (KeyRange range : keyRanges) {
            if ((size += range.length()) >= 0L) continue;
            return -1L;
        }
        return size;
    }

    private boolean keyRangesContain(List<KeyRange> keyRanges, long key) {
        for (KeyRange range : keyRanges) {
            if (!range.contains(key)) continue;
            return true;
        }
        return false;
    }

    public synchronized void invalidate() {
        this.hardCache.clear();
        this.processQueue();
        if (++this.invalidateCount <= 0) {
            this.invalidateCount = 1;
            long[] keys = this.hashTable.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                KeyedSoftReference ref = (KeyedSoftReference)this.hashTable.get(keys[i]);
                DatabaseObject obj = (DatabaseObject)ref.get();
                if (obj == null) continue;
                obj.setInvalid();
            }
        }
    }

    int getInvalidateCount() {
        return this.invalidateCount;
    }

    public synchronized void invalidate(long startKey, long endKey) {
        if (endKey - startKey < (long)this.hashTable.size()) {
            for (long i = startKey; i <= endKey; ++i) {
                this.invalidate(i);
            }
        } else {
            long[] keys = this.hashTable.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i] < startKey || keys[i] > endKey) continue;
                this.invalidate(keys[i]);
            }
        }
    }

    public synchronized void delete(long key) {
        this.processQueue();
        KeyedSoftReference ref = (KeyedSoftReference)this.hashTable.get(key);
        if (ref != null) {
            DatabaseObject obj = (DatabaseObject)ref.get();
            if (obj != null) {
                obj.setDeleted();
                ref.clear();
            }
            this.hashTable.remove(key);
        }
    }

    public synchronized void invalidate(long key) {
        DatabaseObject obj;
        this.processQueue();
        KeyedSoftReference ref = (KeyedSoftReference)this.hashTable.get(key);
        if (ref != null && (obj = (DatabaseObject)ref.get()) != null) {
            obj.setInvalid();
        }
    }

    private void addToHardCache(T obj) {
        this.hardCache.addLast(obj);
        if (this.hardCache.size() > this.hardCacheSize) {
            this.hardCache.removeFirst();
        }
    }

    private void processQueue() {
        KeyedSoftReference ref;
        while ((ref = (KeyedSoftReference)this.refQueue.poll()) != null) {
            long key = ref.getKey();
            KeyedSoftReference oldValue = (KeyedSoftReference)this.hashTable.remove(key);
            if (oldValue == null || oldValue == ref) continue;
            this.hashTable.put(key, (Object)oldValue);
        }
    }

    public synchronized void keyChanged(long oldKey, long newKey) {
        this.processQueue();
        KeyedSoftReference ref = (KeyedSoftReference)this.hashTable.remove(oldKey);
        if (ref != null) {
            this.hashTable.put(newKey, (Object)ref);
            DatabaseObject t = (DatabaseObject)ref.get();
            if (t != null) {
                t.setInvalid();
            }
        }
    }

    private class KeyedSoftReference
    extends WeakReference<T> {
        private long key;
        final /* synthetic */ DBObjectCache this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        KeyedSoftReference(long obj, T t, ReferenceQueue<T> referenceQueue) {
            void key;
            void queue;
            this.this$0 = (DBObjectCache)l;
            super(obj, queue);
            this.key = key;
        }

        long getKey() {
            return this.key;
        }
    }
}

