/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.app.plugin.core.analysis.ReferenceAddressPair;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.field.ProgramLocationTableColumnExtensionPoint;

public class ReferenceFromFunctionTableColumn
extends ProgramLocationTableColumnExtensionPoint<ReferenceAddressPair, String> {
    public String getColumnDisplayName(Settings settings) {
        return this.getColumnName();
    }

    public String getColumnName() {
        return "From Function";
    }

    public String getValue(ReferenceAddressPair rowObject, Settings settings, Program pgm, ServiceProvider serviceProvider) throws IllegalArgumentException {
        Function fromFunction = this.getFunction(rowObject, pgm);
        return fromFunction != null ? fromFunction.toString() : null;
    }

    @Override
    public ProgramLocation getProgramLocation(ReferenceAddressPair rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
        Address address = this.getFromAddress(rowObject);
        return new ProgramLocation(program, address);
    }

    private Address getFromAddress(ReferenceAddressPair rowObject) throws IllegalArgumentException {
        return rowObject.getSource();
    }

    private Function getFunction(ReferenceAddressPair rowObject, Program pgm) throws IllegalArgumentException {
        Address fromAddress = this.getFromAddress(rowObject);
        if (fromAddress != null) {
            return pgm.getFunctionManager().getFunctionContaining(fromAddress);
        }
        return null;
    }
}

