/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.app.services.ProgramManager;
import ghidra.app.util.importer.AutoImporter;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.PeLoader;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class ProgramCoordinator {
    private Program importProgram;
    private final Object importSemaphore = new Object();
    private boolean importTaskRunning;
    protected ProgramManager programManager;
    protected LanguageService languageService;

    public ProgramCoordinator(ProgramManager programManager, LanguageService languageService) {
        this.programManager = programManager;
        this.languageService = languageService;
    }

    public synchronized Program getProgram(String path, Address address) {
        Program program = this.findProgramInProgramManager(path, address);
        if (program == null) {
            program = this.findProgramInProject(path);
        }
        if (program == null) {
            program = this.importProgram(path);
        }
        return program;
    }

    protected Program findProgramInProgramManager(String path, Address address) {
        Program[] allOpenPrograms;
        for (Program program : allOpenPrograms = this.programManager.getAllOpenPrograms()) {
            if (!program.getExecutablePath().equalsIgnoreCase(path) || !program.getMemory().contains(address)) continue;
            return program;
        }
        return null;
    }

    protected abstract Program findProgramInProject(String var1);

    protected Program findProgramInFolder(DomainFolder folder, String path) {
        DomainFile[] files;
        DomainFolder[] subFolders;
        for (DomainFolder subFolder : subFolders = folder.getFolders()) {
            Program p = this.findProgramInFolder(subFolder, path);
            if (p == null) continue;
            return p;
        }
        for (DomainFile file : files = folder.getFiles()) {
            Map metadata = file.getMetadata();
            String filePath = (String)metadata.get("Executable Location");
            if (filePath == null || !filePath.equalsIgnoreCase(path)) continue;
            return this.programManager.openProgram(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Program importProgram(String executablePath) {
        this.importTaskRunning = false;
        this.importProgram = null;
        TaskLauncher.launch((Task)new ImportTask(executablePath));
        try {
            int i = 0;
            while (!this.importTaskRunning && ++i < 50) {
                Thread.sleep(100L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this.importSemaphore;
        synchronized (object) {
            return this.importProgram;
        }
    }

    private DomainFolder getFolder(String executablePath) {
        StringTokenizer tokenizer = new StringTokenizer(executablePath, ":/\\");
        Project project = AppInfo.getActiveProject();
        ProjectData projectData = project.getProjectData();
        DomainFolder folder = projectData.getRootFolder();
        folder = this.createOrGetFolder(folder, this.getPrivateRoot());
        while (tokenizer.hasMoreTokens()) {
            String pathElement = tokenizer.nextToken();
            folder = this.createOrGetFolder(folder, pathElement);
        }
        return folder;
    }

    private DomainFolder createOrGetFolder(DomainFolder parent, String folderName) {
        DomainFolder folder = parent.getFolder(folderName);
        if (folder == null) {
            try {
                folder = parent.createFolder(folderName);
            }
            catch (Exception e) {
                folder = parent;
            }
        }
        return folder;
    }

    protected abstract String getPrivateRoot();

    private class ImportTask
    extends Task {
        private String executablePath;

        ImportTask(String executablePath) {
            super("Importing Program", true, false, true);
            this.executablePath = executablePath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TaskMonitor monitor) {
            ProgramCoordinator.this.importTaskRunning = true;
            Object object = ProgramCoordinator.this.importSemaphore;
            synchronized (object) {
                File file = new File(this.executablePath);
                ImportTask consumer = this;
                MessageLog messageLog = new MessageLog();
                DomainFolder folder = ProgramCoordinator.this.getFolder(file.getParent());
                Class<PeLoader> loaderClass = PeLoader.class;
                try {
                    Language language = ProgramCoordinator.this.languageService.getDefaultLanguage(Processor.findOrPossiblyCreateProcessor((String)"x86"));
                    CompilerSpec compilerSpec = language.getCompilerSpecByID(new CompilerSpecID("windows"));
                    ProgramCoordinator.this.importProgram = AutoImporter.importByUsingSpecificLoaderClassAndLcs(file, folder, loaderClass, null, language, compilerSpec, (Object)consumer, messageLog, monitor);
                    ProgramCoordinator.this.programManager.openProgram(ProgramCoordinator.this.importProgram);
                    ProgramCoordinator.this.importProgram.release((Object)this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    ProgramCoordinator.this.importSemaphore.notify();
                }
            }
        }
    }
}

