/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.stackeditor;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;

public class StackPieceDataType
extends DataTypeImpl {
    private final Variable variable;

    StackPieceDataType(Variable var, DataTypeManager dataMgr) {
        super(CategoryPath.ROOT, StackPieceDataType.getPieceName(var), dataMgr);
        this.variable = var;
    }

    private static String getPieceName(Variable var) {
        VariableStorage storage = var.getVariableStorage();
        Varnode stackVarnode = storage.getLastVarnode();
        int pieceLen = stackVarnode.getSize();
        return var.getDataType().getName() + ":" + pieceLen + " (piece)";
    }

    public boolean isDynamicallySized() {
        return false;
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        throw new IllegalArgumentException("May not be cloned with new DataTypeManager");
    }

    public DataType copy(DataTypeManager dtm) {
        throw new UnsupportedOperationException();
    }

    public void setCategoryPath(CategoryPath path) throws DuplicateNameException {
        throw new UnsupportedOperationException();
    }

    public void setName(String name) throws InvalidNameException {
        throw new UnsupportedOperationException();
    }

    public void setNameAndCategory(CategoryPath path, String name) throws InvalidNameException, DuplicateNameException {
        throw new UnsupportedOperationException();
    }

    public String getMnemonic(Settings settings) {
        DataType dt = this.variable.getDataType();
        return dt.getMnemonic(settings) + ":" + this.getLength();
    }

    public int getLength() {
        VariableStorage storage = this.variable.getVariableStorage();
        Varnode stackVarnode = storage.getLastVarnode();
        return stackVarnode.getSize();
    }

    public String getDescription() {
        return null;
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    public boolean isEquivalent(DataType dt) {
        return false;
    }

    public void dataTypeSizeChanged(DataType dt) {
    }

    public void dataTypeDeleted(DataType dt) {
    }

    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
    }

    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    public boolean dependsOn(DataType dt) {
        return false;
    }
}

