/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.fallthrough;

import ghidra.app.cmd.refs.ClearFallThroughCmd;
import ghidra.app.cmd.refs.SetFallThroughCmd;
import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class FallThroughModel
implements ChangeListener {
    private PluginTool tool;
    private Program program;
    private Address currentAddr;
    private Address currentFallthroughAddr;
    private Address defaultFallthroughAddr;
    private ChangeListener listener;
    private boolean isDefault;
    private boolean isUserDefined;
    private String message = "";
    private boolean executingCommand;
    private BrowserCodeUnitFormat cuFormat;

    FallThroughModel(PluginTool tool, Program program, Address address) {
        this.program = program;
        this.tool = tool;
        this.listener = this;
        this.cuFormat = new BrowserCodeUnitFormat((ServiceProvider)tool);
        this.setHomeAddress(address);
    }

    void setChangeListener(ChangeListener listener) {
        this.listener = listener;
    }

    void setHomeAddress(Address address) {
        Instruction inst = this.program.getListing().getInstructionAt(address);
        if (inst == null) {
            return;
        }
        this.currentAddr = inst.getMinAddress();
        this.currentFallthroughAddr = inst.getFallThrough();
        this.defaultFallthroughAddr = inst.getDefaultFallThrough();
        this.isUserDefined = inst.isFallThroughOverridden();
        this.isDefault = !this.isUserDefined;
        this.listener.stateChanged(null);
    }

    Address getAddress() {
        if (this.currentAddr != null && this.program.getListing().getInstructionContaining(this.currentAddr) == null) {
            this.currentAddr = null;
        }
        return this.currentAddr;
    }

    Address getCurrentFallthrough() {
        return this.currentFallthroughAddr;
    }

    void setCurrentFallthrough(Address addr) {
        if (this.isUserDefined && !this.executingCommand) {
            this.currentFallthroughAddr = addr;
            this.listener.stateChanged(null);
        }
    }

    void defaultSelected() {
        this.isDefault = true;
        this.isUserDefined = false;
        this.currentFallthroughAddr = this.defaultFallthroughAddr;
        this.listener.stateChanged(null);
    }

    void userSelected() {
        this.isDefault = false;
        this.isUserDefined = true;
        this.currentFallthroughAddr = null;
        this.listener.stateChanged(null);
    }

    boolean isDefaultFallthrough() {
        return this.isDefault;
    }

    boolean isUserDefinedFallthrough() {
        return this.isUserDefined;
    }

    boolean allowAddressEdits() {
        return this.isUserDefined;
    }

    boolean isValidInput() {
        return true;
    }

    String getMessage() {
        String msg = this.message;
        this.message = "";
        return msg;
    }

    String getInstructionRepresentation() {
        Instruction inst = this.program.getListing().getInstructionContaining(this.currentAddr);
        return this.cuFormat.getRepresentationString((CodeUnit)inst);
    }

    boolean execute() {
        this.message = "";
        Instruction inst = this.program.getListing().getInstructionContaining(this.currentAddr);
        Address ftAddr = inst.getFallThrough();
        if (ftAddr == null || !inst.getFallThrough().equals((Object)this.currentFallthroughAddr)) {
            this.executingCommand = true;
            SetFallThroughCmd cmd = new SetFallThroughCmd(inst.getMinAddress(), this.currentFallthroughAddr);
            this.tool.execute((Command)cmd, (DomainObject)this.program);
            this.message = "Updated Fallthrough address";
            this.executingCommand = false;
            if (this.defaultFallthroughAddr != null && this.defaultFallthroughAddr.equals((Object)this.currentFallthroughAddr)) {
                this.isDefault = true;
                this.isUserDefined = false;
            }
        } else {
            this.message = "No changes were made";
        }
        this.listener.stateChanged(null);
        return true;
    }

    void autoOverride(AddressSetView view) {
        CompoundCmd cmd = new CompoundCmd("Auto-Override");
        AddressRangeIterator iter = view.getAddressRanges();
        while (iter.hasNext()) {
            this.override((AddressRange)iter.next(), cmd);
        }
        if (cmd.size() > 0 && !this.tool.execute((Command)cmd, (DomainObject)this.program)) {
            this.tool.setStatusInfo(cmd.getStatusMsg());
        }
    }

    void clearOverride(AddressSetView view) {
        CompoundCmd cmd = new CompoundCmd("Clear FallThroughs");
        InstructionIterator it = this.program.getListing().getInstructions(view, true);
        while (it.hasNext()) {
            Instruction inst = it.next();
            if (!inst.isFallThroughOverridden()) continue;
            cmd.add((Command)new ClearFallThroughCmd(inst.getMinAddress()));
        }
        if (cmd.size() > 0) {
            this.tool.execute((Command)cmd, (DomainObject)this.program);
        }
    }

    void dispose() {
        this.program = null;
        this.tool = null;
        this.listener = null;
    }

    Program getProgram() {
        return this.program;
    }

    private void override(AddressRange range, CompoundCmd cmd) {
        Address min = range.getMinAddress();
        Address max = range.getMaxAddress();
        Listing listing = this.program.getListing();
        Instruction inst = listing.getInstructionAt(min);
        if (inst == null) {
            inst = listing.getInstructionAfter(min);
        }
        while (inst != null && inst.getMinAddress().compareTo((Object)max) <= 0) {
            Data data = listing.getDataAfter(inst.getMinAddress());
            if (data == null) {
                return;
            }
            inst = listing.getInstructionBefore(data.getMinAddress());
            if (inst.getFallThrough() != null && range.contains(inst.getMinAddress())) {
                this.setFallThrough(inst.getMinAddress(), cmd);
            }
            inst = listing.getInstructionAfter(data.getMinAddress());
        }
    }

    private void setFallThrough(Address addr, CompoundCmd cmd) {
        Instruction inst = this.program.getListing().getInstructionAfter(addr);
        if (inst != null) {
            cmd.add((Command)new SetFallThroughCmd(addr, inst.getMinAddress()));
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }
}

