/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.AIFFDataType;
import ghidra.program.model.data.AUDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.GifDataType;
import ghidra.program.model.data.JPEGDataType;
import ghidra.program.model.data.PngDataType;
import ghidra.program.model.data.WAVEDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EmbeddedMediaAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Embedded Media";
    private static final String DESCRIPTION = "Finds and tries to apply embedded media data types (ie png, gif, jpeg, wav) in current program.";
    private static final String OPTION_NAME_CREATE_BOOKMARKS = "Create Analysis Bookmarks";
    private static final String OPTION_DESCRIPTION_CREATE_BOOKMARKS = "If checked, an analysis bookmark will be created at each location where embedded media data is identified.";
    private static final boolean OPTION_DEFAULT_CREATE_BOOKMARKS_ENABLED = true;
    private boolean createBookmarksEnabled = true;

    public EmbeddedMediaAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.BLOCK_ANALYSIS);
        this.setSupportsOneTimeAnalysis();
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Memory memory = program.getMemory();
        AddressSetView initializedAddressSet = memory.getLoadedAndInitializedAddressSet();
        AddressSet initialedSearchSet = set.intersect(initializedAddressSet);
        List<Object> foundMedia = new ArrayList();
        foundMedia = this.scanForMedia(program, (DataType)new GifDataType(), "GIF 87", GifDataType.MAGIC_87, GifDataType.GIFMASK, (AddressSetView)initialedSearchSet, memory, monitor);
        foundMedia.addAll(this.scanForMedia(program, (DataType)new GifDataType(), "GIF 89", GifDataType.MAGIC_89, GifDataType.GIFMASK, (AddressSetView)initialedSearchSet, memory, monitor));
        foundMedia.addAll(this.scanForMedia(program, (DataType)new PngDataType(), "PNG", PngDataType.MAGIC, PngDataType.MASK, (AddressSetView)initialedSearchSet, memory, monitor));
        foundMedia.addAll(this.scanForMedia(program, (DataType)new JPEGDataType(), "JPEG", JPEGDataType.MAGIC, JPEGDataType.MAGIC_MASK, (AddressSetView)initialedSearchSet, memory, monitor));
        foundMedia.addAll(this.scanForMedia(program, (DataType)new WAVEDataType(), "WAVE", WAVEDataType.MAGIC, WAVEDataType.MAGIC_MASK, (AddressSetView)initialedSearchSet, memory, monitor));
        foundMedia.addAll(this.scanForMedia(program, (DataType)new AUDataType(), "AU", AUDataType.MAGIC, AUDataType.MAGIC_MASK, (AddressSetView)initialedSearchSet, memory, monitor));
        foundMedia.addAll(this.scanForMedia(program, (DataType)new AIFFDataType(), "AIFF", AIFFDataType.MAGIC, AIFFDataType.MAGIC_MASK, (AddressSetView)initialedSearchSet, memory, monitor));
        return true;
    }

    private List<Address> scanForMedia(Program program, DataType dt, String mediaName, byte[] mediaBytes, byte[] mask, AddressSetView addresses, Memory memory, TaskMonitor monitor) {
        monitor.setMessage("Scanning for " + mediaName + " Embedded Media");
        monitor.initialize(addresses.getNumAddresses());
        ArrayList<Address> foundMediaAddresses = new ArrayList<Address>();
        Iterator iterator = addresses.iterator();
        block4: while (iterator.hasNext()) {
            if (monitor.isCancelled()) {
                return foundMediaAddresses;
            }
            AddressRange range = (AddressRange)iterator.next();
            Address start = range.getMinAddress();
            Address end = range.getMaxAddress();
            Address found = memory.findBytes(start, end, mediaBytes, mask, true, monitor);
            while (found != null && !monitor.isCancelled()) {
                Data data = program.getListing().getDefinedDataAt(found);
                int skipLen = 1;
                if (data == null) {
                    try {
                        CreateDataCmd cmd = new CreateDataCmd(found, dt);
                        if (cmd.applyTo((DomainObject)program)) {
                            if (this.createBookmarksEnabled) {
                                program.getBookmarkManager().setBookmark(found, "Analysis", NAME, "Found " + mediaName + " Embedded Media");
                            }
                            foundMediaAddresses.add(found);
                            skipLen = program.getListing().getDataAt(found).getLength();
                        }
                    }
                    catch (Exception cmd) {
                        // empty catch block
                    }
                }
                try {
                    start = found.add((long)skipLen);
                    found = memory.findBytes(start, end, mediaBytes, mask, true, monitor);
                }
                catch (AddressOutOfBoundsException e) {
                    continue block4;
                }
            }
        }
        return foundMediaAddresses;
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_CREATE_BOOKMARKS, (Object)this.createBookmarksEnabled, null, OPTION_DESCRIPTION_CREATE_BOOKMARKS);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.createBookmarksEnabled = options.getBoolean(OPTION_NAME_CREATE_BOOKMARKS, this.createBookmarksEnabled);
    }
}

