/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.prop;

import ghidra.util.prop.PropertyPage;
import ghidra.util.prop.PropertySet;
import ghidra.util.prop.PropertyVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ObjectPropertySet
extends PropertySet {
    private static final long serialVersionUID = 1L;

    public ObjectPropertySet(String name) {
        super(name, null);
    }

    @Override
    public int getDataSize() {
        return 20;
    }

    public void putObject(long index, Object value) {
        PropertyPage page = this.getOrCreatePage(this.getPageID(index));
        int n = page.getSize();
        page.addObject(this.getPageOffset(index), value);
        this.numProperties += page.getSize() - n;
    }

    public Object getObject(long index) {
        PropertyPage page = this.getPage(this.getPageID(index));
        if (page != null) {
            return page.getObject(this.getPageOffset(index));
        }
        return null;
    }

    @Override
    protected void moveIndex(long from, long to) {
        Object value = this.getObject(from);
        this.remove(from);
        this.putObject(to, value);
    }

    @Override
    protected void saveProperty(ObjectOutputStream oos, long index) throws IOException {
        oos.writeObject(this.getObject(index));
    }

    @Override
    protected void restoreProperty(ObjectInputStream ois, long index) throws IOException, ClassNotFoundException {
        this.putObject(index, ois.readObject());
    }

    @Override
    public void applyValue(PropertyVisitor visitor, long addr) {
        Object obj = this.getObject(addr);
        if (obj != null) {
            visitor.visit(obj);
        }
    }
}

