/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.parallel;

import generic.concurrent.QCallback;
import generic.concurrent.QResult;
import ghidra.app.decompiler.parallel.ChunkingParallelDecompiler;
import ghidra.app.util.DecompilerConcurrentQ;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ParallelDecompiler {
    static final String THREAD_POOL_NAME = "Parallel Decompiler";

    public static <R> List<R> decompileFunctions(QCallback<Function, R> callback, Program program, AddressSetView addresses, TaskMonitor monitor) throws InterruptedException, Exception {
        int functionCount = program.getFunctionManager().getFunctionCount();
        Listing listing = program.getListing();
        FunctionIterator iterator = listing.getFunctions(addresses, true);
        List<R> results = ParallelDecompiler.decompileFunctions(callback, program, (Iterator<Function>)iterator, functionCount, monitor);
        return results;
    }

    public static <R> List<R> decompileFunctions(QCallback<Function, R> callback, Program program, Collection<Function> functions, TaskMonitor monitor) throws InterruptedException, Exception {
        List<R> results = ParallelDecompiler.decompileFunctions(callback, program, functions.iterator(), functions.size(), monitor);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R> List<R> decompileFunctions(QCallback<Function, R> callback, Program program, Iterator<Function> functions, int count, TaskMonitor monitor) throws InterruptedException, Exception {
        DecompilerConcurrentQ<Function, R> queue = new DecompilerConcurrentQ<Function, R>(callback, THREAD_POOL_NAME, monitor);
        monitor.initialize((long)count);
        queue.addAll(functions);
        Collection<QResult<Function, R>> qResults = null;
        try {
            qResults = queue.waitForResults();
        }
        finally {
            queue.dispose();
        }
        ArrayList<Object> results = new ArrayList<Object>();
        for (QResult<Function, R> qResult : qResults) {
            results.add(qResult.getResult());
        }
        return results;
    }

    public static <R> ChunkingParallelDecompiler<R> createChunkingParallelDecopmiler(QCallback<Function, R> callback, TaskMonitor monitor) {
        return new ChunkingParallelDecompiler<R>(callback, monitor);
    }

    private ParallelDecompiler() {
    }
}

