/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.ComponentProvider;
import docking.DockingKeyBindingAction;
import docking.DockingTool;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MultipleKeyAction;
import docking.action.ReservedKeyBindingAction;
import ghidra.util.ReservedKeyBindings;
import ghidra.util.exception.AssertException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class KeyBindingsManager
implements PropertyChangeListener {
    private Map<DockingActionIf, ComponentProvider> actionToProviderMap;
    private Map<KeyStroke, DockingKeyBindingAction> dockingKeyMap;
    private DockingTool tool;

    public KeyBindingsManager(DockingTool tool) {
        this.tool = tool;
        this.dockingKeyMap = new HashMap<KeyStroke, DockingKeyBindingAction>();
        this.actionToProviderMap = new HashMap<DockingActionIf, ComponentProvider>();
    }

    public void addAction(ComponentProvider optionalProvider, DockingActionIf action) {
        KeyStroke keyBinding;
        action.addPropertyChangeListener(this);
        if (optionalProvider != null) {
            this.actionToProviderMap.put(action, optionalProvider);
        }
        if ((keyBinding = action.getKeyBinding()) != null) {
            this.addKeyBinding(optionalProvider, action, keyBinding);
        }
    }

    public void addReservedAction(DockingActionIf action) {
        KeyStroke keyBinding = action.getKeyBinding();
        this.addReservedKeyBinding(action, keyBinding);
    }

    public void addReservedAction(DockingActionIf action, KeyStroke ks) {
        this.addReservedKeyBinding(action, ks);
    }

    public void removeAction(DockingActionIf action) {
        action.removePropertyChangeListener(this);
        this.actionToProviderMap.remove(action);
        this.removeKeyBinding(action.getKeyBinding(), action);
    }

    private void addKeyBinding(ComponentProvider provider, DockingActionIf action, KeyStroke keyStroke) {
        if (ReservedKeyBindings.isReservedKeystroke(keyStroke)) {
            throw new AssertException("Cannot assign action to a reserved keystroke.  Action: " + action.getName() + " - Keystroke: " + keyStroke);
        }
        DockingKeyBindingAction existingAction = this.dockingKeyMap.get(keyStroke);
        if (existingAction == null) {
            this.dockingKeyMap.put(keyStroke, new MultipleKeyAction(this.tool, provider, action, keyStroke));
            return;
        }
        if (!(existingAction instanceof MultipleKeyAction)) {
            return;
        }
        MultipleKeyAction multipleKeyction = (MultipleKeyAction)existingAction;
        multipleKeyction.addAction(provider, action);
    }

    private void addReservedKeyBinding(DockingActionIf action, KeyStroke keyStroke) {
        DockingKeyBindingAction existingAction = this.dockingKeyMap.get(keyStroke);
        if (existingAction != null) {
            throw new AssertException("Attempting to add more than one reserved action to a given keystroke: " + keyStroke);
        }
        KeyBindingData binding = KeyBindingData.createReservedKeyBindingData(keyStroke);
        action.setKeyBindingData(binding);
        this.dockingKeyMap.put(keyStroke, new ReservedKeyBindingAction(this.tool, action, keyStroke));
    }

    private void removeKeyBinding(KeyStroke keyStroke, DockingActionIf action) {
        if (keyStroke == null) {
            return;
        }
        if (ReservedKeyBindings.isReservedKeystroke(keyStroke)) {
            return;
        }
        DockingKeyBindingAction existingAction = this.dockingKeyMap.get(keyStroke);
        if (existingAction == null) {
            return;
        }
        MultipleKeyAction mkAction = (MultipleKeyAction)existingAction;
        mkAction.removeAction(action);
        if (mkAction.isEmpty()) {
            this.dockingKeyMap.remove(keyStroke);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        KeyStroke ks;
        KeyBindingData newKeyData;
        KeyStroke ks2;
        String name = evt.getPropertyName();
        DockingActionIf action = (DockingActionIf)evt.getSource();
        if (!name.equals("KeyBindings")) {
            return;
        }
        KeyBindingData keyData = (KeyBindingData)evt.getOldValue();
        if (keyData != null && (ks2 = keyData.getKeyBinding()) != null) {
            this.removeKeyBinding(ks2, action);
        }
        if ((newKeyData = (KeyBindingData)evt.getNewValue()) != null && (ks = newKeyData.getKeyBinding()) != null) {
            this.addKeyBinding(this.actionToProviderMap.get(action), action, ks);
        }
    }

    public Action getDockingKeyAction(KeyStroke keyStroke) {
        return this.dockingKeyMap.get(keyStroke);
    }

    public void dispose() {
        this.dockingKeyMap.clear();
        this.actionToProviderMap.clear();
    }
}

