/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Format.InstructionWithJumboReference;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction52c
extends InstructionWithJumboReference
implements TwoRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private short regA;
    private short regB;

    public Instruction52c(Opcode opcode, int regA, int regB, Item referencedItem) {
        super(opcode, referencedItem);
        if (regA >= 65536) {
            throw new RuntimeException("The register number must be less than v65536");
        }
        if (regB >= 65536) {
            throw new RuntimeException("The register number must be less than v65536");
        }
        this.regA = (short)regA;
        this.regB = (short)regB;
    }

    private Instruction52c(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
        super(dexFile, opcode, buffer, bufferIndex);
        this.regA = (short)NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 6);
        this.regB = (short)NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 8);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(255);
        out.writeByte(this.opcode.value);
        out.writeInt(this.getReferencedItem().getIndex());
        out.writeShort(this.getRegisterA());
        out.writeShort(this.getRegisterB());
    }

    @Override
    public Format getFormat() {
        return Format.Format52c;
    }

    @Override
    public int getRegisterA() {
        return this.regA & 0xFFFF;
    }

    @Override
    public int getRegisterB() {
        return this.regB & 0xFFFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction52c(dexFile, opcode, buffer, bufferIndex);
        }
    }
}

