/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfscommon;

import java.io.PrintStream;
import java.util.Date;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfs.CdrDirRec;
import org.catacombae.hfsexplorer.types.hfs.HFSDate;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogAttributes;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusBSDInfo;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogFolder;

public abstract class CommonHFSCatalogFolder
implements CommonHFSCatalogAttributes,
PrintableStruct,
StructElements {
    public abstract CommonHFSCatalogNodeID getFolderID();

    public static CommonHFSCatalogFolder create(HFSPlusCatalogFolder data) {
        return new HFSPlusImplementation(data);
    }

    public static CommonHFSCatalogFolder create(CdrDirRec data) {
        return new HFSImplementation(data);
    }

    public abstract long getValence();

    public abstract int length();

    public abstract byte[] getBytes();

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + CommonHFSCatalogFolder.class.getSimpleName() + ":");
        this.printFields(ps, prefix + " ");
    }

    public static class HFSImplementation
    extends CommonHFSCatalogFolder {
        private CdrDirRec data;

        public HFSImplementation(CdrDirRec data) {
            this.data = data;
        }

        public CommonHFSCatalogNodeID getFolderID() {
            return CommonHFSCatalogNodeID.create(this.data.getDirDirID());
        }

        public long getValence() {
            return Util.unsign((short)this.data.getDirVal());
        }

        public int length() {
            HFSImplementation hFSImplementation = this;
            return hFSImplementation.data.length();
        }

        public byte[] getBytes() {
            return this.data.getBytes();
        }

        public short getRecordType() {
            return this.data.getCdrType();
        }

        public short getFlags() {
            return this.data.getDirFlags();
        }

        public int getCreateDate() {
            return this.data.getDirCrDat();
        }

        public int getContentModDate() {
            return this.data.getDirMdDat();
        }

        public int getAttributeModDate() {
            return this.data.getDirMdDat();
        }

        public int getAccessDate() {
            return this.data.getDirMdDat();
        }

        public int getBackupDate() {
            return this.data.getDirBkDat();
        }

        public Date getCreateDateAsDate() {
            return HFSDate.localTimestampToDate(this.getCreateDate());
        }

        public Date getContentModDateAsDate() {
            return HFSDate.localTimestampToDate(this.getContentModDate());
        }

        public Date getAttributeModDateAsDate() {
            return HFSDate.localTimestampToDate(this.getAttributeModDate());
        }

        public Date getAccessDateAsDate() {
            return HFSDate.localTimestampToDate(this.getAccessDate());
        }

        public Date getBackupDateAsDate() {
            return HFSDate.localTimestampToDate(this.getBackupDate());
        }

        public void printFields(PrintStream ps, String prefix) {
            ps.println(prefix + "data:");
            this.data.print(ps, prefix + " ");
        }

        public Dictionary getStructElements() {
            return this.data.getStructElements();
        }

        public boolean hasPermissions() {
            return false;
        }

        public HFSPlusBSDInfo getPermissions() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public boolean hasAccessDate() {
            return false;
        }

        public boolean hasBackupDate() {
            return true;
        }

        public boolean hasCreateDate() {
            return true;
        }

        public boolean hasContentModDate() {
            return true;
        }

        public boolean hasAttributeModDate() {
            return false;
        }
    }

    public static class HFSPlusImplementation
    extends CommonHFSCatalogFolder {
        private HFSPlusCatalogFolder data;

        public HFSPlusImplementation(HFSPlusCatalogFolder data) {
            this.data = data;
        }

        public HFSPlusCatalogFolder getUnderlying() {
            return this.data;
        }

        public CommonHFSCatalogNodeID getFolderID() {
            return CommonHFSCatalogNodeID.create(this.data.getFolderID());
        }

        public long getValence() {
            return Util.unsign((int)this.data.getValence());
        }

        public int length() {
            HFSPlusImplementation hFSPlusImplementation = this;
            return hFSPlusImplementation.data.length();
        }

        public byte[] getBytes() {
            return this.data.getBytes();
        }

        public short getRecordType() {
            return this.data.getRecordType();
        }

        public short getFlags() {
            return this.data.getFlags();
        }

        public int getCreateDate() {
            return this.data.getCreateDate();
        }

        public int getContentModDate() {
            return this.data.getContentModDate();
        }

        public int getAttributeModDate() {
            return this.data.getAttributeModDate();
        }

        public int getAccessDate() {
            return this.data.getAccessDate();
        }

        public int getBackupDate() {
            return this.data.getBackupDate();
        }

        public Date getCreateDateAsDate() {
            return this.data.getCreateDateAsDate();
        }

        public Date getContentModDateAsDate() {
            return this.data.getContentModDateAsDate();
        }

        public Date getAttributeModDateAsDate() {
            return this.data.getAttributeModDateAsDate();
        }

        public Date getAccessDateAsDate() {
            return this.data.getAccessDateAsDate();
        }

        public Date getBackupDateAsDate() {
            return this.data.getBackupDateAsDate();
        }

        public void printFields(PrintStream ps, String prefix) {
            ps.println(prefix + "data:");
            this.data.print(ps, prefix + " ");
        }

        public Dictionary getStructElements() {
            return this.data.getStructElements();
        }

        public boolean hasPermissions() {
            return true;
        }

        public HFSPlusBSDInfo getPermissions() {
            return this.data.getPermissions();
        }

        public boolean hasCreateDate() {
            return true;
        }

        public boolean hasContentModDate() {
            return true;
        }

        public boolean hasAttributeModDate() {
            return true;
        }

        public boolean hasAccessDate() {
            return true;
        }

        public boolean hasBackupDate() {
            return true;
        }
    }
}

