/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.DateFormat;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusForkData;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusVolumeHeader;
import org.jdesktop.layout.GroupLayout;

public class HFSPlusVolumeInfoPanel
extends JPanel {
    private final DateFormat dti = DateFormat.getDateTimeInstance(3, 3);
    private JTextField allocationFileBasicExtentCountField;
    private JLabel allocationFileBasicExtentCountLabel;
    private JTextField allocationFileClumpSizeField;
    private JLabel allocationFileClumpSizeLabel;
    private JTextField allocationFileLogicalSizeField;
    private JLabel allocationFileLogicalSizeLabel;
    private JLabel allocationFileSectionLabel;
    private JTextField allocationFileTotalBlocksField;
    private JLabel allocationFileTotalBlocksLabel;
    private JTextField attributesFileBasicExtentCountField;
    private JLabel attributesFileBasicExtentCountLabel;
    private JTextField attributesFileClumpSizeField;
    private JLabel attributesFileClumpSizeLabel;
    private JTextField attributesFileLogicalSizeField;
    private JLabel attributesFileLogicalSizeLabel;
    private JLabel attributesFileSectionLabel;
    private JTextField attributesFileTotalBlocksField;
    private JLabel attributesFileTotalBlocksLabel;
    private JLabel attributesSectionLabel;
    private JTextField backupDateField;
    private JLabel backupDateLabel;
    private JTextField blockSizeField;
    private JLabel blockSizeLabel;
    private JTextField catalogFileBasicExtentCountField;
    private JLabel catalogFileBasicExtentCountLabel;
    private JTextField catalogFileClumpSizeField;
    private JLabel catalogFileClumpSizeLabel;
    private JTextField catalogFileLogicalSizeField;
    private JLabel catalogFileLogicalSizeLabel;
    private JLabel catalogFileSectionLabel;
    private JTextField catalogFileTotalBlocksField;
    private JLabel catalogFileTotalBlocksLabel;
    private JTextField checkedDateField;
    private JLabel checkedDateLabel;
    private JTextField createDateField;
    private JLabel createDateLabel;
    private JTextField dataClumpSizeField;
    private JLabel dataClumpSizeLabel;
    private JTextField encodingsBitmapField;
    private JLabel encodingsBitmapLabel;
    private JTextField extentsFileBasicExtentCountField;
    private JLabel extentsFileBasicExtentCountLabel;
    private JTextField extentsFileClumpSizeField;
    private JLabel extentsFileClumpSizeLabel;
    private JTextField extentsFileLogicalSizeField;
    private JLabel extentsFileLogicalSizeLabel;
    private JLabel extentsFileSectionLabel;
    private JTextField extentsFileTotalBlocksField;
    private JLabel extentsFileTotalBlocksLabel;
    private JTextField fileCountField;
    private JLabel fileCountLabel;
    private JTextField finderInfo1Field;
    private JLabel finderInfo1Label;
    private JTextField finderInfo2Field;
    private JLabel finderInfo2Label;
    private JTextField finderInfo3Field;
    private JLabel finderInfo3Label;
    private JTextField finderInfo4Field;
    private JLabel finderInfo4Label;
    private JTextField finderInfo5Field;
    private JLabel finderInfo5Label;
    private JTextField finderInfo6Field;
    private JLabel finderInfo6Label;
    private JTextField finderInfo78Field;
    private JLabel finderInfo78Label;
    private JLabel finderInfoSectionLabel;
    private JTextField folderCountField;
    private JLabel folderCountLabel;
    private JTextField freeBlocksField;
    private JLabel freeBlocksLabel;
    private JCheckBox hardwareLockBox;
    private JLabel hardwareLockLabel;
    private JCheckBox idsReusedBox;
    private JLabel idsReusedLabel;
    private JTextField journalInfoBlockField;
    private JLabel journalInfoBlockLabel;
    private JCheckBox journaledBox;
    private JLabel journaledLabel;
    private JTextField lastMountedVersionField;
    private JLabel lastMountedVersionLabel;
    private JTextField modifyDateField;
    private JLabel modifyDateLabel;
    private JTextField nextAllocationField;
    private JLabel nextAllocationLabel;
    private JTextField nextCatalogIDField;
    private JLabel nextCatalogIDLabel;
    private JCheckBox noCacheBox;
    private JLabel noCacheLabel;
    private JTextField rsrcClumpSizeField;
    private JLabel rsrcClumpSizeLabel;
    private JTextField signatureField;
    private JLabel signatureLabel;
    private JCheckBox softwareLockBox;
    private JLabel softwareLockLabel;
    private JCheckBox sparedBlocksBox;
    private JLabel sparedBlocksLabel;
    private JTextField startupFileBasicExtentCountField;
    private JLabel startupFileBasicExtentCountLabel;
    private JTextField startupFileClumpSizeField;
    private JLabel startupFileClumpSizeLabel;
    private JTextField startupFileLogicalSizeField;
    private JLabel startupFileLogicalSizeLabel;
    private JLabel startupFileSectionLabel;
    private JTextField startupFileTotalBlocksField;
    private JLabel startupFileTotalBlocksLabel;
    private JTextField totalBlocksField;
    private JLabel totalBlocksLabel;
    private JTextField versionField;
    private JLabel versionLabel;
    private JCheckBox volumeInconsistentBox;
    private JLabel volumeInconsistentLabel;
    private JCheckBox volumeUnmountedBox;
    private JLabel volumeUnmountedLabel;
    private JTextField writeCountField;
    private JLabel writeCountLabel;

    public HFSPlusVolumeInfoPanel(HFSPlusVolumeHeader vh) {
        this.initComponents();
        this.setFields(vh);
    }

    public void setFields(HFSPlusVolumeHeader vh) {
        this.signatureField.setText("" + Util.toASCIIString((short)vh.getSignature()));
        this.versionField.setText("" + vh.getVersion());
        this.hardwareLockBox.setSelected(vh.getAttributeVolumeHardwareLock());
        this.volumeUnmountedBox.setSelected(vh.getAttributeVolumeUnmounted());
        this.sparedBlocksBox.setSelected(vh.getAttributeVolumeSparedBlocks());
        this.noCacheBox.setSelected(vh.getAttributeVolumeNoCacheRequired());
        this.volumeInconsistentBox.setSelected(vh.getAttributeBootVolumeInconsistent());
        this.idsReusedBox.setSelected(vh.getAttributeCatalogNodeIDsReused());
        this.journaledBox.setSelected(vh.getAttributeVolumeJournaled());
        this.softwareLockBox.setSelected(vh.getAttributeVolumeSoftwareLock());
        this.lastMountedVersionField.setText("" + Util.toASCIIString((int)vh.getLastMountedVersion()));
        this.journalInfoBlockField.setText("0x" + Util.toHexStringBE((int)vh.getJournalInfoBlock()));
        this.createDateField.setText("" + this.dti.format(vh.getCreateDateAsDate()));
        this.modifyDateField.setText("" + this.dti.format(vh.getModifyDateAsDate()));
        this.backupDateField.setText("" + this.dti.format(vh.getBackupDateAsDate()));
        this.checkedDateField.setText("" + this.dti.format(vh.getCheckedDateAsDate()));
        this.fileCountField.setText("" + vh.getFileCount());
        this.folderCountField.setText("" + vh.getFolderCount());
        this.blockSizeField.setText("" + vh.getBlockSize() + " bytes");
        this.totalBlocksField.setText("" + vh.getTotalBlocks());
        this.freeBlocksField.setText("" + vh.getFreeBlocks());
        this.nextAllocationField.setText("" + vh.getNextAllocation());
        this.rsrcClumpSizeField.setText("" + vh.getRsrcClumpSize() + " bytes");
        this.dataClumpSizeField.setText("" + vh.getDataClumpSize() + " bytes");
        this.nextCatalogIDField.setText("" + vh.getNextCatalogID());
        this.writeCountField.setText("" + vh.getWriteCount());
        this.encodingsBitmapField.setText("0x" + Util.toHexStringBE((long)vh.getEncodingsBitmap()));
        int[] finderInfo = vh.getFinderInfo();
        this.finderInfo1Field.setText("" + finderInfo[0]);
        this.finderInfo2Field.setText("" + finderInfo[1]);
        this.finderInfo3Field.setText("" + finderInfo[2]);
        this.finderInfo4Field.setText("" + finderInfo[3]);
        this.finderInfo5Field.setText("0x" + Util.toHexStringBE((int)finderInfo[4]));
        this.finderInfo6Field.setText("" + finderInfo[5]);
        this.finderInfo78Field.setText("0x" + Util.toHexStringBE((int)finderInfo[6]) + Util.toHexStringBE((int)finderInfo[7]));
        HFSPlusForkData allocationFileData = vh.getAllocationFile();
        this.allocationFileLogicalSizeField.setText(allocationFileData.getLogicalSize() + " bytes");
        this.allocationFileClumpSizeField.setText(allocationFileData.getClumpSize() + " bytes");
        this.allocationFileTotalBlocksField.setText("" + allocationFileData.getTotalBlocks());
        this.allocationFileBasicExtentCountField.setText("" + allocationFileData.getExtents().getNumExtentsInUse());
        HFSPlusForkData extentsFileData = vh.getExtentsFile();
        this.extentsFileLogicalSizeField.setText(extentsFileData.getLogicalSize() + " bytes");
        this.extentsFileClumpSizeField.setText(extentsFileData.getClumpSize() + " bytes");
        this.extentsFileTotalBlocksField.setText("" + extentsFileData.getTotalBlocks());
        this.extentsFileBasicExtentCountField.setText("" + extentsFileData.getExtents().getNumExtentsInUse());
        HFSPlusForkData catalogFileData = vh.getCatalogFile();
        this.catalogFileLogicalSizeField.setText(catalogFileData.getLogicalSize() + " bytes");
        this.catalogFileClumpSizeField.setText(catalogFileData.getClumpSize() + " bytes");
        this.catalogFileTotalBlocksField.setText("" + catalogFileData.getTotalBlocks());
        this.catalogFileBasicExtentCountField.setText("" + catalogFileData.getExtents().getNumExtentsInUse());
        HFSPlusForkData attributesFileData = vh.getAttributesFile();
        this.attributesFileLogicalSizeField.setText(attributesFileData.getLogicalSize() + " bytes");
        this.attributesFileClumpSizeField.setText(attributesFileData.getClumpSize() + " bytes");
        this.attributesFileTotalBlocksField.setText("" + attributesFileData.getTotalBlocks());
        this.attributesFileBasicExtentCountField.setText("" + attributesFileData.getExtents().getNumExtentsInUse());
        HFSPlusForkData startupFileData = vh.getStartupFile();
        this.startupFileLogicalSizeField.setText(startupFileData.getLogicalSize() + " bytes");
        this.startupFileClumpSizeField.setText(startupFileData.getClumpSize() + " bytes");
        this.startupFileTotalBlocksField.setText("" + startupFileData.getTotalBlocks());
        this.startupFileBasicExtentCountField.setText("" + startupFileData.getExtents().getNumExtentsInUse());
    }

    private void initComponents() {
        this.signatureLabel = new JLabel();
        this.signatureField = new JTextField();
        this.versionLabel = new JLabel();
        this.versionField = new JTextField();
        this.attributesSectionLabel = new JLabel();
        this.hardwareLockBox = new JCheckBox();
        this.hardwareLockLabel = new JLabel();
        this.volumeUnmountedBox = new JCheckBox();
        this.volumeUnmountedLabel = new JLabel();
        this.sparedBlocksBox = new JCheckBox();
        this.sparedBlocksLabel = new JLabel();
        this.noCacheBox = new JCheckBox();
        this.noCacheLabel = new JLabel();
        this.volumeInconsistentBox = new JCheckBox();
        this.volumeInconsistentLabel = new JLabel();
        this.idsReusedBox = new JCheckBox();
        this.idsReusedLabel = new JLabel();
        this.journaledBox = new JCheckBox();
        this.journaledLabel = new JLabel();
        this.softwareLockBox = new JCheckBox();
        this.softwareLockLabel = new JLabel();
        this.lastMountedVersionLabel = new JLabel();
        this.lastMountedVersionField = new JTextField();
        this.journalInfoBlockLabel = new JLabel();
        this.journalInfoBlockField = new JTextField();
        this.createDateLabel = new JLabel();
        this.createDateField = new JTextField();
        this.modifyDateLabel = new JLabel();
        this.modifyDateField = new JTextField();
        this.backupDateLabel = new JLabel();
        this.backupDateField = new JTextField();
        this.checkedDateLabel = new JLabel();
        this.checkedDateField = new JTextField();
        this.fileCountLabel = new JLabel();
        this.fileCountField = new JTextField();
        this.folderCountLabel = new JLabel();
        this.folderCountField = new JTextField();
        this.blockSizeLabel = new JLabel();
        this.blockSizeField = new JTextField();
        this.totalBlocksLabel = new JLabel();
        this.totalBlocksField = new JTextField();
        this.freeBlocksLabel = new JLabel();
        this.freeBlocksField = new JTextField();
        this.nextAllocationLabel = new JLabel();
        this.nextAllocationField = new JTextField();
        this.rsrcClumpSizeLabel = new JLabel();
        this.rsrcClumpSizeField = new JTextField();
        this.dataClumpSizeLabel = new JLabel();
        this.dataClumpSizeField = new JTextField();
        this.nextCatalogIDLabel = new JLabel();
        this.nextCatalogIDField = new JTextField();
        this.writeCountLabel = new JLabel();
        this.writeCountField = new JTextField();
        this.encodingsBitmapLabel = new JLabel();
        this.encodingsBitmapField = new JTextField();
        this.finderInfoSectionLabel = new JLabel();
        this.finderInfo1Label = new JLabel();
        this.finderInfo2Label = new JLabel();
        this.finderInfo3Label = new JLabel();
        this.finderInfo4Label = new JLabel();
        this.finderInfo5Label = new JLabel();
        this.finderInfo6Label = new JLabel();
        this.finderInfo78Label = new JLabel();
        this.finderInfo1Field = new JTextField();
        this.finderInfo2Field = new JTextField();
        this.finderInfo3Field = new JTextField();
        this.finderInfo4Field = new JTextField();
        this.finderInfo5Field = new JTextField();
        this.finderInfo6Field = new JTextField();
        this.finderInfo78Field = new JTextField();
        this.allocationFileSectionLabel = new JLabel();
        this.allocationFileLogicalSizeLabel = new JLabel();
        this.allocationFileClumpSizeLabel = new JLabel();
        this.allocationFileTotalBlocksLabel = new JLabel();
        this.allocationFileLogicalSizeField = new JTextField();
        this.allocationFileClumpSizeField = new JTextField();
        this.allocationFileTotalBlocksField = new JTextField();
        this.allocationFileBasicExtentCountField = new JTextField();
        this.allocationFileBasicExtentCountLabel = new JLabel();
        this.extentsFileSectionLabel = new JLabel();
        this.extentsFileLogicalSizeLabel = new JLabel();
        this.extentsFileLogicalSizeField = new JTextField();
        this.extentsFileClumpSizeLabel = new JLabel();
        this.extentsFileClumpSizeField = new JTextField();
        this.extentsFileTotalBlocksLabel = new JLabel();
        this.extentsFileTotalBlocksField = new JTextField();
        this.extentsFileBasicExtentCountLabel = new JLabel();
        this.extentsFileBasicExtentCountField = new JTextField();
        this.catalogFileSectionLabel = new JLabel();
        this.catalogFileLogicalSizeLabel = new JLabel();
        this.catalogFileLogicalSizeField = new JTextField();
        this.catalogFileClumpSizeLabel = new JLabel();
        this.catalogFileClumpSizeField = new JTextField();
        this.catalogFileTotalBlocksLabel = new JLabel();
        this.catalogFileTotalBlocksField = new JTextField();
        this.catalogFileBasicExtentCountLabel = new JLabel();
        this.catalogFileBasicExtentCountField = new JTextField();
        this.attributesFileSectionLabel = new JLabel();
        this.attributesFileLogicalSizeLabel = new JLabel();
        this.attributesFileLogicalSizeField = new JTextField();
        this.attributesFileClumpSizeLabel = new JLabel();
        this.attributesFileClumpSizeField = new JTextField();
        this.attributesFileTotalBlocksLabel = new JLabel();
        this.attributesFileTotalBlocksField = new JTextField();
        this.attributesFileBasicExtentCountLabel = new JLabel();
        this.attributesFileBasicExtentCountField = new JTextField();
        this.startupFileSectionLabel = new JLabel();
        this.startupFileLogicalSizeLabel = new JLabel();
        this.startupFileLogicalSizeField = new JTextField();
        this.startupFileClumpSizeLabel = new JLabel();
        this.startupFileClumpSizeField = new JTextField();
        this.startupFileTotalBlocksLabel = new JLabel();
        this.startupFileTotalBlocksField = new JTextField();
        this.startupFileBasicExtentCountLabel = new JLabel();
        this.startupFileBasicExtentCountField = new JTextField();
        this.signatureLabel.setText("Volume signature:");
        this.signatureField.setEditable(false);
        this.signatureField.setText("jTextField18");
        this.signatureField.setBorder(null);
        this.signatureField.setOpaque(false);
        this.versionLabel.setText("File system version:");
        this.versionField.setEditable(false);
        this.versionField.setText("jTextField19");
        this.versionField.setBorder(null);
        this.versionField.setOpaque(false);
        this.attributesSectionLabel.setText("Attributes:");
        this.hardwareLockBox.setEnabled(false);
        this.hardwareLockBox.setMargin(new Insets(0, 0, 0, 0));
        this.hardwareLockLabel.setText("Volume hardware lock");
        this.volumeUnmountedBox.setEnabled(false);
        this.volumeUnmountedBox.setMargin(new Insets(0, 0, 0, 0));
        this.volumeUnmountedLabel.setText("Volume unmounted");
        this.sparedBlocksBox.setEnabled(false);
        this.sparedBlocksBox.setMargin(new Insets(0, 0, 0, 0));
        this.sparedBlocksLabel.setText("Volume spared blocks");
        this.noCacheBox.setEnabled(false);
        this.noCacheBox.setMargin(new Insets(0, 0, 0, 0));
        this.noCacheLabel.setText("No cache required");
        this.volumeInconsistentBox.setEnabled(false);
        this.volumeInconsistentBox.setMargin(new Insets(0, 0, 0, 0));
        this.volumeInconsistentLabel.setText("Boot volume inconsistent");
        this.idsReusedBox.setEnabled(false);
        this.idsReusedBox.setMargin(new Insets(0, 0, 0, 0));
        this.idsReusedLabel.setText("Catalog node IDs reused");
        this.journaledBox.setEnabled(false);
        this.journaledBox.setMargin(new Insets(0, 0, 0, 0));
        this.journaledLabel.setText("Volume journaled");
        this.softwareLockBox.setEnabled(false);
        this.softwareLockBox.setMargin(new Insets(0, 0, 0, 0));
        this.softwareLockLabel.setText("Volume software lock");
        this.lastMountedVersionLabel.setText("Last mounted version:");
        this.lastMountedVersionField.setEditable(false);
        this.lastMountedVersionField.setText("jTextField1");
        this.lastMountedVersionField.setBorder(null);
        this.lastMountedVersionField.setOpaque(false);
        this.journalInfoBlockLabel.setText("Journal info block ID:");
        this.journalInfoBlockField.setEditable(false);
        this.journalInfoBlockField.setText("jTextField2");
        this.journalInfoBlockField.setBorder(null);
        this.journalInfoBlockField.setOpaque(false);
        this.createDateLabel.setText("Date created:");
        this.createDateField.setEditable(false);
        this.createDateField.setText("jTextField3");
        this.createDateField.setBorder(null);
        this.createDateField.setOpaque(false);
        this.modifyDateLabel.setText("Date last modified:");
        this.modifyDateField.setEditable(false);
        this.modifyDateField.setText("jTextField4");
        this.modifyDateField.setBorder(null);
        this.modifyDateField.setOpaque(false);
        this.backupDateLabel.setText("Date last backuped:");
        this.backupDateField.setEditable(false);
        this.backupDateField.setText("jTextField5");
        this.backupDateField.setBorder(null);
        this.backupDateField.setOpaque(false);
        this.checkedDateLabel.setText("Date last checked:");
        this.checkedDateField.setEditable(false);
        this.checkedDateField.setText("jTextField6");
        this.checkedDateField.setBorder(null);
        this.checkedDateField.setOpaque(false);
        this.fileCountLabel.setText("File count:");
        this.fileCountField.setEditable(false);
        this.fileCountField.setText("jTextField7");
        this.fileCountField.setBorder(null);
        this.fileCountField.setOpaque(false);
        this.folderCountLabel.setText("Folder count:");
        this.folderCountField.setEditable(false);
        this.folderCountField.setText("jTextField8");
        this.folderCountField.setBorder(null);
        this.folderCountField.setOpaque(false);
        this.blockSizeLabel.setText("Block size:");
        this.blockSizeField.setEditable(false);
        this.blockSizeField.setText("jTextField9");
        this.blockSizeField.setBorder(null);
        this.blockSizeField.setOpaque(false);
        this.totalBlocksLabel.setText("Number of blocks:");
        this.totalBlocksField.setEditable(false);
        this.totalBlocksField.setText("jTextField10");
        this.totalBlocksField.setBorder(null);
        this.totalBlocksField.setOpaque(false);
        this.freeBlocksLabel.setText("Number of free blocks:");
        this.freeBlocksField.setEditable(false);
        this.freeBlocksField.setText("jTextField11");
        this.freeBlocksField.setBorder(null);
        this.freeBlocksField.setOpaque(false);
        this.nextAllocationLabel.setText("Start of next allocation search:");
        this.nextAllocationField.setEditable(false);
        this.nextAllocationField.setText("jTextField12");
        this.nextAllocationField.setBorder(null);
        this.nextAllocationField.setOpaque(false);
        this.rsrcClumpSizeLabel.setText("Resource fork default clump size:");
        this.rsrcClumpSizeField.setEditable(false);
        this.rsrcClumpSizeField.setText("jTextField13");
        this.rsrcClumpSizeField.setBorder(null);
        this.rsrcClumpSizeField.setOpaque(false);
        this.dataClumpSizeLabel.setText("Data fork default clump size:");
        this.dataClumpSizeField.setEditable(false);
        this.dataClumpSizeField.setText("jTextField14");
        this.dataClumpSizeField.setBorder(null);
        this.dataClumpSizeField.setOpaque(false);
        this.nextCatalogIDLabel.setText("Next unused catalog ID:");
        this.nextCatalogIDField.setEditable(false);
        this.nextCatalogIDField.setText("jTextField15");
        this.nextCatalogIDField.setBorder(null);
        this.nextCatalogIDField.setOpaque(false);
        this.writeCountLabel.setText("Write count:");
        this.writeCountField.setEditable(false);
        this.writeCountField.setText("jTextField16");
        this.writeCountField.setBorder(null);
        this.writeCountField.setOpaque(false);
        this.encodingsBitmapLabel.setText("Encodings bitmap:");
        this.encodingsBitmapField.setEditable(false);
        this.encodingsBitmapField.setText("jTextField17");
        this.encodingsBitmapField.setBorder(null);
        this.encodingsBitmapField.setOpaque(false);
        this.finderInfoSectionLabel.setText("Finder info:");
        this.finderInfo1Label.setText("System folder ID:");
        this.finderInfo2Label.setText("Startup application parent folder ID:");
        this.finderInfo3Label.setText("Folder ID to display at mount:");
        this.finderInfo4Label.setText("Legacy Mac OS system folder ID:");
        this.finderInfo5Label.setText("Reserved:");
        this.finderInfo6Label.setText("Mac OS X system folder ID:");
        this.finderInfo78Label.setText("Unique volume identifier:");
        this.finderInfo1Field.setEditable(false);
        this.finderInfo1Field.setText("jTextField1");
        this.finderInfo1Field.setBorder(null);
        this.finderInfo1Field.setOpaque(false);
        this.finderInfo2Field.setEditable(false);
        this.finderInfo2Field.setText("jTextField2");
        this.finderInfo2Field.setBorder(null);
        this.finderInfo2Field.setOpaque(false);
        this.finderInfo3Field.setEditable(false);
        this.finderInfo3Field.setText("jTextField3");
        this.finderInfo3Field.setBorder(null);
        this.finderInfo3Field.setOpaque(false);
        this.finderInfo4Field.setEditable(false);
        this.finderInfo4Field.setText("jTextField4");
        this.finderInfo4Field.setBorder(null);
        this.finderInfo4Field.setOpaque(false);
        this.finderInfo5Field.setEditable(false);
        this.finderInfo5Field.setText("jTextField5");
        this.finderInfo5Field.setBorder(null);
        this.finderInfo5Field.setOpaque(false);
        this.finderInfo6Field.setEditable(false);
        this.finderInfo6Field.setText("jTextField6");
        this.finderInfo6Field.setBorder(null);
        this.finderInfo6Field.setOpaque(false);
        this.finderInfo78Field.setEditable(false);
        this.finderInfo78Field.setText("jTextField7");
        this.finderInfo78Field.setBorder(null);
        this.finderInfo78Field.setOpaque(false);
        this.allocationFileSectionLabel.setText("Allocation file:");
        this.allocationFileLogicalSizeLabel.setText("Logical size:");
        this.allocationFileClumpSizeLabel.setText("Clump size:");
        this.allocationFileTotalBlocksLabel.setText("Total blocks:");
        this.allocationFileLogicalSizeField.setEditable(false);
        this.allocationFileLogicalSizeField.setText("jTextField1");
        this.allocationFileLogicalSizeField.setBorder(null);
        this.allocationFileLogicalSizeField.setOpaque(false);
        this.allocationFileClumpSizeField.setEditable(false);
        this.allocationFileClumpSizeField.setText("jTextField2");
        this.allocationFileClumpSizeField.setBorder(null);
        this.allocationFileClumpSizeField.setOpaque(false);
        this.allocationFileTotalBlocksField.setEditable(false);
        this.allocationFileTotalBlocksField.setText("jTextField3");
        this.allocationFileTotalBlocksField.setBorder(null);
        this.allocationFileTotalBlocksField.setOpaque(false);
        this.allocationFileBasicExtentCountField.setEditable(false);
        this.allocationFileBasicExtentCountField.setText("jTextField1");
        this.allocationFileBasicExtentCountField.setAutoscrolls(false);
        this.allocationFileBasicExtentCountField.setBorder(null);
        this.allocationFileBasicExtentCountField.setOpaque(false);
        this.allocationFileBasicExtentCountLabel.setText("Number of basic extents:");
        this.extentsFileSectionLabel.setText("Extents file:");
        this.extentsFileLogicalSizeLabel.setText("Logical size:");
        this.extentsFileLogicalSizeField.setEditable(false);
        this.extentsFileLogicalSizeField.setText("jTextField1");
        this.extentsFileLogicalSizeField.setBorder(null);
        this.extentsFileLogicalSizeField.setOpaque(false);
        this.extentsFileClumpSizeLabel.setText("Clump size:");
        this.extentsFileClumpSizeField.setEditable(false);
        this.extentsFileClumpSizeField.setText("jTextField2");
        this.extentsFileClumpSizeField.setBorder(null);
        this.extentsFileClumpSizeField.setOpaque(false);
        this.extentsFileTotalBlocksLabel.setText("Total blocks:");
        this.extentsFileTotalBlocksField.setEditable(false);
        this.extentsFileTotalBlocksField.setText("jTextField3");
        this.extentsFileTotalBlocksField.setBorder(null);
        this.extentsFileTotalBlocksField.setOpaque(false);
        this.extentsFileBasicExtentCountLabel.setText("Number of basic extents:");
        this.extentsFileBasicExtentCountField.setEditable(false);
        this.extentsFileBasicExtentCountField.setText("jTextField1");
        this.extentsFileBasicExtentCountField.setBorder(null);
        this.extentsFileBasicExtentCountField.setOpaque(false);
        this.catalogFileSectionLabel.setText("Catalog file:");
        this.catalogFileLogicalSizeLabel.setText("Logical size:");
        this.catalogFileLogicalSizeField.setEditable(false);
        this.catalogFileLogicalSizeField.setText("jTextField1");
        this.catalogFileLogicalSizeField.setBorder(null);
        this.catalogFileLogicalSizeField.setOpaque(false);
        this.catalogFileClumpSizeLabel.setText("Clump size:");
        this.catalogFileClumpSizeField.setEditable(false);
        this.catalogFileClumpSizeField.setText("jTextField2");
        this.catalogFileClumpSizeField.setBorder(null);
        this.catalogFileClumpSizeField.setOpaque(false);
        this.catalogFileTotalBlocksLabel.setText("Total blocks:");
        this.catalogFileTotalBlocksField.setEditable(false);
        this.catalogFileTotalBlocksField.setText("jTextField3");
        this.catalogFileTotalBlocksField.setBorder(null);
        this.catalogFileTotalBlocksField.setOpaque(false);
        this.catalogFileBasicExtentCountLabel.setText("Number of basic extents:");
        this.catalogFileBasicExtentCountField.setEditable(false);
        this.catalogFileBasicExtentCountField.setText("jTextField1");
        this.catalogFileBasicExtentCountField.setBorder(null);
        this.catalogFileBasicExtentCountField.setOpaque(false);
        this.attributesFileSectionLabel.setText("Attributes file:");
        this.attributesFileLogicalSizeLabel.setText("Logical size:");
        this.attributesFileLogicalSizeField.setEditable(false);
        this.attributesFileLogicalSizeField.setText("jTextField1");
        this.attributesFileLogicalSizeField.setBorder(null);
        this.attributesFileLogicalSizeField.setOpaque(false);
        this.attributesFileClumpSizeLabel.setText("Clump size:");
        this.attributesFileClumpSizeField.setEditable(false);
        this.attributesFileClumpSizeField.setText("jTextField2");
        this.attributesFileClumpSizeField.setBorder(null);
        this.attributesFileClumpSizeField.setOpaque(false);
        this.attributesFileTotalBlocksLabel.setText("Total blocks:");
        this.attributesFileTotalBlocksField.setEditable(false);
        this.attributesFileTotalBlocksField.setText("jTextField3");
        this.attributesFileTotalBlocksField.setBorder(null);
        this.attributesFileTotalBlocksField.setOpaque(false);
        this.attributesFileBasicExtentCountLabel.setText("Number of basic extents:");
        this.attributesFileBasicExtentCountField.setEditable(false);
        this.attributesFileBasicExtentCountField.setText("jTextField1");
        this.attributesFileBasicExtentCountField.setBorder(null);
        this.attributesFileBasicExtentCountField.setOpaque(false);
        this.startupFileSectionLabel.setText("Startup file:");
        this.startupFileLogicalSizeLabel.setText("Logical size:");
        this.startupFileLogicalSizeField.setEditable(false);
        this.startupFileLogicalSizeField.setText("jTextField1");
        this.startupFileLogicalSizeField.setBorder(null);
        this.startupFileLogicalSizeField.setOpaque(false);
        this.startupFileClumpSizeLabel.setText("Clump size:");
        this.startupFileClumpSizeField.setEditable(false);
        this.startupFileClumpSizeField.setText("jTextField2");
        this.startupFileClumpSizeField.setBorder(null);
        this.startupFileClumpSizeField.setOpaque(false);
        this.startupFileTotalBlocksLabel.setText("Total blocks:");
        this.startupFileTotalBlocksField.setEditable(false);
        this.startupFileTotalBlocksField.setText("jTextField3");
        this.startupFileTotalBlocksField.setBorder(null);
        this.startupFileTotalBlocksField.setOpaque(false);
        this.startupFileBasicExtentCountLabel.setText("Number of basic extents:");
        this.startupFileBasicExtentCountField.setEditable(false);
        this.startupFileBasicExtentCountField.setText("jTextField1");
        this.startupFileBasicExtentCountField.setBorder(null);
        this.startupFileBasicExtentCountField.setOpaque(false);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.signatureLabel).addPreferredGap(0).add((Component)this.signatureField, -1, 316, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.versionLabel).addPreferredGap(0).add((Component)this.versionField, -1, 305, Short.MAX_VALUE)).add((Component)this.attributesSectionLabel).add((GroupLayout.Group)layout.createSequentialGroup().add(24, 24, 24).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.hardwareLockBox).addPreferredGap(0).add((Component)this.hardwareLockLabel)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.noCacheBox).addPreferredGap(0).add((Component)this.noCacheLabel)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.volumeInconsistentBox).addPreferredGap(0).add((Component)this.volumeInconsistentLabel)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.idsReusedBox).addPreferredGap(0).add((Component)this.idsReusedLabel)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.journaledBox).addPreferredGap(0).add((Component)this.journaledLabel)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.softwareLockBox).addPreferredGap(0).add((Component)this.softwareLockLabel)).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.volumeUnmountedBox).addPreferredGap(0).add((Component)this.volumeUnmountedLabel)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.sparedBlocksBox).addPreferredGap(0).add((Component)this.sparedBlocksLabel)))))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lastMountedVersionLabel).addPreferredGap(0).add((Component)this.lastMountedVersionField, -1, 290, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.journalInfoBlockLabel).addPreferredGap(0).add((Component)this.journalInfoBlockField, -1, 296, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.fileCountLabel).addPreferredGap(0).add((Component)this.fileCountField, -1, 364, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.folderCountLabel).addPreferredGap(0).add((Component)this.folderCountField, -1, 347, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.blockSizeLabel).addPreferredGap(0).add((Component)this.blockSizeField, -1, 363, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.totalBlocksLabel).addPreferredGap(0).add((Component)this.totalBlocksField, -1, 313, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.freeBlocksLabel).addPreferredGap(0).add((Component)this.freeBlocksField, -1, 285, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.nextAllocationLabel).addPreferredGap(0).add((Component)this.nextAllocationField, -1, 237, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.rsrcClumpSizeLabel).addPreferredGap(0).add((Component)this.rsrcClumpSizeField, -1, 219, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.dataClumpSizeLabel).addPreferredGap(0).add((Component)this.dataClumpSizeField, -1, 247, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.nextCatalogIDLabel).addPreferredGap(0).add((Component)this.nextCatalogIDField, -1, 278, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.writeCountLabel).addPreferredGap(0).add((Component)this.writeCountField, -1, 354, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.encodingsBitmapLabel).addPreferredGap(0).add((Component)this.encodingsBitmapField, -1, 313, Short.MAX_VALUE)).add((Component)this.finderInfoSectionLabel).add((GroupLayout.Group)layout.createSequentialGroup().add(24, 24, 24).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.finderInfo2Label).addPreferredGap(0).add((Component)this.finderInfo2Field, -1, 180, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.finderInfo1Label).addPreferredGap(0).add((Component)this.finderInfo1Field, -1, 298, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.finderInfo3Label).addPreferredGap(0).add((Component)this.finderInfo3Field, -1, 218, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.finderInfo4Label).addPreferredGap(0).add((Component)this.finderInfo4Field, -1, 201, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.finderInfo5Label).addPreferredGap(0).add((Component)this.finderInfo5Field, -1, 346, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.finderInfo6Label).addPreferredGap(0).add((Component)this.finderInfo6Field, -1, 236, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.finderInfo78Label).addPreferredGap(0).add((Component)this.finderInfo78Field, -1, 247, Short.MAX_VALUE)))).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.backupDateLabel).add((Component)this.modifyDateLabel).add((Component)this.createDateLabel).add((Component)this.checkedDateLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.checkedDateField, -1, 305, Short.MAX_VALUE).add((Component)this.createDateField, -1, 305, Short.MAX_VALUE).add((Component)this.modifyDateField, -1, 305, Short.MAX_VALUE).add((Component)this.backupDateField, -1, 305, Short.MAX_VALUE))).add((Component)this.allocationFileSectionLabel).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.allocationFileClumpSizeLabel).addPreferredGap(0).add((Component)this.allocationFileClumpSizeField, -1, 346, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.allocationFileLogicalSizeLabel).addPreferredGap(0).add((Component)this.allocationFileLogicalSizeField, -1, 342, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.allocationFileTotalBlocksLabel).addPreferredGap(0).add((Component)this.allocationFileTotalBlocksField, -1, 338, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.allocationFileBasicExtentCountLabel).addPreferredGap(0).add((Component)this.allocationFileBasicExtentCountField, -1, 261, Short.MAX_VALUE)))).add((Component)this.extentsFileSectionLabel).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.extentsFileClumpSizeLabel).addPreferredGap(0).add((Component)this.extentsFileClumpSizeField, -1, 346, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.extentsFileLogicalSizeLabel).addPreferredGap(0).add((Component)this.extentsFileLogicalSizeField, -1, 342, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.extentsFileTotalBlocksLabel).addPreferredGap(0).add((Component)this.extentsFileTotalBlocksField, -1, 338, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.extentsFileBasicExtentCountLabel).addPreferredGap(0).add((Component)this.extentsFileBasicExtentCountField, -1, 261, Short.MAX_VALUE)))).add((Component)this.catalogFileSectionLabel).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.catalogFileClumpSizeLabel).addPreferredGap(0).add((Component)this.catalogFileClumpSizeField, -1, 346, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.catalogFileLogicalSizeLabel).addPreferredGap(0).add((Component)this.catalogFileLogicalSizeField, -1, 342, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.catalogFileTotalBlocksLabel).addPreferredGap(0).add((Component)this.catalogFileTotalBlocksField, -1, 338, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.catalogFileBasicExtentCountLabel).addPreferredGap(0).add((Component)this.catalogFileBasicExtentCountField, -1, 261, Short.MAX_VALUE)))).add((Component)this.attributesFileSectionLabel).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.attributesFileClumpSizeLabel).addPreferredGap(0).add((Component)this.attributesFileClumpSizeField, -1, 346, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.attributesFileLogicalSizeLabel).addPreferredGap(0).add((Component)this.attributesFileLogicalSizeField, -1, 342, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.attributesFileTotalBlocksLabel).addPreferredGap(0).add((Component)this.attributesFileTotalBlocksField, -1, 338, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.attributesFileBasicExtentCountLabel).addPreferredGap(0).add((Component)this.attributesFileBasicExtentCountField, -1, 261, Short.MAX_VALUE)))).add((Component)this.startupFileSectionLabel).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.startupFileClumpSizeLabel).addPreferredGap(0).add((Component)this.startupFileClumpSizeField, -1, 346, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.startupFileLogicalSizeLabel).addPreferredGap(0).add((Component)this.startupFileLogicalSizeField, -1, 342, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.startupFileTotalBlocksLabel).addPreferredGap(0).add((Component)this.startupFileTotalBlocksField, -1, 338, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.startupFileBasicExtentCountLabel).addPreferredGap(0).add((Component)this.startupFileBasicExtentCountField, -1, 261, Short.MAX_VALUE))))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.signatureLabel).add((Component)this.signatureField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.versionLabel).add((Component)this.versionField, -2, -1, -2)).addPreferredGap(0).add((Component)this.attributesSectionLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.hardwareLockBox).add((Component)this.hardwareLockLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.volumeUnmountedBox).add((Component)this.volumeUnmountedLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.sparedBlocksBox).add((Component)this.sparedBlocksLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.noCacheBox).add((Component)this.noCacheLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.volumeInconsistentBox).add((Component)this.volumeInconsistentLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.idsReusedBox).add((Component)this.idsReusedLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.journaledBox).add((Component)this.journaledLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.softwareLockBox).add((Component)this.softwareLockLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lastMountedVersionLabel).add((Component)this.lastMountedVersionField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.journalInfoBlockLabel).add((Component)this.journalInfoBlockField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.createDateLabel).add((Component)this.createDateField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.modifyDateLabel).add((Component)this.modifyDateField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.backupDateLabel).add((Component)this.backupDateField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.checkedDateLabel).add((Component)this.checkedDateField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.fileCountLabel).add((Component)this.fileCountField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.folderCountLabel).add((Component)this.folderCountField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.blockSizeLabel).add((Component)this.blockSizeField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.totalBlocksLabel).add((Component)this.totalBlocksField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.freeBlocksLabel).add((Component)this.freeBlocksField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.nextAllocationLabel).add((Component)this.nextAllocationField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.rsrcClumpSizeLabel).add((Component)this.rsrcClumpSizeField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.dataClumpSizeLabel).add((Component)this.dataClumpSizeField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.nextCatalogIDLabel).add((Component)this.nextCatalogIDField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.writeCountLabel).add((Component)this.writeCountField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.encodingsBitmapLabel).add((Component)this.encodingsBitmapField, -2, -1, -2)).addPreferredGap(0).add((Component)this.finderInfoSectionLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.finderInfo1Label).add((Component)this.finderInfo1Field, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.finderInfo2Label).add((Component)this.finderInfo2Field, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.finderInfo3Label).add((Component)this.finderInfo3Field, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.finderInfo4Label).add((Component)this.finderInfo4Field, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.finderInfo5Label).add((Component)this.finderInfo5Field, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.finderInfo6Label).add((Component)this.finderInfo6Field, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.finderInfo78Label).add((Component)this.finderInfo78Field, -2, -1, -2)).addPreferredGap(0).add((Component)this.allocationFileSectionLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.allocationFileLogicalSizeLabel).add((Component)this.allocationFileLogicalSizeField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.allocationFileClumpSizeLabel).add((Component)this.allocationFileClumpSizeField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.allocationFileTotalBlocksLabel).add((Component)this.allocationFileTotalBlocksField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.allocationFileBasicExtentCountLabel).add((Component)this.allocationFileBasicExtentCountField, -2, -1, -2)).addPreferredGap(0).add((Component)this.extentsFileSectionLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.extentsFileLogicalSizeLabel).add((Component)this.extentsFileLogicalSizeField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.extentsFileClumpSizeLabel).add((Component)this.extentsFileClumpSizeField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.extentsFileTotalBlocksLabel).add((Component)this.extentsFileTotalBlocksField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.extentsFileBasicExtentCountLabel).add((Component)this.extentsFileBasicExtentCountField, -2, -1, -2)).addPreferredGap(0).add((Component)this.catalogFileSectionLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.catalogFileLogicalSizeLabel).add((Component)this.catalogFileLogicalSizeField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.catalogFileClumpSizeLabel).add((Component)this.catalogFileClumpSizeField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.catalogFileTotalBlocksLabel).add((Component)this.catalogFileTotalBlocksField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.catalogFileBasicExtentCountLabel).add((Component)this.catalogFileBasicExtentCountField, -2, -1, -2)).addPreferredGap(0).add((Component)this.attributesFileSectionLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.attributesFileLogicalSizeLabel).add((Component)this.attributesFileLogicalSizeField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.attributesFileClumpSizeLabel).add((Component)this.attributesFileClumpSizeField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.attributesFileTotalBlocksLabel).add((Component)this.attributesFileTotalBlocksField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.attributesFileBasicExtentCountLabel).add((Component)this.attributesFileBasicExtentCountField, -2, -1, -2)).addPreferredGap(0).add((Component)this.startupFileSectionLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.startupFileLogicalSizeLabel).add((Component)this.startupFileLogicalSizeField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.startupFileClumpSizeLabel).add((Component)this.startupFileClumpSizeField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.startupFileTotalBlocksLabel).add((Component)this.startupFileTotalBlocksField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.startupFileBasicExtentCountLabel).add((Component)this.startupFileBasicExtentCountField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

