/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format;

import ghidra.app.util.pcodeInject.ArrayMethods;
import ghidra.app.util.pcodeInject.JavaComputationalCategory;
import ghidra.app.util.pcodeInject.JavaInvocationType;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.javaclass.format.constantpool.ConstantPoolInterfaceMethodReferenceInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolInvokeDynamicInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolMethodReferenceInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolNameAndTypeInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolUtf8Info;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.LongDataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ShortDataType;
import ghidra.program.model.data.SignedByteDataType;
import ghidra.program.model.data.TypedefDataType;
import java.util.ArrayList;
import java.util.List;

public class DescriptorDecoder {
    public static final byte BASE_TYPE_BYTE = 66;
    public static final byte BASE_TYPE_CHAR = 67;
    public static final byte BASE_TYPE_SHORT = 83;
    public static final byte BASE_TYPE_INT = 73;
    public static final byte BASE_TYPE_LONG = 74;
    public static final byte BASE_TYPE_FLOAT = 70;
    public static final byte BASE_TYPE_DOUBLE = 68;
    public static final byte BASE_TYPE_BOOLEAN = 90;
    public static final byte BASE_TYPE_STRING = 115;
    public static final byte BASE_TYPE_VOID = 86;
    public static final byte BASE_TYPE_CLASS = 99;
    public static final byte BASE_TYPE_ARRAY = 91;
    public static final byte BASE_TYPE_REFERENCE = 76;
    public static final byte BASE_TYPE_ENUM = 101;
    public static final byte BASE_TYPE_ANNOTATION = 64;

    private DescriptorDecoder() {
        throw new AssertionError();
    }

    public static int getStackPurge(String methodDescriptor) {
        int stackPurge = 0;
        List<JavaComputationalCategory> categories = DescriptorDecoder.getParameterCategories(methodDescriptor);
        block4: for (JavaComputationalCategory cat : categories) {
            switch (cat) {
                case CAT_1: {
                    stackPurge += 4;
                    continue block4;
                }
                case CAT_2: {
                    stackPurge += 8;
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Bad category!");
        }
        return stackPurge;
    }

    public static JavaComputationalCategory getReturnCategoryOfMethodDescriptor(String methodDescriptor) {
        int closeParenIndex = methodDescriptor.indexOf(")");
        if (closeParenIndex == -1) {
            throw new IllegalArgumentException("Invalid method descriptor: " + methodDescriptor);
        }
        String returnDescriptor = methodDescriptor.substring(closeParenIndex + 1, methodDescriptor.length());
        return DescriptorDecoder.getComputationalCategoryOfDescriptor(returnDescriptor);
    }

    public static DataType getReturnTypeOfMethodDescriptor(String methodDescriptor, DataTypeManager dtManager) {
        int closeParenIndex = methodDescriptor.indexOf(")");
        if (closeParenIndex == -1) {
            throw new IllegalArgumentException("Invalid method descriptor: " + methodDescriptor);
        }
        String returnDescriptor = methodDescriptor.substring(closeParenIndex + 1, methodDescriptor.length());
        if (returnDescriptor.startsWith("[")) {
            return DescriptorDecoder.getPointerType(returnDescriptor, dtManager);
        }
        return DescriptorDecoder.getDataTypeOfDescriptor(returnDescriptor, dtManager);
    }

    public static JavaComputationalCategory getComputationalCategoryOfDescriptor(String descriptor) {
        switch (descriptor.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'F': 
            case 'I': 
            case 'L': 
            case 'S': 
            case 'Z': 
            case '[': {
                return JavaComputationalCategory.CAT_1;
            }
            case 'D': 
            case 'J': {
                return JavaComputationalCategory.CAT_2;
            }
            case 'V': {
                return JavaComputationalCategory.VOID;
            }
        }
        throw new IllegalArgumentException("Invalid computational category: " + descriptor);
    }

    public static List<String> getTypeNameList(String methodDescriptor, boolean fullyQualifiedName, boolean replaceSlash) {
        ArrayList<String> typeNames = new ArrayList<String>();
        int closeParenIndex = methodDescriptor.indexOf(")");
        String argString = methodDescriptor.substring(1, closeParenIndex);
        int currentPosition = 0;
        int len = argString.length();
        while (currentPosition < len) {
            String currentParamTypeName;
            String currentParam = argString.substring(currentPosition, currentPosition + 1);
            if (currentParam.equals("[")) {
                int initialBracket = currentPosition;
                while (argString.charAt(currentPosition) == '[') {
                    ++currentPosition;
                }
                if (argString.charAt(currentPosition) == 'L') {
                    int semiColonIndex = argString.indexOf(";", currentPosition);
                    currentPosition = semiColonIndex + 1;
                } else {
                    ++currentPosition;
                }
                currentParamTypeName = DescriptorDecoder.getTypeNameFromDescriptor(argString.substring(initialBracket, currentPosition), fullyQualifiedName, replaceSlash);
                typeNames.add(currentParamTypeName);
                continue;
            }
            switch (currentParam) {
                case "L": {
                    int semiColonIndex = argString.indexOf(";", currentPosition);
                    currentParamTypeName = DescriptorDecoder.getTypeNameFromDescriptor(argString.substring(currentPosition, semiColonIndex + 1), fullyQualifiedName, replaceSlash);
                    currentPosition = semiColonIndex + 1;
                    break;
                }
                default: {
                    currentParamTypeName = DescriptorDecoder.getTypeNameFromDescriptor(currentParam, fullyQualifiedName, replaceSlash);
                    ++currentPosition;
                }
            }
            typeNames.add(currentParamTypeName);
        }
        String returnType = methodDescriptor.substring(closeParenIndex + 1, methodDescriptor.length());
        typeNames.add(DescriptorDecoder.getTypeNameFromDescriptor(returnType, fullyQualifiedName, replaceSlash));
        return typeNames;
    }

    public static String getTypeNameFromDescriptor(String descriptor, boolean fullyQualifiedName, boolean replaceSlash) {
        if (descriptor.startsWith("L")) {
            String name = descriptor.substring(1, descriptor.length() - 1);
            if (fullyQualifiedName) {
                if (replaceSlash) {
                    return name.replace("/", ".");
                }
                return name;
            }
            int lastSlash = name.lastIndexOf("/");
            return name.substring(lastSlash + 1, name.length());
        }
        if (descriptor.startsWith("[")) {
            int dimension = descriptor.lastIndexOf("[") + 1;
            String baseType = DescriptorDecoder.getTypeNameFromDescriptor(descriptor.replace("[", ""), fullyQualifiedName, replaceSlash);
            StringBuilder sb = new StringBuilder(baseType);
            for (int i = 0; i < dimension; ++i) {
                sb.append("[]");
            }
            return sb.toString();
        }
        switch (descriptor.charAt(0)) {
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'S': {
                return "short";
            }
            case 'Z': {
                return "boolean";
            }
            case 'D': {
                return "double";
            }
            case 'J': {
                return "long";
            }
            case 'V': {
                return "void";
            }
        }
        throw new IllegalArgumentException("invalid descriptor: " + descriptor);
    }

    public static DataType getReferenceTypeOfDescriptor(String descriptor, DataTypeManager dtManager, boolean includesLandSemi) {
        if (includesLandSemi) {
            descriptor = descriptor.substring(1, descriptor.length() - 1);
        }
        String[] parts = descriptor.split("/");
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append('/');
            sb.append(part);
        }
        DataTypePath dataPath = new DataTypePath(sb.toString(), parts[parts.length - 1]);
        DataType referencedType = dtManager.getDataType(dataPath);
        return new PointerDataType(referencedType);
    }

    public static DataType getDataTypeOfDescriptor(String descriptor, DataTypeManager dtManager) {
        if (descriptor.startsWith("[")) {
            return DescriptorDecoder.getPointerType(descriptor, dtManager);
        }
        switch (descriptor.charAt(0)) {
            case 'B': {
                return SignedByteDataType.dataType;
            }
            case 'C': {
                return CharDataType.dataType;
            }
            case 'I': {
                return IntegerDataType.dataType;
            }
            case 'S': {
                return ShortDataType.dataType;
            }
            case 'Z': {
                return BooleanDataType.dataType;
            }
            case 'F': {
                return FloatDataType.dataType;
            }
            case 'L': {
                return DescriptorDecoder.getReferenceTypeOfDescriptor(descriptor, dtManager, true);
            }
            case 'D': {
                return DoubleDataType.dataType;
            }
            case 'J': {
                return LongDataType.dataType;
            }
            case 'V': {
                return DataType.VOID;
            }
        }
        throw new IllegalArgumentException("Invalid type descriptor: " + descriptor);
    }

    public static DataType getPointerType(String descriptor, DataTypeManager dtManager) {
        int lastBracket = descriptor.lastIndexOf("[");
        String baseTypeOfArray = descriptor.substring(lastBracket + 1, lastBracket + 2);
        DataType baseType = null;
        switch (baseTypeOfArray.charAt(0)) {
            case 'B': {
                baseType = ArrayMethods.getArrayBaseType(8, dtManager);
                break;
            }
            case 'Z': {
                baseType = ArrayMethods.getArrayBaseType(4, dtManager);
                break;
            }
            case 'C': {
                baseType = ArrayMethods.getArrayBaseType(5, dtManager);
                break;
            }
            case 'D': {
                baseType = ArrayMethods.getArrayBaseType(7, dtManager);
                break;
            }
            case 'F': {
                baseType = ArrayMethods.getArrayBaseType(6, dtManager);
                break;
            }
            case 'I': {
                baseType = ArrayMethods.getArrayBaseType(10, dtManager);
                break;
            }
            case 'J': {
                baseType = ArrayMethods.getArrayBaseType(11, dtManager);
                break;
            }
            case 'S': {
                baseType = ArrayMethods.getArrayBaseType(9, dtManager);
                break;
            }
            case 'L': {
                return dtManager.getPointer((DataType)DWordDataType.dataType);
            }
            default: {
                throw new IllegalArgumentException("Invalid array base type category: " + baseTypeOfArray);
            }
        }
        return dtManager.getPointer(baseType);
    }

    public static List<JavaComputationalCategory> getParameterCategories(String methodDescriptor) {
        ArrayList<JavaComputationalCategory> categories = new ArrayList<JavaComputationalCategory>();
        int closeParenIndex = methodDescriptor.indexOf(")");
        String argString = methodDescriptor.substring(1, closeParenIndex);
        int currentPosition = 0;
        int len = argString.length();
        block12: while (currentPosition < len) {
            String currentParam = argString.substring(currentPosition, currentPosition + 1);
            JavaComputationalCategory category = DescriptorDecoder.getComputationalCategoryOfDescriptor(currentParam);
            switch (category) {
                case CAT_1: {
                    categories.add(JavaComputationalCategory.CAT_1);
                    break;
                }
                case CAT_2: {
                    categories.add(JavaComputationalCategory.CAT_2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad category for param:" + category.name());
                }
            }
            switch (currentParam) {
                case "L": {
                    int semiColonIndex = argString.indexOf(";", currentPosition);
                    currentPosition = semiColonIndex + 1;
                    continue block12;
                }
                case "[": {
                    int semiColonIndex;
                    while (argString.charAt(currentPosition) == '[') {
                        ++currentPosition;
                    }
                    if (argString.charAt(currentPosition) == 'L') {
                        semiColonIndex = argString.indexOf(";", currentPosition);
                        currentPosition = semiColonIndex + 1;
                        continue block12;
                    }
                    ++currentPosition;
                    continue block12;
                }
            }
            ++currentPosition;
        }
        return categories;
    }

    public static List<DataType> getDataTypeList(String methodDescriptor, DataTypeManager dtManager) {
        ArrayList<DataType> paramDataTypes = new ArrayList<DataType>();
        int closeParenIndex = methodDescriptor.indexOf(")");
        String argString = methodDescriptor.substring(1, closeParenIndex);
        int currentPosition = 0;
        int len = argString.length();
        String currentParam = null;
        while (currentPosition < len) {
            int arrayDimensions = 0;
            while (argString.charAt(currentPosition) == '[') {
                ++arrayDimensions;
                ++currentPosition;
            }
            switch (argString.charAt(currentPosition)) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    currentParam = argString.substring(currentPosition, currentPosition + 1);
                    ++currentPosition;
                    break;
                }
                case 'L': {
                    int semiColonIndex = argString.indexOf(";", currentPosition);
                    currentParam = argString.substring(currentPosition, semiColonIndex + 1);
                    currentPosition = semiColonIndex + 1;
                }
            }
            DataType currentParamType = DescriptorDecoder.getDataTypeOfDescriptor(currentParam, dtManager);
            if (arrayDimensions > 0) {
                paramDataTypes.add((DataType)dtManager.getPointer(currentParamType));
                continue;
            }
            paramDataTypes.add(currentParamType);
        }
        return paramDataTypes;
    }

    public static String getDescriptorForInvoke(int offset, AbstractConstantPoolInfoJava[] constantPool, JavaInvocationType type) {
        String descriptor = null;
        int name_and_type_index = 0;
        switch (type) {
            case INVOKE_DYNAMIC: {
                ConstantPoolInvokeDynamicInfo dynamicInfo = (ConstantPoolInvokeDynamicInfo)constantPool[offset];
                name_and_type_index = dynamicInfo.getNameAndTypeIndex();
                break;
            }
            case INVOKE_INTERFACE: {
                ConstantPoolInterfaceMethodReferenceInfo interfaceInfo = (ConstantPoolInterfaceMethodReferenceInfo)constantPool[offset];
                name_and_type_index = interfaceInfo.getNameAndTypeIndex();
                break;
            }
            case INVOKE_STATIC: {
                ConstantPoolInterfaceMethodReferenceInfo interfaceInfo;
                AbstractConstantPoolInfoJava poolElem = constantPool[offset];
                if (poolElem instanceof ConstantPoolInterfaceMethodReferenceInfo) {
                    interfaceInfo = (ConstantPoolInterfaceMethodReferenceInfo)constantPool[offset];
                    name_and_type_index = interfaceInfo.getNameAndTypeIndex();
                    break;
                }
                if (poolElem instanceof ConstantPoolMethodReferenceInfo) {
                    ConstantPoolMethodReferenceInfo methodReferenceInfo = (ConstantPoolMethodReferenceInfo)constantPool[offset];
                    name_and_type_index = methodReferenceInfo.getNameAndTypeIndex();
                    break;
                }
                throw new IllegalArgumentException("Unsupported type for invokestatic at constant pool element " + offset);
            }
            case INVOKE_SPECIAL: 
            case INVOKE_VIRTUAL: {
                ConstantPoolMethodReferenceInfo methodReferenceInfo = (ConstantPoolMethodReferenceInfo)constantPool[offset];
                name_and_type_index = methodReferenceInfo.getNameAndTypeIndex();
                break;
            }
            default: {
                throw new IllegalArgumentException("unimplemented method type: " + type.name());
            }
        }
        ConstantPoolNameAndTypeInfo methodNameAndType = (ConstantPoolNameAndTypeInfo)constantPool[name_and_type_index];
        int descriptor_index = methodNameAndType.getDescriptorIndex();
        ConstantPoolUtf8Info descriptorInfo = (ConstantPoolUtf8Info)constantPool[descriptor_index];
        descriptor = descriptorInfo.getString();
        return descriptor;
    }

    public static DataType resolveClassForString(String fullyQualifiedName, DataTypeManager dtm, DataType baseType) {
        fullyQualifiedName = "/" + (String)fullyQualifiedName;
        CategoryPath catPath = new CategoryPath((String)fullyQualifiedName);
        String[] parts = catPath.getPathElements();
        TypedefDataType dataType = new TypedefDataType(catPath, parts[parts.length - 1], baseType);
        dtm.resolve((DataType)dataType, DataTypeConflictHandler.KEEP_HANDLER);
        return dataType;
    }

    public static String getParameterString(String descriptor) {
        List<String> paramTypeNames = DescriptorDecoder.getTypeNameList(descriptor, true, true);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int max = paramTypeNames.size() - 1;
        for (int i = 0; i < max; ++i) {
            sb.append(paramTypeNames.get(i));
            if (i >= max - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

