/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Buffer;
import db.Field;
import ghidra.util.exception.AssertException;
import java.io.IOException;

public class ByteField
extends Field {
    private byte value;

    public ByteField() {
    }

    public ByteField(byte b) {
        this.value = b;
    }

    @Override
    public byte getByteValue() {
        return this.value;
    }

    @Override
    public void setByteValue(byte value) {
        this.value = value;
    }

    @Override
    int length() {
        return 1;
    }

    @Override
    int write(Buffer buf, int offset) throws IOException {
        return buf.putByte(offset, this.value);
    }

    @Override
    int read(Buffer buf, int offset) throws IOException {
        this.value = buf.getByte(offset);
        return offset + 1;
    }

    @Override
    int readLength(Buffer buf, int offset) throws IOException {
        return 1;
    }

    @Override
    protected byte getFieldType() {
        return 0;
    }

    public String toString() {
        return "Byte: " + Byte.toString(this.value);
    }

    @Override
    public String getValueAsString() {
        return Integer.toHexString(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ByteField)) {
            return false;
        }
        return ((ByteField)obj).value == this.value;
    }

    @Override
    public int compareTo(Field o) {
        ByteField f = (ByteField)o;
        if (this.value == f.value) {
            return 0;
        }
        if (this.value < f.value) {
            return -1;
        }
        return 1;
    }

    @Override
    public Field newField(Field fieldValue) {
        if (fieldValue.isVariableLength()) {
            throw new AssertException();
        }
        return new ByteField((byte)fieldValue.getLongValue());
    }

    @Override
    public Field newField() {
        return new ByteField();
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    @Override
    public void setLongValue(long value) {
        this.value = (byte)value;
    }

    @Override
    public byte[] getBinaryData() {
        return new byte[]{this.value};
    }

    @Override
    public int hashCode() {
        return this.value;
    }
}

