/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.Query;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParametrizedFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.lookup.SearchLookup;

public class FieldNamesFieldMapper
extends MetadataFieldMapper {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(FieldNamesFieldMapper.class);
    public static final String NAME = "_field_names";
    public static final String CONTENT_TYPE = "_field_names";
    public static final String ENABLED_DEPRECATION_MESSAGE = "Disabling _field_names is not necessary because it no longer carries a large index overhead. Support for the `enabled` setting will be removed in a future major version. Please remove it from your mappings and templates.";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> new FieldNamesFieldMapper(Defaults.ENABLED, c.indexVersionCreated(), new FieldNamesFieldType(Defaults.ENABLED.value())), c -> new Builder(c.indexVersionCreated()));
    private final Explicit<Boolean> enabled;
    private final Version indexVersionCreated;

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.indexVersionCreated).init(this);
    }

    private static FieldNamesFieldMapper toType(FieldMapper in) {
        return (FieldNamesFieldMapper)in;
    }

    private FieldNamesFieldMapper(Explicit<Boolean> enabled, Version indexVersionCreated, FieldNamesFieldType mappedFieldType) {
        super(mappedFieldType);
        this.enabled = enabled;
        this.indexVersionCreated = indexVersionCreated;
    }

    @Override
    public FieldNamesFieldType fieldType() {
        return (FieldNamesFieldType)super.fieldType();
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        if (context.indexSettings().getIndexVersionCreated().before(Version.V_6_1_0)) {
            if (!this.fieldType().isEnabled()) {
                return;
            }
            for (ParseContext.Document document : context) {
                ArrayList<String> paths = new ArrayList<String>(document.getFields().size());
                String previousPath = "";
                for (IndexableField field : document.getFields()) {
                    String path = field.name();
                    if (path.equals(previousPath)) continue;
                    paths.add(path);
                    previousPath = path;
                }
                for (String path : paths) {
                    for (String fieldName : FieldNamesFieldMapper.extractFieldNames(path)) {
                        document.add((IndexableField)new Field(this.fieldType().name(), (CharSequence)fieldName, (IndexableFieldType)Defaults.FIELD_TYPE));
                    }
                }
            }
        }
    }

    static Iterable<String> extractFieldNames(final String fullPath) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int endIndex = this.nextEndIndex(0);

                    private int nextEndIndex(int index) {
                        while (index < fullPath.length() && fullPath.charAt(index) != '.') {
                            ++index;
                        }
                        return index;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.endIndex <= fullPath.length();
                    }

                    @Override
                    public String next() {
                        String result = fullPath.substring(0, this.endIndex);
                        this.endIndex = this.nextEndIndex(this.endIndex + 1);
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    protected String contentType() {
        return "_field_names";
    }

    public static final class FieldNamesFieldType
    extends TermBasedFieldType {
        private final boolean enabled;

        public FieldNamesFieldType(boolean enabled) {
            super("_field_names", true, false, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
            this.enabled = enabled;
        }

        @Override
        public String typeName() {
            return "_field_names";
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup lookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException("Cannot run exists query on _field_names");
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            if (!this.isEnabled()) {
                throw new IllegalStateException("Cannot run [exists] queries if the [_field_names] field is disabled");
            }
            deprecationLogger.deprecate("terms_query_on_field_names", "terms query on the _field_names field is deprecated and will be removed, use exists query instead", new Object[0]);
            return super.termQuery(value, context);
        }
    }

    static class Builder
    extends MetadataFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Explicit<Boolean>> enabled = MetadataFieldMapper.updateableBoolParam("enabled", m -> FieldNamesFieldMapper.access$300(FieldNamesFieldMapper.toType(m)), Defaults.ENABLED.value());
        private final Version indexVersionCreated;

        Builder(Version indexVersionCreated) {
            super("_field_names");
            this.indexVersionCreated = indexVersionCreated;
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Collections.singletonList(this.enabled);
        }

        @Override
        public FieldNamesFieldMapper build(Mapper.BuilderContext context) {
            if (this.enabled.getValue().explicit()) {
                deprecationLogger.deprecate("field_names_enabled_parameter", FieldNamesFieldMapper.ENABLED_DEPRECATION_MESSAGE, new Object[0]);
            }
            FieldNamesFieldType fieldNamesFieldType = new FieldNamesFieldType(this.enabled.getValue().value());
            return new FieldNamesFieldMapper(this.enabled.getValue(), this.indexVersionCreated, fieldNamesFieldType);
        }
    }

    public static class Defaults {
        public static final String NAME = "_field_names";
        public static final Explicit<Boolean> ENABLED = new Explicit<Boolean>(true, false);
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

